/*
 * Decompiled with CFR 0.152.
 */
package com.chestprotect.utils;

import com.chestprotect.ChestProtectPlugin;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MessageUtils {
    private final ChestProtectPlugin plugin;
    private final Map<String, String> messages = new HashMap<String, String>();

    public MessageUtils(ChestProtectPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        this.messages.clear();
        this.messages.put("prefix", "&8[&6ChestProtect&8] &r");
        this.messages.put("error.player_only", "This command can only be used by players.");
        this.messages.put("error.no_chest_found", "No chest found! Look at a chest to protect it.");
        this.messages.put("error.already_protected", "This chest is already protected.");
        this.messages.put("error.cant_protect_others", "You cannot protect chests for other players.");
        this.messages.put("error.break_protected_chest", "This chest is protected by &6{0}&r.");
        this.messages.put("error.break_protection_sign", "This sign is protecting a chest owned by &6{0}&r.");
        this.messages.put("error.player_offline", "Player &6{0}&r is not online.");
        this.messages.put("error.request_self", "You cannot request access to your own chest.");
        this.messages.put("error.no_protected_chests", "&6{0}&r does not have any protected chests.");
        this.messages.put("error.request_failed", "Failed to create access request. Please try again.");
        this.messages.put("error.request_pending", "You already have a pending request. Wait for a response or try again later.");
        this.messages.put("error.no_pending_request", "&6{0}&r has not requested access to your chests.");
        this.messages.put("error.access_denied", "&6{0}&r has denied your chest access request.");
        this.messages.put("error.no_sign_inventory", "You need to have a sign in your inventory to protect a chest.");
        this.messages.put("error.unknown_command", "Unknown command. Use /help for available commands.");
        this.messages.put("error.no_permission", "You don't have permission to use this command.");
        this.messages.put("success.chest_protected", "Chest protected successfully.");
        this.messages.put("success.chest_claimed", "Chest claimed successfully.");
        this.messages.put("success.request_sent", "Access request sent to &6{0}&r.");
        this.messages.put("success.request_accepted", "You have granted &6{0}&r temporary access to your chests.");
        this.messages.put("success.request_denied", "You have denied &6{0}&r access to your chests.");
        this.messages.put("success.access_granted", "&6{0}&r has granted you temporary access to their chests.");
        this.messages.put("success.config_reloaded", "ChestProtect configuration reloaded successfully.");
        this.messages.put("help.openrequest", "Usage: /openrequest <player>");
        this.messages.put("help.acceptrequest", "Usage: /acceptrequest <player>");
        this.messages.put("help.denyrequest", "Usage: /denyrequest <player>");
        this.messages.put("help.unlockchest", "Usage: /unlockchest - Look at a chest to unlock it");
        this.messages.put("help.claimchest", "Usage: /claimchest - Look at a chest to claim it (requires a sign in your inventory)");
        this.messages.put("help.admin.header", "&6========== ChestProtect Admin Commands ==========&r");
        this.messages.put("help.admin.reload", "&e/chestadmin reload&r - Reload plugin configuration");
        this.messages.put("help.admin.list", "&e/chestadmin list [player]&r - List all protected chests");
        this.messages.put("help.admin.info", "&e/chestadmin info&r - Show plugin information");
        this.messages.put("help.admin.help", "&e/chestadmin help&r - Show this help menu");
        this.messages.put("help.admin.footer", "&6==============================================&r");
        this.messages.put("request.access", "&6{0}&r is requesting access to your chests.");
        this.messages.put("request.chest_protected", "This chest is protected by &6{0}&r.");
        this.messages.put("request.send_request", "Send an access request with &6/openrequest {0}&r");
        this.messages.put("request.accept_command", "Type &a/acceptrequest {0}&r to accept.");
        this.messages.put("request.deny_command", "Type &c/denyrequest {0}&r to deny.");
        if (this.plugin.getConfig().contains("messages")) {
            this.loadConfigSection("messages", this.plugin.getConfig().getConfigurationSection("messages"));
        }
    }

    private void loadConfigSection(String parentPath, ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            String fullPath;
            String string = fullPath = parentPath.isEmpty() ? key : parentPath + "." + key;
            if (section.isConfigurationSection(key)) {
                this.loadConfigSection(fullPath, section.getConfigurationSection(key));
                continue;
            }
            String value = section.getString(key);
            if (value == null) continue;
            this.messages.put(fullPath, value);
        }
    }

    public String formatMessage(String key, Object ... args) {
        String message = this.messages.getOrDefault(key, "Missing message: " + key);
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("{" + i + "}", String.valueOf(args[i]));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void sendMessage(CommandSender sender, String key, Object ... args) {
        String message = this.messages.getOrDefault(key, "Missing message: " + key);
        String prefix = this.messages.getOrDefault("prefix", "");
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("{" + i + "}", String.valueOf(args[i]));
        }
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + message)));
    }

    public void sendRequestAccessMessage(Player player, String owner, Location location) {
        String prefix = this.messages.getOrDefault("prefix", "");
        String protectedMsg = this.messages.getOrDefault("request.chest_protected", "This chest is protected by &6{0}&r.");
        String requestMsg = this.messages.getOrDefault("request.send_request", "Send an access request with &6/openrequest {0}&r");
        protectedMsg = protectedMsg.replace("{0}", owner);
        requestMsg = requestMsg.replace("{0}", owner);
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + protectedMsg)));
        try {
            TextComponent message = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + requestMsg)));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/openrequest " + owner));
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to request access").create()));
            player.spigot().sendMessage((BaseComponent)message);
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + requestMsg)));
        }
    }

    public void sendRequestNotification(Player owner, String requester) {
        String prefix = this.messages.getOrDefault("prefix", "");
        String requestMsg = this.messages.getOrDefault("request.access", "&6{0}&r is requesting access to your chests.");
        requestMsg = requestMsg.replace("{0}", requester);
        owner.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + requestMsg)));
        try {
            TextComponent acceptComponent = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)"&a[Accept]"));
            acceptComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/acceptrequest " + requester));
            acceptComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to accept the request").create()));
            TextComponent denyComponent = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)" &c[Deny]"));
            denyComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/denyrequest " + requester));
            denyComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to deny the request").create()));
            TextComponent prefixComponent = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)prefix));
            prefixComponent.addExtra((BaseComponent)acceptComponent);
            prefixComponent.addExtra((BaseComponent)denyComponent);
            owner.spigot().sendMessage((BaseComponent)prefixComponent);
        }
        catch (Exception e) {
            String acceptMsg = this.messages.getOrDefault("request.accept_command", "Type &a/acceptrequest {0}&r to accept.");
            String denyMsg = this.messages.getOrDefault("request.deny_command", "Type &c/denyrequest {0}&r to deny.");
            acceptMsg = acceptMsg.replace("{0}", requester);
            denyMsg = denyMsg.replace("{0}", requester);
            owner.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + acceptMsg)));
            owner.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + denyMsg)));
        }
    }
}

