/*
 * Decompiled with CFR 0.152.
 */
package com.flashlighttlg;

import com.flashlighttlg.FlashlightConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLightManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"flashlighttlg-dynamiclight");
    private static final Map<UUID, Map<class_2338, class_2680>> playerLights = new HashMap<UUID, Map<class_2338, class_2680>>();
    private static final Map<UUID, Boolean> playerLightStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, class_243> lastPlayerPositions = new HashMap<UUID, class_243>();
    private static final Map<UUID, Float> lastPlayerYaws = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastPlayerPitches = new HashMap<UUID, Float>();

    public static void togglePlayerLight(class_1657 player) {
        UUID playerId;
        boolean currentState = playerLightStates.getOrDefault(playerId = player.method_5667(), false);
        playerLightStates.put(playerId, !currentState);
        if (!currentState) {
            DynamicLightManager.createPlayerLight(player);
        } else {
            DynamicLightManager.removePlayerLight(playerId, player.method_37908());
        }
        if (FlashlightConfig.SHOW_MESSAGES) {
            LOGGER.info("Player {} dynamic light toggled: {}", (Object)player.method_5477().getString(), (Object)(!currentState ? 1 : 0));
        }
    }

    public static boolean isPlayerLightOn(class_1657 player) {
        return playerLightStates.getOrDefault(player.method_5667(), false);
    }

    public static void updatePlayerLight(class_1657 player) {
        if (!DynamicLightManager.isPlayerLightOn(player)) {
            return;
        }
        UUID playerId = player.method_5667();
        if (DynamicLightManager.shouldUpdateLight(player)) {
            DynamicLightManager.removePlayerLight(playerId, player.method_37908());
            DynamicLightManager.createPlayerLight(player);
            DynamicLightManager.updateCache(player);
        }
    }

    private static boolean shouldUpdateLight(class_1657 player) {
        UUID playerId = player.method_5667();
        class_243 currentPos = player.method_19538();
        float currentYaw = player.method_36454();
        float currentPitch = player.method_36455();
        class_243 lastPos = lastPlayerPositions.get(playerId);
        Float lastYaw = lastPlayerYaws.get(playerId);
        Float lastPitch = lastPlayerPitches.get(playerId);
        if (lastPos == null || lastYaw == null || lastPitch == null) {
            return true;
        }
        double distanceMoved = currentPos.method_1022(lastPos);
        if (distanceMoved > 0.1) {
            return true;
        }
        float yawDiff = Math.abs(currentYaw - lastYaw.floatValue());
        float pitchDiff = Math.abs(currentPitch - lastPitch.floatValue());
        return (double)yawDiff > 2.0 || (double)pitchDiff > 2.0;
    }

    private static void updateCache(class_1657 player) {
        UUID playerId = player.method_5667();
        lastPlayerPositions.put(playerId, player.method_19538());
        lastPlayerYaws.put(playerId, Float.valueOf(player.method_36454()));
        lastPlayerPitches.put(playerId, Float.valueOf(player.method_36455()));
    }

    private static void createPlayerLight(class_1657 player) {
        UUID playerId = player.method_5667();
        class_243 playerPos = player.method_19538().method_1031(0.0, (double)player.method_18381(player.method_18376()), 0.0);
        float yaw = player.method_36454();
        float pitch = player.method_36455();
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        double lookX = -Math.sin(yawRad) * Math.cos(pitchRad);
        double lookY = -Math.sin(pitchRad);
        double lookZ = Math.cos(yawRad) * Math.cos(pitchRad);
        class_243 lookVec = new class_243(lookX, lookY, lookZ).method_1029();
        HashMap<class_2338, class_2680> lights = new HashMap<class_2338, class_2680>();
        class_1937 world = player.method_37908();
        if (world == null) {
            return;
        }
        double maxDistance = FlashlightConfig.CONE_LENGTH;
        double startDistance = FlashlightConfig.START_DISTANCE;
        String lightMode = FlashlightConfig.getCurrentMode();
        if ("cone".equals(lightMode)) {
            DynamicLightManager.createConeLight(player, playerPos, lookVec, lights, world, maxDistance, startDistance);
        } else if ("fixed".equals(lightMode)) {
            DynamicLightManager.createFixedCircleLight(player, playerPos, lookVec, lights, world, maxDistance, startDistance);
        } else if ("mini".equals(lightMode)) {
            DynamicLightManager.createMiniCircleLight(player, playerPos, lookVec, lights, world, maxDistance, startDistance);
        }
        playerLights.put(playerId, lights);
        if (FlashlightConfig.DEBUG_LOGGING) {
            LOGGER.info("Created {} light sources for player {} in {} mode", new Object[]{lights.size(), playerId, lightMode});
        }
    }

    private static void createConeLight(class_1657 player, class_243 playerPos, class_243 lookVec, Map<class_2338, class_2680> lights, class_1937 world, double maxDistance, double startDistance) {
        double radius;
        for (double distance = startDistance; distance <= maxDistance && !((radius = DynamicLightManager.calculateMinimalFlashlightRadius(distance, maxDistance)) > 0.8); distance += 0.4) {
            int steps = Math.max(2, (int)(radius * 2.0));
            for (int i = 0; i < steps; ++i) {
                for (int j = 0; j < steps; ++j) {
                    double offsetX = ((double)i - (double)steps / 2.0) * (2.0 * radius / (double)steps);
                    double offsetZ = ((double)j - (double)steps / 2.0) * (2.0 * radius / (double)steps);
                    double distanceFromCenter = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
                    if (distanceFromCenter > radius) continue;
                    class_243 lightPos = playerPos.method_1031(lookVec.field_1352 * distance + offsetX, lookVec.field_1351 * distance, lookVec.field_1350 * distance + offsetZ);
                    class_2338 blockPos = new class_2338((int)lightPos.field_1352, (int)lightPos.field_1351, (int)lightPos.field_1350);
                    if (!world.method_24794(blockPos)) continue;
                    class_2680 currentState = world.method_8320(blockPos);
                    int lightLevel = DynamicLightManager.calculateMinimalLightLevel(distance, radius, distanceFromCenter);
                    if (lightLevel <= 0) continue;
                    class_2680 lightBlock = class_2246.field_31037.method_9564();
                    if (!currentState.method_26215() && currentState.method_26204() != class_2246.field_31037) continue;
                    lights.put(blockPos, lightBlock);
                    world.method_8501(blockPos, lightBlock);
                    if (!FlashlightConfig.DEBUG_LOGGING) continue;
                    LOGGER.debug("Created cone light block at {} with level {} (distance: {}, radius: {})", new Object[]{blockPos, lightLevel, distance, radius});
                }
            }
        }
    }

    private static void createFixedCircleLight(class_1657 player, class_243 playerPos, class_243 lookVec, Map<class_2338, class_2680> lights, class_1937 world, double maxDistance, double startDistance) {
        double fixedRadius = 0.3;
        double fixedDistance = 3.0;
        int steps = Math.max(6, (int)(fixedRadius * 8.0));
        for (int i = 0; i < steps; ++i) {
            for (int j = 0; j < steps; ++j) {
                double offsetX = ((double)i - (double)steps / 2.0) * (2.0 * fixedRadius / (double)steps);
                double offsetZ = ((double)j - (double)steps / 2.0) * (2.0 * fixedRadius / (double)steps);
                double distanceFromCenter = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
                if (distanceFromCenter > fixedRadius) continue;
                class_243 lightPos = playerPos.method_1031(lookVec.field_1352 * fixedDistance + offsetX, lookVec.field_1351 * fixedDistance, lookVec.field_1350 * fixedDistance + offsetZ);
                class_2338 blockPos = new class_2338((int)lightPos.field_1352, (int)lightPos.field_1351, (int)lightPos.field_1350);
                if (!world.method_24794(blockPos)) continue;
                class_2680 currentState = world.method_8320(blockPos);
                int lightLevel = 15;
                if (lightLevel <= 0) continue;
                class_2680 lightBlock = class_2246.field_31037.method_9564();
                if (!currentState.method_26215() && currentState.method_26204() != class_2246.field_31037) continue;
                lights.put(blockPos, lightBlock);
                world.method_8501(blockPos, lightBlock);
                if (!FlashlightConfig.DEBUG_LOGGING) continue;
                LOGGER.debug("Created fixed circle light block at {} with level {} (distance: {}, radius: {})", new Object[]{blockPos, lightLevel, fixedDistance, fixedRadius});
            }
        }
    }

    private static void createMiniCircleLight(class_1657 player, class_243 playerPos, class_243 lookVec, Map<class_2338, class_2680> lights, class_1937 world, double maxDistance, double startDistance) {
        double miniRadius = 0.3;
        double miniDistance = 5.0;
        int steps = Math.max(6, (int)(miniRadius * 8.0));
        for (int i = 0; i < steps; ++i) {
            for (int j = 0; j < steps; ++j) {
                double offsetX = ((double)i - (double)steps / 2.0) * (2.0 * miniRadius / (double)steps);
                double offsetZ = ((double)j - (double)steps / 2.0) * (2.0 * miniRadius / (double)steps);
                double distanceFromCenter = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
                if (distanceFromCenter > miniRadius) continue;
                class_243 lightPos = playerPos.method_1031(lookVec.field_1352 * miniDistance + offsetX, lookVec.field_1351 * miniDistance, lookVec.field_1350 * miniDistance + offsetZ);
                class_2338 blockPos = new class_2338((int)lightPos.field_1352, (int)lightPos.field_1351, (int)lightPos.field_1350);
                if (!world.method_24794(blockPos)) continue;
                class_2680 currentState = world.method_8320(blockPos);
                int lightLevel = 15;
                if (lightLevel <= 0) continue;
                class_2680 lightBlock = class_2246.field_31037.method_9564();
                if (!currentState.method_26215() && currentState.method_26204() != class_2246.field_31037) continue;
                lights.put(blockPos, lightBlock);
                world.method_8501(blockPos, lightBlock);
                if (!FlashlightConfig.DEBUG_LOGGING) continue;
                LOGGER.debug("Created mini circle light block at {} with level {} (distance: {}, radius: {})", new Object[]{blockPos, lightLevel, miniDistance, miniRadius});
            }
        }
    }

    private static double calculateMinimalFlashlightRadius(double distance, double maxDistance) {
        double startRadius = 0.1;
        double endRadius = 0.5;
        double progress = (distance - FlashlightConfig.START_DISTANCE) / (maxDistance - FlashlightConfig.START_DISTANCE);
        progress = Math.max(0.0, Math.min(1.0, progress));
        double smoothProgress = progress * progress;
        return startRadius + (endRadius - startRadius) * smoothProgress;
    }

    private static int calculateMinimalLightLevel(double distance, double radius, double distanceFromCenter) {
        int baseLevel = FlashlightConfig.MAX_LIGHT_LEVEL / 2;
        double maxDistance = FlashlightConfig.CONE_LENGTH;
        double distanceFactor = Math.max(0.3, 1.0 - (distance - FlashlightConfig.START_DISTANCE) / maxDistance);
        double centerFactor = Math.max(0.4, 1.0 - distanceFromCenter / radius * 0.6);
        double finalLevel = (double)baseLevel * distanceFactor * centerFactor;
        return Math.max(1, (int)finalLevel);
    }

    private static void removePlayerLight(UUID playerId, class_1937 world) {
        Map<class_2338, class_2680> lights = playerLights.remove(playerId);
        if (lights != null && world != null) {
            for (class_2338 pos : lights.keySet()) {
                class_2680 currentState;
                if (!world.method_24794(pos) || (currentState = world.method_8320(pos)).method_26204() != class_2246.field_31037) continue;
                world.method_8501(pos, class_2246.field_10124.method_9564());
                if (!FlashlightConfig.DEBUG_LOGGING) continue;
                LOGGER.debug("Removed light block at {}", (Object)pos);
            }
            if (FlashlightConfig.DEBUG_LOGGING) {
                LOGGER.debug("Removed {} light sources for player {}", (Object)lights.size(), (Object)playerId);
            }
        }
    }

    public static void removePlayer(UUID playerId) {
        playerLightStates.remove(playerId);
        lastPlayerPositions.remove(playerId);
        lastPlayerYaws.remove(playerId);
        lastPlayerPitches.remove(playerId);
    }

    public static void clearAllLights() {
        playerLightStates.clear();
        playerLights.clear();
        lastPlayerPositions.clear();
        lastPlayerYaws.clear();
        lastPlayerPitches.clear();
        LOGGER.info("Cleared all dynamic lights");
    }
}

