/*
 * Decompiled with CFR 0.152.
 */
package com.flashlighttlg;

import com.flashlighttlg.DynamicLightManager;
import com.flashlighttlg.ExampleMod;
import com.flashlighttlg.FlashlightConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ExampleModClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"flashlighttlg-client");
    private static boolean flashlightOn = false;
    private static class_304 flashlightKey;
    private static int updateCounter;
    private static long lastToggleTime;
    private static final long SHOW_DURATION = 2000L;
    private static boolean showIndicator;

    public void onInitializeClient() {
        LOGGER.info("Player Flashlight client initialized!");
        FlashlightConfig.loadConfig();
        LOGGER.info("Flashlight configuration loaded in client");
        flashlightKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.flashlighttlg.toggle", class_3675.class_307.field_1668, 70, "category.flashlighttlg.main"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (flashlightKey.method_1436()) {
                this.toggleFlashlight();
            }
            class_746 player = client.field_1724;
            if (player != null && flashlightOn && ++updateCounter % FlashlightConfig.UPDATE_FREQUENCY_TICKS == 0) {
                DynamicLightManager.updatePlayerLight((class_1657)player);
            }
        });
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && flashlightOn && FlashlightConfig.DEBUG_LOGGING) {
                LOGGER.debug("Flashlight cone rendering disabled for optimization");
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> this.renderFlashlightIndicator(drawContext));
        LOGGER.info("Flashlight client events registered successfully!");
        if (FlashlightConfig.DEBUG_LOGGING) {
            LOGGER.info("Testing flashlight sound...");
            new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                    this.playToggleSound();
                    Thread.sleep(1000L);
                    this.testSound();
                    LOGGER.info("Flashlight sound test completed");
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Sound test interrupted");
                }
            }).start();
        }
    }

    private void toggleFlashlight() {
        flashlightOn = !flashlightOn;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            DynamicLightManager.togglePlayerLight((class_1657)player);
            lastToggleTime = System.currentTimeMillis();
            showIndicator = true;
            this.playToggleSound();
            LOGGER.info("Flashlight toggled: {}", (Object)flashlightOn);
        }
    }

    private void playToggleSound() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            LOGGER.warn("Cannot play sound: player is null");
            return;
        }
        LOGGER.info("Attempting to play flashlight toggle sound...");
        LOGGER.info("Sound settings - Master: {}", (Object)Float.valueOf(client.field_1690.method_1630(class_3419.field_15250)));
        try {
            String currentSound = FlashlightConfig.getCurrentSound();
            LOGGER.info("Current flashlight sound: {}", (Object)currentSound);
            client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)(switch (currentSound) {
                case "default" -> class_3417.field_14791;
                case "stone" -> class_3417.field_14791;
                case "wooden" -> class_3417.field_14699;
                default -> class_3417.field_14962;
            }), (float)2.0f));
            LOGGER.info("\u2705 Flashlight toggle sound played: {}", (Object)currentSound);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in playToggleSound: {}", (Object)e.getMessage(), (Object)e);
            try {
                client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14791, (float)2.0f));
                LOGGER.info("\u2705 Fallback sound played successfully");
            }
            catch (Exception fallbackError) {
                LOGGER.error("\u274c Even fallback sound failed: {}", (Object)fallbackError.getMessage());
            }
        }
    }

    private void testSound() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            LOGGER.warn("Cannot test sound: player is null");
            return;
        }
        LOGGER.info("Testing test sound...");
        try {
            client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14791, (float)2.0f));
            LOGGER.info("\u2705 Test 1: Standard Minecraft sound played");
            client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ExampleMod.TEST_SOUND_EVENT, (float)2.0f));
            LOGGER.info("\u2705 Test 2: Our test sound played");
        }
        catch (Exception e) {
            LOGGER.error("\u274c Test sound failed: {}", (Object)e.getMessage());
        }
    }

    private void renderFlashlightIndicator(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1755 != null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (showIndicator && currentTime - lastToggleTime > 2000L) {
            showIndicator = false;
        }
        if (!showIndicator) {
            return;
        }
        class_327 textRenderer = client.field_1772;
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int x = screenWidth / 2;
        int y = screenHeight - 54;
        String keyName = flashlightKey.method_16007().getString();
        String text = flashlightOn ? "\u00a7f\u0424\u043e\u043d\u0430\u0440\u0438\u043a \u00a7a\u0432\u043a\u043b\u044e\u0447\u0435\u043d \u00a77[" + keyName + "]" : "\u00a7f\u0424\u043e\u043d\u0430\u0440\u0438\u043a \u00a7c\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u00a77[" + keyName + "]";
        int textWidth = textRenderer.method_1727(text);
        int padding = 6;
        long timeSinceToggle = currentTime - lastToggleTime;
        float alpha = 1.0f;
        if (timeSinceToggle < 200L) {
            alpha = (float)timeSinceToggle / 200.0f;
        } else if (timeSinceToggle > 1800L) {
            alpha = (float)(2000L - timeSinceToggle) / 200.0f;
        }
        int backgroundColor = (int)(102.0f * alpha) << 24 | 0;
        context.method_25294(x - textWidth / 2 - padding, y - 2, x + textWidth / 2 + padding, y + 12, backgroundColor);
        context.method_27535(textRenderer, (class_2561)class_2561.method_43470((String)text), x - textWidth / 2, y, -1);
        if (FlashlightConfig.DEBUG_LOGGING) {
            LOGGER.debug("Rendering flashlight indicator: {} at ({}, {}) with alpha: {}", new Object[]{text, x, y, Float.valueOf(alpha)});
        }
        if (updateCounter % 200 == 0) {
            LOGGER.info("Flashlight indicator called: flashlightOn={}, text='{}', showIndicator={}, alpha={}", new Object[]{flashlightOn, text, showIndicator, Float.valueOf(alpha)});
        }
        String statusText = flashlightOn ? "\u00a7a\u25cf" : "\u00a7c\u25cf";
        int statusX = x + textWidth / 2 + 10;
        context.method_27535(textRenderer, (class_2561)class_2561.method_43470((String)statusText), statusX, y, -1);
    }

    public static boolean isFlashlightOn() {
        return flashlightOn;
    }

    static {
        updateCounter = 0;
        lastToggleTime = 0L;
        showIndicator = false;
    }
}

