/*
 * Decompiled with CFR 0.152.
 */
package com.flashlighttlg;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashlightConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"flashlighttlg-config");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "flashlighttlg.json";
    public static double CONE_LENGTH = 20.0;
    public static double CONE_ANGLE_DEGREES = 0.5;
    public static double START_DISTANCE = 1.0;
    public static int MAX_LIGHT_LEVEL = 15;
    public static int UPDATE_FREQUENCY_TICKS = 2;
    public static double ANGLE_RANGE_DEGREES = 0.3;
    public static double ANGLE_STEP_DEGREES = 0.2;
    public static String FLASHLIGHT_SIZE = "standard";
    public static String DEFAULT_SIZE = "standard";
    public static String LIGHT_MODE = "cone";
    public static String DEFAULT_MODE = "cone";
    public static String FLASHLIGHT_SOUND = "lever";
    public static String DEFAULT_SOUND = "lever";
    public static String TOGGLE_KEY = "F";
    public static String KEY_DESCRIPTION = "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c/\u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0444\u043e\u043d\u0430\u0440\u0438\u043a";
    public static boolean SHOW_MESSAGES = false;
    public static boolean DEBUG_LOGGING = false;
    public static boolean PARTICLE_EFFECTS = false;
    public static int MAX_LIGHT_BLOCKS_PER_PLAYER = 100;
    public static boolean CLEANUP_ON_SERVER_STOP = true;
    public static boolean OPTIMIZE_LIGHT_PLACEMENT = true;
    private static final Map<String, FlashlightSize> SIZES = new HashMap<String, FlashlightSize>();

    public static void loadConfig() {
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE);
            File configFile = configPath.toFile();
            if (!configFile.exists()) {
                FlashlightConfig.createDefaultConfig(configFile);
                LOGGER.info("\u0421\u043e\u0437\u0434\u0430\u043d \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: {}", (Object)configPath);
            }
            try (FileReader reader = new FileReader(configFile);){
                ConfigData config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                FlashlightConfig.applyConfig(config);
                LOGGER.info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: {}", (Object)e.getMessage());
            LOGGER.info("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        }
    }

    private static void createDefaultConfig(File configFile) throws IOException {
        ConfigData defaultConfig = new ConfigData();
        defaultConfig.flashlight_settings = new FlashlightSettings();
        defaultConfig.flashlight_sizes = new HashMap<String, FlashlightSize>();
        defaultConfig.keybind_settings = new KeybindSettings();
        defaultConfig.visual_settings = new VisualSettings();
        defaultConfig.performance_settings = new PerformanceSettings();
        defaultConfig.flashlight_sizes.put("small", new FlashlightSize("\u041c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u0439", "\u041e\u0447\u0435\u043d\u044c \u0443\u0437\u043a\u0438\u0439 \u043a\u0430\u0440\u043c\u0430\u043d\u043d\u044b\u0439 \u0444\u043e\u043d\u0430\u0440\u0438\u043a", 15.0, 0.2, 0.5, 12, "\u00a7a"));
        defaultConfig.flashlight_sizes.put("standard", new FlashlightSize("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439", "\u0423\u0437\u043a\u0438\u0439 \u0444\u043e\u043d\u0430\u0440\u0438\u043a \u0441\u0440\u0435\u0434\u043d\u0435\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430", 20.0, 0.5, 1.0, 15, "\u00a7e"));
        defaultConfig.flashlight_sizes.put("large", new FlashlightSize("\u0411\u043e\u043b\u044c\u0448\u043e\u0439", "\u041c\u043e\u0449\u043d\u044b\u0439 \u0443\u0437\u043a\u0438\u0439 \u043f\u0440\u043e\u0436\u0435\u043a\u0442\u043e\u0440 \u0434\u043b\u044f \u0434\u0430\u043b\u044c\u043d\u0435\u0433\u043e \u043e\u0441\u0432\u0435\u0449\u0435\u043d\u0438\u044f", 25.0, 0.8, 1.5, 15, "\u00a76"));
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)defaultConfig, (Appendable)writer);
        }
    }

    private static void applyConfig(ConfigData config) {
        if (config.flashlight_settings != null) {
            CONE_LENGTH = config.flashlight_settings.cone_length;
            CONE_ANGLE_DEGREES = config.flashlight_settings.cone_angle_degrees;
            START_DISTANCE = config.flashlight_settings.start_distance;
            MAX_LIGHT_LEVEL = config.flashlight_settings.max_light_level;
            UPDATE_FREQUENCY_TICKS = config.flashlight_settings.update_frequency_ticks;
            ANGLE_RANGE_DEGREES = config.flashlight_settings.angle_range_degrees;
            ANGLE_STEP_DEGREES = config.flashlight_settings.angle_step_degrees;
            FLASHLIGHT_SIZE = config.flashlight_settings.flashlight_size;
            DEFAULT_SIZE = config.flashlight_settings.default_size;
            LIGHT_MODE = config.flashlight_settings.light_mode;
            DEFAULT_MODE = config.flashlight_settings.default_mode;
            if (DEFAULT_SIZE != null && !DEFAULT_SIZE.isEmpty()) {
                FlashlightConfig.applyDefaultSize(DEFAULT_SIZE);
            }
        }
        if (config.flashlight_sizes != null) {
            FlashlightConfig.loadSizes(config.flashlight_sizes);
        }
        if (config.keybind_settings != null) {
            TOGGLE_KEY = config.keybind_settings.toggle_key;
            KEY_DESCRIPTION = config.keybind_settings.key_description;
        }
        if (config.visual_settings != null) {
            SHOW_MESSAGES = config.visual_settings.show_messages;
            DEBUG_LOGGING = config.visual_settings.debug_logging;
            PARTICLE_EFFECTS = config.visual_settings.particle_effects;
        }
        if (config.performance_settings != null) {
            MAX_LIGHT_BLOCKS_PER_PLAYER = config.performance_settings.max_light_blocks_per_player;
            CLEANUP_ON_SERVER_STOP = config.performance_settings.cleanup_on_server_stop;
            OPTIMIZE_LIGHT_PLACEMENT = config.performance_settings.optimize_light_placement;
        }
    }

    private static void loadSizes(Map<String, FlashlightSize> sizes) {
        SIZES.clear();
        SIZES.putAll(sizes);
        LOGGER.info("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e {} \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u0432 \u0444\u043e\u043d\u0430\u0440\u0438\u043a\u0430", (Object)sizes.size());
    }

    private static void applyDefaultSize(String sizeName) {
        FlashlightSize size = SIZES.get(sizeName);
        if (size != null) {
            CONE_LENGTH = size.cone_length;
            CONE_ANGLE_DEGREES = size.cone_angle_degrees;
            START_DISTANCE = size.start_distance;
            MAX_LIGHT_LEVEL = size.max_light_level;
            FLASHLIGHT_SIZE = sizeName;
            LOGGER.info("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e '{}': {}", (Object)sizeName, (Object)size.description);
        } else {
            LOGGER.warn("\u0420\u0430\u0437\u043c\u0435\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e '{}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", (Object)sizeName);
        }
    }

    public static Map<String, FlashlightSize> getAvailableSizes() {
        return new HashMap<String, FlashlightSize>(SIZES);
    }

    public static void setSize(String sizeName) {
        FlashlightSize size = SIZES.get(sizeName);
        if (size != null) {
            CONE_LENGTH = size.cone_length;
            CONE_ANGLE_DEGREES = size.cone_angle_degrees;
            START_DISTANCE = size.start_distance;
            MAX_LIGHT_LEVEL = size.max_light_level;
            FLASHLIGHT_SIZE = sizeName;
            LOGGER.info("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d \u0440\u0430\u0437\u043c\u0435\u0440 '{}': {}", (Object)sizeName, (Object)size.description);
        } else {
            LOGGER.warn("\u0420\u0430\u0437\u043c\u0435\u0440 '{}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", (Object)sizeName);
        }
    }

    public static void setMode(String modeName) {
        if ("cone".equals(modeName) || "fixed".equals(modeName) || "mini".equals(modeName)) {
            LIGHT_MODE = modeName;
            LOGGER.info("\u0420\u0435\u0436\u0438\u043c \u0444\u043e\u043d\u0430\u0440\u0438\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043d\u0430: {}", (Object)modeName);
        } else {
            LOGGER.warn("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u0444\u043e\u043d\u0430\u0440\u0438\u043a\u0430: {}", (Object)modeName);
        }
    }

    public static String getCurrentMode() {
        return LIGHT_MODE;
    }

    public static void setSound(String soundName) {
        if ("default".equals(soundName) || "lever".equals(soundName) || "stone".equals(soundName) || "wooden".equals(soundName)) {
            FLASHLIGHT_SOUND = soundName;
            LOGGER.info("\u0417\u0432\u0443\u043a \u0444\u043e\u043d\u0430\u0440\u0438\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043d\u0430: {}", (Object)soundName);
        } else {
            LOGGER.warn("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0437\u0432\u0443\u043a \u0444\u043e\u043d\u0430\u0440\u0438\u043a\u0430: {}", (Object)soundName);
        }
    }

    public static String getCurrentSound() {
        return FLASHLIGHT_SOUND;
    }

    static {
        SIZES.put("small", new FlashlightSize("\u041c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u0439", "\u041e\u0447\u0435\u043d\u044c \u0443\u0437\u043a\u0438\u0439 \u043a\u0430\u0440\u043c\u0430\u043d\u043d\u044b\u0439 \u0444\u043e\u043d\u0430\u0440\u0438\u043a", 15.0, 0.2, 0.5, 12, "\u00a7a"));
        SIZES.put("standard", new FlashlightSize("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439", "\u0423\u0437\u043a\u0438\u0439 \u0444\u043e\u043d\u0430\u0440\u0438\u043a \u0441\u0440\u0435\u0434\u043d\u0435\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430", 20.0, 0.5, 1.0, 15, "\u00a7e"));
        SIZES.put("large", new FlashlightSize("\u0411\u043e\u043b\u044c\u0448\u043e\u0439", "\u041c\u043e\u0449\u043d\u044b\u0439 \u0443\u0437\u043a\u0438\u0439 \u043f\u0440\u043e\u0436\u0435\u043a\u0442\u043e\u0440 \u0434\u043b\u044f \u0434\u0430\u043b\u044c\u043d\u0435\u0433\u043e \u043e\u0441\u0432\u0435\u0449\u0435\u043d\u0438\u044f", 25.0, 0.8, 1.5, 15, "\u00a76"));
    }

    public static class ConfigData {
        public FlashlightSettings flashlight_settings;
        public Map<String, FlashlightSize> flashlight_sizes;
        public KeybindSettings keybind_settings;
        public VisualSettings visual_settings;
        public PerformanceSettings performance_settings;
    }

    public static class FlashlightSettings {
        public double cone_length = 8.0;
        public double cone_angle_degrees = 1.5;
        public double start_distance = 1.0;
        public int max_light_level = 15;
        public int update_frequency_ticks = 2;
        public double angle_range_degrees = 1.0;
        public double angle_step_degrees = 0.5;
        public String flashlight_size = "standard";
        public String default_size = "standard";
        public String light_mode = "cone";
        public String default_mode = "cone";
    }

    public static class KeybindSettings {
        public String toggle_key = "F";
        public String key_description = "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c/\u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0444\u043e\u043d\u0430\u0440\u0438\u043a";
    }

    public static class VisualSettings {
        public boolean show_messages = true;
        public boolean debug_logging = false;
        public boolean particle_effects = false;
    }

    public static class PerformanceSettings {
        public int max_light_blocks_per_player = 100;
        public boolean cleanup_on_server_stop = true;
        public boolean optimize_light_placement = true;
    }

    public static class FlashlightSize {
        public String name;
        public String description;
        public double cone_length;
        public double cone_angle_degrees;
        public double start_distance;
        public int max_light_level;
        public String color;

        public FlashlightSize() {
        }

        public FlashlightSize(String name, String description, double coneLength, double coneAngleDegrees, double startDistance, int maxLightLevel, String color) {
            this.name = name;
            this.description = description;
            this.cone_length = coneLength;
            this.cone_angle_degrees = coneAngleDegrees;
            this.start_distance = startDistance;
            this.max_light_level = maxLightLevel;
            this.color = color;
        }
    }
}

