/*
 * Decompiled with CFR 0.152.
 */
package com.flashlighttlg;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashlightManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"flashlighttlg");
    private static final Map<UUID, Boolean> flashlightStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Map<class_2338, class_2680>> playerLights = new HashMap<UUID, Map<class_2338, class_2680>>();

    public static void toggleFlashlight(class_1657 player) {
        UUID playerId;
        boolean currentState = flashlightStates.getOrDefault(playerId = player.method_5667(), false);
        flashlightStates.put(playerId, !currentState);
        FlashlightManager.clearPlayerLights(playerId);
        LOGGER.info("Player {} flashlight toggled: {}", (Object)player.method_5477().getString(), (Object)(!currentState ? 1 : 0));
    }

    public static boolean isFlashlightOn(class_1657 player) {
        return flashlightStates.getOrDefault(player.method_5667(), false);
    }

    public static void updatePlayerLight(class_1657 player) {
        if (!FlashlightManager.isFlashlightOn(player)) {
            return;
        }
        UUID playerId = player.method_5667();
        class_243 playerPos = player.method_19538().method_1031(0.0, (double)player.method_18381(player.method_18376()), 0.0);
        class_243 lookVec = player.method_5828(1.0f);
        double coneLength = 10.0;
        double coneAngle = Math.toRadians(20.0);
        HashMap<class_2338, class_2680> lights = new HashMap<class_2338, class_2680>();
        for (double distance = 1.0; distance <= coneLength; distance += 0.5) {
            double radius = distance * Math.tan(coneAngle);
            for (double angle = 0.0; angle < Math.PI * 2; angle += 0.19634954084936207) {
                class_2680 currentState;
                double x = radius * Math.cos(angle);
                double z = radius * Math.sin(angle);
                class_243 lightPos = playerPos.method_1031(lookVec.field_1352 * distance + x, lookVec.field_1351 * distance, lookVec.field_1350 * distance + z);
                class_2338 blockPos = new class_2338((int)lightPos.field_1352, (int)lightPos.field_1351, (int)lightPos.field_1350);
                class_1937 world = player.method_37908();
                if (world == null || !world.method_24794(blockPos) || !(currentState = world.method_8320(blockPos)).method_26215() && currentState.method_26204() != class_2246.field_31037) continue;
                lights.put(blockPos, class_2246.field_31037.method_9564());
            }
        }
        playerLights.put(playerId, lights);
    }

    private static void clearPlayerLights(UUID playerId) {
        Map<class_2338, class_2680> lights = playerLights.remove(playerId);
        if (lights != null) {
            // empty if block
        }
    }

    public static void removePlayer(UUID playerId) {
        flashlightStates.remove(playerId);
        FlashlightManager.clearPlayerLights(playerId);
    }
}

