/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1122.BuilderItem;
import mcinterface1122.BuilderTileEntity;
import mcinterface1122.BuilderTileEntityEnergyCharger;
import mcinterface1122.BuilderTileEntityFluidTank;
import mcinterface1122.BuilderTileEntityInventoryContainer;
import mcinterface1122.WrapperItemStack;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class BuilderBlock
extends Block {
    protected static final Map<ABlockBase, BuilderBlock> blockMap = new HashMap<ABlockBase, BuilderBlock>();
    protected final ABlockBase block;
    private static final Map<BlockPos, IWrapperItemStack> stackAtPositions = new HashMap<BlockPos, IWrapperItemStack>();

    BuilderBlock(ABlockBase block) {
        super(Material.field_151576_e);
        this.block = block;
        this.field_149787_q = false;
        this.func_149711_c(block.hardness);
        this.func_149752_b(block.blastResistance);
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.block instanceof ABlockBaseTileEntity;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (ITileEntityFluidTankProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return BuilderBlock.getTileEntityTankWrapper(this.block);
        }
        if (ITileEntityInventoryProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return BuilderBlock.getTileEntityInventoryWrapper(this.block);
        }
        if (ITileEntityEnergyCharger.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return BuilderBlock.getTileEntityChargerWrapper(this.block);
        }
        return BuilderBlock.getTileEntityGenericWrapper(this.block);
    }

    private static <TileEntityType extends ATileEntityBase<?>> BuilderTileEntity<TileEntityType> getTileEntityGenericWrapper(ABlockBase block) {
        return new BuilderTileEntity();
    }

    private static <TileEntityType extends ATileEntityBase<?>> BuilderTileEntity<TileEntityType> getTileEntityInventoryWrapper(ABlockBase block) {
        return new BuilderTileEntityInventoryContainer();
    }

    private static <TileEntityType extends ATileEntityBase<?>> BuilderTileEntity<TileEntityType> getTileEntityTankWrapper(ABlockBase block) {
        return new BuilderTileEntityFluidTank();
    }

    private static <TileEntityType extends ATileEntityBase<?>> BuilderTileEntity<TileEntityType> getTileEntityChargerWrapper(ABlockBase block) {
        return new BuilderTileEntityEnergyCharger();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.block instanceof ABlockBaseTileEntity) {
            if (!world.field_72995_K) {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
                    return ((AEntityB_Existing)((BuilderTileEntity)tile).tileEntity).interact(WrapperPlayer.getWrapperFor(player));
                }
            } else {
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (this.block instanceof ABlockBaseTileEntity && !world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            ((ATileEntityBase)((BuilderTileEntity)tile).tileEntity).onNeighborChanged(new Point3D(fromPos.func_177958_n(), fromPos.func_177956_o(), fromPos.func_177952_p()));
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IWrapperItemStack stack;
        Object tile;
        TileEntity mcTile;
        if (this.block instanceof ABlockBaseTileEntity && (mcTile = world.func_175625_s(pos)) instanceof BuilderTileEntity && (tile = ((BuilderTileEntity)mcTile).tileEntity) != null && (stack = ((AEntityD_Definable)tile).getStack()) != null) {
            return ((WrapperItemStack)stack).stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.block instanceof ABlockBaseTileEntity) {
            IWrapperItemStack positionDrop = stackAtPositions.get(pos);
            if (positionDrop != null) {
                drops.add((Object)((WrapperItemStack)positionDrop).stack);
                stackAtPositions.remove(pos);
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        this.block.onBroken(WrapperWorld.getWrapperFor(world), new Point3D(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        if (this.block instanceof ABlockBaseTileEntity && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            stackAtPositions.put(pos, ((AEntityD_Definable)((BuilderTileEntity)tile).tileEntity).getStack());
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        AxisAlignedBB mcBox = this.getBlockBox(state, (IBlockAccess)world, pos, true);
        if (mcBox.func_72326_a(entityBox)) {
            collidingBoxes.add(mcBox);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return this.getBlockBox(state, access, pos, false);
    }

    private AxisAlignedBB getBlockBox(IBlockState state, IBlockAccess access, BlockPos pos, boolean globalCoords) {
        if (this.block instanceof ABlockBaseTileEntity) {
            Object tile;
            TileEntity mcTile = access.func_175625_s(pos);
            if (mcTile instanceof BuilderTileEntity && (tile = ((BuilderTileEntity)mcTile).tileEntity) != null) {
                if (globalCoords) {
                    return WrapperWorld.convert(((ATileEntityBase)tile).boundingBox);
                }
                return WrapperWorld.convertWithOffset(((ATileEntityBase)tile).boundingBox, -pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
            }
        } else if (this.block instanceof BlockCollision) {
            if (globalCoords) {
                return WrapperWorld.convertWithOffset(((BlockCollision)this.block).blockBounds, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return WrapperWorld.convert(((BlockCollision)this.block).blockBounds);
        }
        if (globalCoords) {
            return field_185505_j.func_186670_a(pos);
        }
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        if (this.block instanceof ABlockBaseTileEntity && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            return (int)(((AEntityB_Existing)((BuilderTileEntity)tile).tileEntity).getLightProvided() * 15.0f);
        }
        return super.getLightValue(state, world, pos);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        void var2_5;
        for (String string : PackParser.getAllPackIDs()) {
            for (AItemPack<?> packItem : PackParser.getAllItemsForPack(string, true)) {
                if (!packItem.autoGenerate()) continue;
                new BuilderItem(packItem);
            }
        }
        GameRegistry.registerTileEntity(BuilderTileEntity.class, (ResourceLocation)new ResourceLocation(InterfaceManager.coreModID, BuilderTileEntity.class.getSimpleName()));
        GameRegistry.registerTileEntity(BuilderTileEntityInventoryContainer.class, (ResourceLocation)new ResourceLocation(InterfaceManager.coreModID, BuilderTileEntityInventoryContainer.class.getSimpleName()));
        GameRegistry.registerTileEntity(BuilderTileEntityFluidTank.class, (ResourceLocation)new ResourceLocation(InterfaceManager.coreModID, BuilderTileEntityFluidTank.class.getSimpleName()));
        GameRegistry.registerTileEntity(BuilderTileEntityEnergyCharger.class, (ResourceLocation)new ResourceLocation(InterfaceManager.coreModID, BuilderTileEntityEnergyCharger.class.getSimpleName()));
        ArrayList<ABlockBase> blocksRegistred = new ArrayList<ABlockBase>();
        for (AItemBase item : BuilderItem.itemMap.keySet()) {
            ABlockBase itemBlockBlock;
            if (!(item instanceof IItemBlock) || blocksRegistred.contains(itemBlockBlock = ((IItemBlock)((Object)item)).getBlock())) continue;
            BuilderBlock wrapper = new BuilderBlock(itemBlockBlock);
            String name = itemBlockBlock.getClass().getSimpleName();
            name = InterfaceManager.coreModID + ":" + name.substring("Block".length());
            event.getRegistry().register((IForgeRegistryEntry)((Block)wrapper.setRegistryName(name)).func_149663_c(name));
            blockMap.put(itemBlockBlock, wrapper);
            blocksRegistred.add(itemBlockBlock);
        }
        boolean bl = false;
        while (var2_5 < BlockCollision.blockInstances.size()) {
            BlockCollision collisionBlock = BlockCollision.blockInstances.get((int)var2_5);
            BuilderBlock wrapper = new BuilderBlock(collisionBlock);
            String name = collisionBlock.getClass().getSimpleName();
            name = InterfaceManager.coreModID + ":" + name.substring("Block".length()) + (int)var2_5;
            event.getRegistry().register((IForgeRegistryEntry)((Block)wrapper.setRegistryName(name)).func_149663_c(name));
            blockMap.put(collisionBlock, wrapper);
            ++var2_5;
        }
    }
}

