/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.mcinterface.IInterfaceSound;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.sound.IStreamDecoder;
import minecrafttransportsimulator.sound.OGGDecoder;
import minecrafttransportsimulator.sound.RadioStation;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceSound
implements IInterfaceSound {
    private static boolean isSystemPaused;
    private static final Map<String, Integer> dataSourceBuffers;
    private static final Set<SoundInstance> playingSounds;
    private static final List<RadioStation> playingStations;
    private static final List<SoundInstance> queuedSounds;
    private static final List<SoundInstance> pausedRadioSounds;
    private static byte sourceGetFailures;
    private static boolean postedSoundWarning;

    public static void update() {
        boolean bl;
        if (!AL.isCreated()) {
            return;
        }
        if (InterfaceManager.clientInterface.isGamePaused()) {
            if (!isSystemPaused) {
                for (SoundInstance soundInstance : playingSounds) {
                    AL10.alSourcePause((int)soundInstance.sourceIndex);
                }
                isSystemPaused = true;
            } else {
                for (SoundInstance soundInstance : playingSounds) {
                    if (soundInstance.radio != null) {
                        pausedRadioSounds.add(soundInstance);
                        soundInstance.radio.currentStation.removeRadio(soundInstance.radio);
                        continue;
                    }
                    soundInstance.stopSound = true;
                }
                playingSounds.removeAll(pausedRadioSounds);
            }
            return;
        }
        if (isSystemPaused) {
            for (SoundInstance soundInstance : playingSounds) {
                AL10.alSourcePlay((int)soundInstance.sourceIndex);
            }
            for (SoundInstance soundInstance : pausedRadioSounds) {
                soundInstance.radio.currentStation.addRadio(soundInstance.radio);
            }
            pausedRadioSounds.clear();
            isSystemPaused = false;
        }
        IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
        if (InterfaceManager.clientInterface.getClientWorld() == null || player == null) {
            queuedSounds.clear();
            for (SoundInstance sound : playingSounds) {
                sound.stopSound = true;
            }
        }
        if (!queuedSounds.isEmpty()) {
            for (SoundInstance sound : queuedSounds) {
                AL10.alSourcePlay((int)sound.sourceIndex);
                playingSounds.add(sound);
            }
            queuedSounds.clear();
        }
        boolean bl2 = false;
        Iterator<SoundInstance> iterator = playingSounds.iterator();
        while (iterator.hasNext()) {
            int boundBuffers;
            SoundInstance sound = iterator.next();
            AL10.alGetError();
            int state = AL10.alGetSourcei((int)sound.sourceIndex, (int)4112);
            if (AL10.alGetError() == 40961) {
                bl = true;
                break;
            }
            if (state == 4114) {
                if (sound.stopSound) {
                    AL10.alSourceStop((int)sound.sourceIndex);
                    continue;
                }
                sound.updatePosition();
                AL10.alSource3f((int)sound.sourceIndex, (int)4100, (float)((float)sound.position.x), (float)((float)sound.position.y), (float)((float)sound.position.z));
                if (sound.radio == null) {
                    AL10.alSourcef((int)sound.sourceIndex, (int)4106, (float)(sound.volume * ((Float)ConfigSystem.client.controlSettings.soundVolume.value).floatValue()));
                } else {
                    AL10.alSourcef((int)sound.sourceIndex, (int)4106, (float)(sound.volume * ((Float)ConfigSystem.client.controlSettings.radioVolume.value).floatValue()));
                }
                AL10.alSourcef((int)sound.sourceIndex, (int)4129, (float)0.0f);
                if (sound.soundDef != null && !sound.soundDef.blockDoppler && sound.soundDef.looping && !sound.entity.equals(player.getEntityRiding())) {
                    double finalDelta;
                    Point3D playerVelocity = player.getVelocity();
                    playerVelocity.y = 0.0;
                    double initalDelta = player.getPosition().subtract(sound.entity.position).length();
                    float dopplerFactor = (float)(initalDelta > (finalDelta = player.getPosition().add(playerVelocity).subtract(sound.entity.position).add(-sound.entity.motion.x, 0.0, -sound.entity.motion.z).length()) ? 1.0 + 0.25 * (initalDelta - finalDelta) / initalDelta : 1.0 - 0.25 * (finalDelta - initalDelta) / finalDelta);
                    AL10.alSourcef((int)sound.sourceIndex, (int)4099, (float)(sound.pitch * dopplerFactor));
                    continue;
                }
                AL10.alSourcef((int)sound.sourceIndex, (int)4099, (float)sound.pitch);
                continue;
            }
            if (sound.radio == null) {
                AL10.alSourcei((int)sound.sourceIndex, (int)4105, (int)0);
                sound.stopSound = true;
            } else if (sound.stopSound && (boundBuffers = AL10.alGetSourcei((int)sound.sourceIndex, (int)4118)) > 0) {
                IntBuffer buffers = BufferUtils.createIntBuffer((int)boundBuffers);
                AL10.alSourceUnqueueBuffers((int)sound.sourceIndex, (IntBuffer)buffers);
            }
            if (!sound.stopSound) continue;
            IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)1);
            sourceBuffer.put(sound.sourceIndex).flip();
            AL10.alDeleteSources((IntBuffer)sourceBuffer);
            iterator.remove();
            sound.entity.sounds.remove(sound);
        }
        for (RadioStation station : playingStations) {
            station.update();
        }
        if (bl) {
            InterfaceManager.coreInterface.logError("Had an invalid sound name.  Was the sound system reset?  Clearing all sounds, playing or not!");
            dataSourceBuffers.clear();
            for (SoundInstance sound : playingSounds) {
                sound.entity.sounds.remove(sound);
            }
            playingSounds.clear();
            sourceGetFailures = 0;
        }
    }

    @Override
    public void playQuickSound(SoundInstance sound) {
        Integer dataBufferPointer;
        if (AL.isCreated() && sourceGetFailures < 10 && (dataBufferPointer = InterfaceSound.loadOGGJarSound(sound.soundPlayingName)) != null) {
            IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGetError();
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() != 0) {
                AL10.alDeleteBuffers((int)dataBufferPointer);
                sourceGetFailures = (byte)(sourceGetFailures + 1);
                if (sourceGetFailures == 10) {
                    if (!postedSoundWarning) {
                        InterfaceManager.clientInterface.getClientPlayer().displayChatMessage(LanguageSystem.SYSTEM_SOUNDSLOT, new Object[0]);
                        postedSoundWarning = true;
                    }
                    if (!playingSounds.isEmpty()) {
                        SoundInstance furthestSound = null;
                        Point3D playerPosition = InterfaceManager.clientInterface.getClientPlayer().getPosition();
                        for (SoundInstance testSound : playingSounds) {
                            if (furthestSound != null && !playerPosition.isFirstCloserThanSecond(testSound.position, furthestSound.position)) continue;
                            furthestSound = testSound;
                        }
                        sourceGetFailures = 0;
                        AL10.alSourcei((int)furthestSound.sourceIndex, (int)4105, (int)0);
                        sourceBuffer = BufferUtils.createIntBuffer((int)1);
                        sourceBuffer.put(furthestSound.sourceIndex).flip();
                        AL10.alDeleteSources((IntBuffer)sourceBuffer);
                        playingSounds.remove(furthestSound);
                    }
                }
                return;
            }
            sound.sourceIndex = sourceBuffer.get(0);
            AL10.alGetError();
            AL10.alSourcei((int)sound.sourceIndex, (int)4103, (int)(sound.soundDef != null && sound.soundDef.looping ? 1 : 0));
            AL10.alSource3f((int)sound.sourceIndex, (int)4100, (float)((float)sound.entity.position.x), (float)((float)sound.entity.position.y), (float)((float)sound.entity.position.z));
            AL10.alSourcei((int)sound.sourceIndex, (int)4105, (int)dataBufferPointer);
            queuedSounds.add(sound);
            sound.entity.sounds.add(sound);
        }
    }

    @Override
    public void addRadioStation(RadioStation station) {
        playingStations.add(station);
    }

    @Override
    public void addRadioSound(SoundInstance sound, List<Integer> buffers) {
        if (AL.isCreated() && sourceGetFailures < 10) {
            IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGetError();
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() != 0) {
                if ((sourceGetFailures = (byte)(sourceGetFailures + 1)) == 10 && !postedSoundWarning) {
                    InterfaceManager.clientInterface.getClientPlayer().displayChatMessage(LanguageSystem.SYSTEM_SOUNDSLOT, new Object[0]);
                    postedSoundWarning = true;
                }
                return;
            }
            sound.sourceIndex = sourceBuffer.get(0);
            for (int bufferIndex : buffers) {
                this.bindBuffer(sound, bufferIndex);
            }
            queuedSounds.add(sound);
        }
    }

    @Override
    public int createBuffer(ByteBuffer buffer, IStreamDecoder decoder) {
        IntBuffer newDataBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)newDataBuffer);
        AL10.alBufferData((int)newDataBuffer.get(0), (int)4353, (ByteBuffer)buffer, (int)decoder.getSampleRate());
        return newDataBuffer.get(0);
    }

    @Override
    public void deleteBuffer(int bufferIndex) {
        AL10.alDeleteBuffers((int)bufferIndex);
    }

    @Override
    public void bindBuffer(SoundInstance sound, int bufferIndex) {
        AL10.alSourceQueueBuffers((int)sound.sourceIndex, (int)bufferIndex);
    }

    @Override
    public int getFreeStationBuffer(Set<EntityRadio> playingRadios) {
        boolean freeBuffer = true;
        EntityRadio badRadio = null;
        AL10.alGetError();
        for (EntityRadio radio : playingRadios) {
            SoundInstance sound = radio.getPlayingSound();
            if (AL10.alGetSourcei((int)sound.sourceIndex, (int)4118) == 0) {
                freeBuffer = false;
                break;
            }
            if (AL10.alGetError() != 40961) continue;
            badRadio = radio;
        }
        if (badRadio != null) {
            badRadio.stop();
            return 0;
        }
        if (freeBuffer) {
            int freeBufferIndex = 0;
            IntBuffer oldDataBuffer = BufferUtils.createIntBuffer((int)1);
            for (EntityRadio radio : playingRadios) {
                SoundInstance sound = radio.getPlayingSound();
                AL10.alSourceUnqueueBuffers((int)sound.sourceIndex, (IntBuffer)oldDataBuffer);
                if (freeBufferIndex == 0) {
                    freeBufferIndex = oldDataBuffer.get(0);
                    continue;
                }
                if (freeBufferIndex == oldDataBuffer.get(0)) continue;
                badRadio = radio;
                break;
            }
            if (badRadio != null) {
                badRadio.stop();
                return 0;
            }
            return freeBufferIndex;
        }
        return 0;
    }

    private static Integer loadOGGJarSound(String soundName) {
        if (dataSourceBuffers.containsKey(soundName)) {
            return dataSourceBuffers.get(soundName);
        }
        String soundDomain = soundName.substring(0, soundName.indexOf(58));
        String soundPath = soundName.substring(soundDomain.length() + 1);
        InputStream soundStream = InterfaceManager.coreInterface.getPackResource("/assets/" + soundDomain + "/sounds/" + soundPath + ".ogg");
        if (soundStream != null) {
            ByteBuffer blockRead;
            OGGDecoder decoder = new OGGDecoder(soundStream);
            ByteBuffer decodedData = ByteBuffer.allocateDirect(0);
            while ((blockRead = decoder.readBlock()) != null) {
                decodedData = ByteBuffer.allocateDirect(decodedData.capacity() + blockRead.limit()).put(decodedData).put(blockRead);
                decodedData.rewind();
            }
            IntBuffer dataBufferPointers = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)dataBufferPointers);
            AL10.alBufferData((int)dataBufferPointers.get(0), (int)4353, (ByteBuffer)decodedData, (int)decoder.getSampleRate());
            dataSourceBuffers.put(soundName, dataBufferPointers.get(0));
            return dataSourceBuffers.get(soundName);
        }
        return null;
    }

    @SubscribeEvent
    public static void onIVWorldTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            try {
                InterfaceSound.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onIVWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            queuedSounds.removeIf(soundInstance -> event.getWorld() == ((WrapperWorld)soundInstance.entity.world).world);
            for (SoundInstance sound : playingSounds) {
                if (event.getWorld() != ((WrapperWorld)sound.entity.world).world) continue;
                if (sound.radio != null) {
                    sound.radio.stop();
                    continue;
                }
                sound.stopSound = true;
            }
            isSystemPaused = false;
            InterfaceSound.update();
        }
    }

    static {
        dataSourceBuffers = new HashMap<String, Integer>();
        playingSounds = new HashSet<SoundInstance>();
        playingStations = new ArrayList<RadioStation>();
        queuedSounds = new ArrayList<SoundInstance>();
        pausedRadioSounds = new ArrayList<SoundInstance>();
        sourceGetFailures = 0;
    }
}

