/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityParticle;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONAction;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONLight;
import minecrafttransportsimulator.jsondefs.JSONParticle;
import minecrafttransportsimulator.jsondefs.JSONRendering;
import minecrafttransportsimulator.jsondefs.JSONSound;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.AModelParser;
import minecrafttransportsimulator.rendering.DurationDelayClock;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableModelObject;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;

public abstract class AEntityD_Definable<JSONDefinition extends AJSONMultiModelProvider>
extends AEntityC_Renderable {
    public final JSONDefinition definition;
    public JSONSubDefinition subDefinition;
    public final Map<JSONText, String> text = new HashMap<JSONText, String>();
    protected final Map<String, ComputedVariable> computedVariables = new HashMap<String, ComputedVariable>();
    private final List<JSONSound> allSoundDefs = new ArrayList<JSONSound>();
    private final Map<JSONSound, AnimationSwitchbox> soundActiveSwitchboxes = new HashMap<JSONSound, AnimationSwitchbox>();
    private final Set<JSONSound> soundDefFalseLastCheck = new HashSet<JSONSound>();
    private final Map<JSONSound, SoundSwitchbox> soundVolumeSwitchboxes = new HashMap<JSONSound, SoundSwitchbox>();
    private final Map<JSONSound, SoundSwitchbox> soundPitchSwitchboxes = new HashMap<JSONSound, SoundSwitchbox>();
    private final Map<JSONLight, LightSwitchbox> lightBrightnessSwitchboxes = new HashMap<JSONLight, LightSwitchbox>();
    private final Map<JSONParticle, AnimationSwitchbox> particleActiveSwitchboxes = new HashMap<JSONParticle, AnimationSwitchbox>();
    private final Map<JSONParticle, AnimationSwitchbox> particleSpawningSwitchboxes = new HashMap<JSONParticle, AnimationSwitchbox>();
    private final Map<JSONParticle, Long> lastTickParticleSpawned = new HashMap<JSONParticle, Long>();
    private final Map<JSONParticle, Point3D> lastPositionParticleSpawned = new HashMap<JSONParticle, Point3D>();
    private final Map<JSONVariableModifier, VariableModifierSwitchbox> variableModiferSwitchboxes = new LinkedHashMap<JSONVariableModifier, VariableModifierSwitchbox>();
    private long lastTickParticlesSpawned;
    private float lastPartialTickParticlesSpawned;
    public final Map<String, JSONAnimatedObject> animatedObjectDefinitions = new HashMap<String, JSONAnimatedObject>();
    public final Map<String, AnimationSwitchbox> animatedObjectSwitchboxes = new HashMap<String, AnimationSwitchbox>();
    public final Map<JSONCameraObject, AnimationSwitchbox> cameraSwitchboxes = new LinkedHashMap<JSONCameraObject, AnimationSwitchbox>();
    public final Map<JSONLight, Float> lightBrightnessValues = new HashMap<JSONLight, Float>();
    public final Map<JSONLight, ColorRGB> lightColorValues = new HashMap<JSONLight, ColorRGB>();
    public final Map<String, JSONLight> lightObjectDefinitions = new HashMap<String, JSONLight>();
    private List<RenderableModelObject> objectList;
    public final Set<IWrapperPlayer> playersInteracting = new HashSet<IWrapperPlayer>();
    public boolean playerCraftedItem;
    public AItemPack<JSONDefinition> cachedItem;
    public final List<EntityVehicleF_Physics> aircraftOnRadar = new ArrayList<EntityVehicleF_Physics>();
    public final List<EntityVehicleF_Physics> groundersOnRadar = new ArrayList<EntityVehicleF_Physics>();
    private final Comparator<AEntityB_Existing> entityComparator = new Comparator<AEntityB_Existing>(){

        @Override
        public int compare(AEntityB_Existing o1, AEntityB_Existing o2) {
            return AEntityD_Definable.this.position.isFirstCloserThanSecond(o1.position, o2.position) ? -1 : 1;
        }
    };

    public AEntityD_Definable(AWrapperWorld world, AItemSubTyped<JSONDefinition> item, IWrapperNBT data) {
        super(world, data);
        if (item != null) {
            this.definition = (AJSONMultiModelProvider)item.definition;
            this.updateSubDefinition(item.subDefinition.subName);
        } else {
            this.definition = this.generateDefaultDefinition();
            this.updateSubDefinition("");
        }
        if (data != null) {
            if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.textObjects != null) {
                for (int i = 0; i < ((AJSONMultiModelProvider)this.definition).rendering.textObjects.size(); ++i) {
                    JSONText textDef = ((AJSONMultiModelProvider)this.definition).rendering.textObjects.get(i);
                    this.text.put(textDef, data.hasKey("text" + textDef.fieldName) ? data.getString("text" + textDef.fieldName) : textDef.defaultText);
                }
            }
            for (String variableName : data.getStrings("variables")) {
                this.addVariable(new ComputedVariable(this, variableName, data));
            }
        } else {
            if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.textObjects != null) {
                for (int i = 0; i < ((AJSONMultiModelProvider)this.definition).rendering.textObjects.size(); ++i) {
                    JSONText textDef = ((AJSONMultiModelProvider)this.definition).rendering.textObjects.get(i);
                    this.text.put(textDef, textDef.defaultText);
                }
            }
            if (((AJSONMultiModelProvider)this.definition).initialVariables != null) {
                ((AJSONMultiModelProvider)this.definition).initialVariables.forEach(variable -> {
                    ComputedVariable newVariable = new ComputedVariable(this, (String)variable, null);
                    newVariable.setTo(1.0, false);
                    this.addVariable(newVariable);
                });
            }
        }
        this.performCommonConstructionWork();
    }

    public AEntityD_Definable(AWrapperWorld world, Point3D position, Point3D motion, Point3D angles, AItemSubTyped<JSONDefinition> item) {
        super(world, position, motion, angles);
        this.definition = (AJSONMultiModelProvider)item.definition;
        this.updateSubDefinition(item.subDefinition.subName);
        this.performCommonConstructionWork();
    }

    private void performCommonConstructionWork() {
        if (((AJSONMultiModelProvider)this.definition).constantValues != null) {
            ((AJSONMultiModelProvider)this.definition).constantValues.forEach((constantKey, constantValue) -> {
                ComputedVariable newVariable = new ComputedVariable(this, (String)constantKey);
                newVariable.setTo((double)constantValue, false);
                this.addVariable(newVariable);
            });
        }
        if (((AJSONMultiModelProvider)this.definition).variableModifiers != null) {
            for (JSONVariableModifier modifier : ((AJSONMultiModelProvider)this.definition).variableModifiers) {
                if (modifier.animations == null) continue;
                this.variableModiferSwitchboxes.put(modifier, new VariableModifierSwitchbox(this, (List)modifier.animations));
            }
        }
        if (((AJSONMultiModelProvider)this.definition).rendering != null) {
            if (((AJSONMultiModelProvider)this.definition).rendering.customVariables != null) {
                ((AJSONMultiModelProvider)this.definition).rendering.customVariables.forEach(variable -> {
                    if (!this.containsVariable((String)variable)) {
                        this.addVariable(new ComputedVariable(this, (String)variable, null));
                    }
                });
            }
            if (((AJSONMultiModelProvider)this.definition).rendering.sounds != null) {
                for (JSONSound soundDef : ((AJSONMultiModelProvider)this.definition).rendering.sounds) {
                    this.allSoundDefs.add(soundDef);
                    this.soundActiveSwitchboxes.put(soundDef, new AnimationSwitchbox(this, soundDef.activeAnimations, null));
                    if (soundDef.volumeAnimations != null) {
                        this.soundVolumeSwitchboxes.put(soundDef, new SoundSwitchbox(this, (List)soundDef.volumeAnimations));
                    }
                    if (soundDef.pitchAnimations == null) continue;
                    this.soundPitchSwitchboxes.put(soundDef, new SoundSwitchbox(this, (List)soundDef.pitchAnimations));
                }
            }
            if (((AJSONMultiModelProvider)this.definition).rendering.lightObjects != null) {
                for (JSONLight lightDef : ((AJSONMultiModelProvider)this.definition).rendering.lightObjects) {
                    this.lightObjectDefinitions.put(lightDef.objectName, lightDef);
                    if (lightDef.brightnessAnimations != null) {
                        this.lightBrightnessSwitchboxes.put(lightDef, new LightSwitchbox(this, (List)lightDef.brightnessAnimations));
                    }
                    this.lightBrightnessValues.put(lightDef, Float.valueOf(0.0f));
                    this.lightColorValues.put(lightDef, new ColorRGB());
                }
            }
            if (((AJSONMultiModelProvider)this.definition).rendering.particles != null) {
                for (JSONParticle particleDef : ((AJSONMultiModelProvider)this.definition).rendering.particles) {
                    this.particleActiveSwitchboxes.put(particleDef, new AnimationSwitchbox(this, particleDef.activeAnimations, null));
                    if (particleDef.spawningAnimations != null) {
                        this.particleSpawningSwitchboxes.put(particleDef, new AnimationSwitchbox(this, particleDef.spawningAnimations, null));
                    }
                    this.lastTickParticleSpawned.put(particleDef, this.ticksExisted);
                }
            }
            if (((AJSONMultiModelProvider)this.definition).rendering.animatedObjects != null) {
                for (JSONAnimatedObject animatedDef : ((AJSONMultiModelProvider)this.definition).rendering.animatedObjects) {
                    this.animatedObjectDefinitions.put(animatedDef.objectName, animatedDef);
                    if (animatedDef.animations == null) continue;
                    this.animatedObjectSwitchboxes.put(animatedDef.objectName, new AnimationSwitchbox(this, animatedDef.animations, animatedDef.applyAfter));
                }
            }
            if (((AJSONMultiModelProvider)this.definition).rendering.cameraObjects != null) {
                for (JSONCameraObject cameraDef : ((AJSONMultiModelProvider)this.definition).rendering.cameraObjects) {
                    if (cameraDef.animations == null) continue;
                    this.cameraSwitchboxes.put(cameraDef, new AnimationSwitchbox(this, cameraDef.animations, null));
                }
            }
        }
    }

    public String toString() {
        return ((AJSONMultiModelProvider)this.definition).packID + ":" + ((AJSONMultiModelProvider)this.definition).systemName + this.subDefinition.subName;
    }

    @Override
    public void update() {
        block6: {
            block7: {
                super.update();
                this.world.beginProfiling("EntityD_Level", true);
                if (this.world.isClient()) {
                    this.spawnParticles(0.0f);
                }
                if (this.playersInteracting.isEmpty()) break block6;
                if (!this.world.isClient()) break block7;
                IWrapperPlayer thisClient = InterfaceManager.clientInterface.getClientPlayer();
                if (!this.playersInteracting.contains(thisClient) || InterfaceManager.clientInterface.isGUIOpen()) break block6;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityInteractGUI(this, thisClient, false));
                this.playersInteracting.remove(thisClient);
                break block6;
            }
            for (IWrapperPlayer player : this.playersInteracting) {
                if (player.isValid() && player.getWorld().equals(this.world)) continue;
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, false));
                this.playersInteracting.remove(player);
                break;
            }
        }
        this.playerCraftedItem = false;
        if (((AJSONMultiModelProvider)this.definition).general.radarRange > 0.0 && this.ticksExisted % 20L == 0L) {
            ConcurrentLinkedQueue<EntityVehicleF_Physics> allVehicles = this.world.getEntitiesOfType(EntityVehicleF_Physics.class);
            this.aircraftOnRadar.clear();
            this.groundersOnRadar.clear();
            Point3D searchVector = new Point3D();
            Point3D LOSVector = new Point3D();
            for (EntityVehicleF_Physics vehicle : allVehicles) {
                searchVector.set(0.0, 0.0, ((AJSONMultiModelProvider)this.definition).general.radarRange).rotate(this.orientation);
                LOSVector.set(vehicle.position).subtract(this.position).normalize();
                double coneAngle = ((AJSONMultiModelProvider)this.definition).general.radarWidth;
                double angle = Math.abs(Math.toDegrees(Math.acos(searchVector.normalize().dotProduct(LOSVector, false))));
                if (vehicle.outOfHealth || vehicle == this || !(angle < coneAngle) || !vehicle.position.isDistanceToCloserThan(this.position, ((AJSONMultiModelProvider)this.definition).general.radarRange)) continue;
                if (((JSONVehicle)vehicle.definition).motorized.isAircraft) {
                    this.aircraftOnRadar.add(vehicle);
                } else {
                    this.groundersOnRadar.add(vehicle);
                }
                if (vehicle.radarsTracking.contains(this)) continue;
                vehicle.radarsTracking.add(this);
            }
            this.aircraftOnRadar.sort(this.entityComparator);
            this.groundersOnRadar.sort(this.entityComparator);
        }
        this.world.endProfiling();
    }

    public void doPostUpdateLogic() {
        if (this.world.isClient() && !this.text.isEmpty()) {
            for (Map.Entry<JSONText, String> textEntry : this.text.entrySet()) {
                JSONText textDef = textEntry.getKey();
                if (textDef.variableName == null) continue;
                String value = this.getRawTextVariableValue(textDef, 0.0f);
                value = value != null ? String.format(textDef.variableFormat, value) : String.format(textDef.variableFormat, this.getOrCreateVariable(textDef.variableName).computeValue(0.0f) * (double)textDef.variableFactor + (double)textDef.variableOffset);
                textEntry.setValue(value);
            }
        }
    }

    public void updateSubDefinition(String newSubDefName) {
        for (JSONSubDefinition testSubDef : ((AJSONMultiModelProvider)this.definition).definitions) {
            if (!testSubDef.subName.equals(newSubDefName)) continue;
            if (this.subDefinition != null && this.subDefinition.constants != null) {
                this.subDefinition.constants.forEach(constant -> this.getOrCreateVariable((String)constant).setTo(0.0, false));
            }
            this.subDefinition = testSubDef;
            if (this.subDefinition.constants != null) {
                this.subDefinition.constants.forEach(constant -> {
                    if (this.containsVariable((String)constant)) {
                        this.getOrCreateVariable((String)constant).setTo(1.0, false);
                    } else {
                        ComputedVariable newVariable = new ComputedVariable(this, (String)constant);
                        newVariable.setTo(1.0, false);
                        this.addVariable(newVariable);
                    }
                });
            }
            this.cachedItem = PackParser.getItem(((AJSONMultiModelProvider)this.definition).packID, ((AJSONMultiModelProvider)this.definition).systemName, this.subDefinition.subName);
            this.resetModelsAndAnimations();
            return;
        }
        throw new IllegalArgumentException("Tried to get the definition for an object of subName:" + newSubDefName + ".  But that isn't a valid subName for the object:" + ((AJSONMultiModelProvider)this.definition).packID + ":" + ((AJSONMultiModelProvider)this.definition).systemName + ".  Report this to the pack author as this is a missing JSON component!");
    }

    @Override
    public void remove() {
        if (this.isValid) {
            super.remove();
            this.aircraftOnRadar.clear();
            this.groundersOnRadar.clear();
            if (this.world.isClient() && this.objectList != null) {
                this.objectList.forEach(object -> object.destroy());
            }
        }
    }

    public IWrapperItemStack getStack() {
        return this.cachedItem.getNewStack(null);
    }

    public JSONDefinition generateDefaultDefinition() {
        throw new IllegalArgumentException("Was asked to auto-generate a definition on an entity with one not defined.  This is NOT allowed.  The entity must be missing its item.  Perhaps a pack was removed with this entity still in the world?");
    }

    public String getTexture() {
        return ((AJSONMultiModelProvider)this.definition).getTextureLocation(this.subDefinition);
    }

    public boolean renderTextLit() {
        return (Boolean)ConfigSystem.client.renderingSettings.brightLights.value;
    }

    public ColorRGB getTextColor(int index, ColorRGB defaultColor) {
        if (index != 0) {
            if (this.subDefinition.secondaryTextColors != null && this.subDefinition.secondaryTextColors.size() >= index) {
                return this.subDefinition.secondaryTextColors.get(index - 1);
            }
            return defaultColor;
        }
        return defaultColor;
    }

    public void updateText(String textKey, String textValue) {
        for (Map.Entry<JSONText, String> textEntry : this.text.entrySet()) {
            if (!textKey.equals(textEntry.getKey().fieldName)) continue;
            textEntry.setValue(textValue);
        }
    }

    public void spawnParticles(float partialTicks) {
        for (Map.Entry<JSONParticle, AnimationSwitchbox> particleEntry : this.particleActiveSwitchboxes.entrySet()) {
            JSONParticle particleDef = particleEntry.getKey();
            AnimationSwitchbox switchbox = particleEntry.getValue();
            boolean shouldParticleSpawn = switchbox.runSwitchbox(partialTicks, false);
            if (shouldParticleSpawn) {
                if (particleDef.distance > 0.0f) {
                    Point3D lastParticlePosition = this.lastPositionParticleSpawned.get(particleDef);
                    if (lastParticlePosition == null) {
                        lastParticlePosition = this.position.copy();
                        this.lastPositionParticleSpawned.put(particleDef, lastParticlePosition);
                        continue;
                    }
                    while (!lastParticlePosition.isDistanceToCloserThan(this.position, particleDef.distance)) {
                        double distanceFactor = (double)particleDef.distance / this.position.distanceTo(lastParticlePosition);
                        Point3D spawningPosition = lastParticlePosition.copy().interpolate(this.position, distanceFactor);
                        for (int i = 0; i < particleDef.quantity; ++i) {
                            AnimationSwitchbox spawningSwitchbox = this.particleSpawningSwitchboxes.get(particleDef);
                            if (spawningSwitchbox != null) {
                                spawningSwitchbox.runSwitchbox(partialTicks, false);
                            }
                            this.world.addEntity(new EntityParticle(this, particleDef, spawningPosition, spawningSwitchbox));
                        }
                        lastParticlePosition.set(spawningPosition);
                    }
                    continue;
                }
                Long particleSpawnTime = this.lastTickParticleSpawned.get(particleDef);
                if (particleSpawnTime != null && (!particleDef.spawnEveryTick || this.ticksExisted <= particleSpawnTime)) continue;
                for (int i = 0; i < particleDef.quantity; ++i) {
                    AnimationSwitchbox spawningSwitchbox = this.particleSpawningSwitchboxes.get(particleDef);
                    if (spawningSwitchbox != null) {
                        spawningSwitchbox.runSwitchbox(partialTicks, false);
                    }
                    this.world.addEntity(new EntityParticle(this, particleDef, this.position, spawningSwitchbox));
                }
                this.lastTickParticleSpawned.put(particleDef, this.ticksExisted);
                continue;
            }
            this.lastTickParticleSpawned.remove(particleDef);
            this.lastPositionParticleSpawned.remove(particleDef);
        }
    }

    public void updateLightBrightness(float partialTicks) {
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.lightObjects != null) {
            for (JSONLight lightDef : ((AJSONMultiModelProvider)this.definition).rendering.lightObjects) {
                float lightBrightness = 1.0f;
                ColorRGB lightColor = null;
                LightSwitchbox switchbox = this.lightBrightnessSwitchboxes.get(lightDef);
                if (switchbox != null) {
                    if (!switchbox.runLight(partialTicks)) {
                        lightBrightness = 0.0f;
                    } else if (switchbox.definedBrightness) {
                        lightBrightness = switchbox.brightness;
                    }
                    if (lightBrightness < 0.0f) {
                        lightBrightness = 0.0f;
                    }
                    this.lightBrightnessValues.put(lightDef, Float.valueOf(lightBrightness));
                    lightColor = switchbox.color;
                } else {
                    this.lightBrightnessValues.put(lightDef, Float.valueOf(1.0f));
                }
                if (lightColor != null) {
                    this.lightColorValues.put(lightDef, lightColor);
                    continue;
                }
                if (lightDef.color != null) {
                    this.lightColorValues.put(lightDef, lightDef.color);
                    continue;
                }
                this.lightColorValues.put(lightDef, ColorRGB.WHITE);
            }
        }
    }

    @Override
    public void updateSounds(float partialTicks) {
        super.updateSounds(partialTicks);
        for (JSONSound soundDef : this.allSoundDefs) {
            boolean shouldSoundStartPlaying;
            if (!(soundDef.canPlayOnPartialTicks ^ partialTicks == 0.0f)) continue;
            AnimationSwitchbox activeSwitchbox = this.soundActiveSwitchboxes.get(soundDef);
            boolean bl = shouldSoundStartPlaying = (!soundDef.looping || this.isValid) && activeSwitchbox.runSwitchbox(partialTicks, true);
            if (!soundDef.looping && !soundDef.forceSound) {
                if (shouldSoundStartPlaying) {
                    if (!this.soundDefFalseLastCheck.remove(soundDef)) {
                        shouldSoundStartPlaying = false;
                    }
                } else {
                    this.soundDefFalseLastCheck.add(soundDef);
                }
            }
            AEntityB_Existing entityRiding = null;
            boolean playerRidingThisEntity = false;
            boolean playerRidingOpenTopped = false;
            if (shouldSoundStartPlaying) {
                boolean weAreOpenTopped;
                entityRiding = InterfaceManager.clientInterface.getClientPlayer().getEntityRiding();
                AEntityF_Multipart playerRidingMasterEntity = entityRiding instanceof APart ? ((APart)entityRiding).masterEntity : (entityRiding instanceof AEntityF_Multipart ? (AEntityF_Multipart)entityRiding : null);
                playerRidingThisEntity = playerRidingMasterEntity != null && (playerRidingMasterEntity.equals(this) || playerRidingMasterEntity.allParts.contains(this));
                playerRidingOpenTopped = playerRidingMasterEntity instanceof EntityVehicleF_Physics && ((JSONVehicle)((EntityVehicleF_Physics)playerRidingMasterEntity).definition).motorized.hasOpenTop;
                boolean bl2 = weAreOpenTopped = this instanceof EntityVehicleF_Physics && ((JSONVehicle)((EntityVehicleF_Physics)this).definition).motorized.hasOpenTop;
                shouldSoundStartPlaying = playerRidingThisEntity && InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON && (CameraSystem.activeCamera == null || CameraSystem.activeCamera.isInterior) ? !soundDef.isExterior : !soundDef.isInterior || weAreOpenTopped;
            }
            double distance = 0.0;
            double conicalFactor = 1.0;
            if (shouldSoundStartPlaying) {
                Point3D soundPos;
                Point3D point3D = soundPos = soundDef.pos != null ? soundDef.pos.copy().rotate(this.orientation).add(this.position) : this.position;
                if (shouldSoundStartPlaying) {
                    distance = soundPos.distanceTo(InterfaceManager.clientInterface.getClientPlayer().getPosition());
                    if (soundDef.maxDistance != soundDef.minDistance) {
                        shouldSoundStartPlaying = distance < soundDef.maxDistance && distance >= soundDef.minDistance;
                    } else {
                        boolean bl3 = shouldSoundStartPlaying = distance < 32.0;
                    }
                }
                if (shouldSoundStartPlaying && soundDef.conicalVector != null) {
                    double conicalAngle = Math.toDegrees(Math.acos(soundDef.conicalVector.copy().rotate(this.orientation).dotProduct(InterfaceManager.clientInterface.getClientPlayer().getEyePosition().subtract(soundPos).normalize(), true)));
                    if (conicalAngle >= soundDef.conicalAngle || conicalAngle < 0.0) {
                        shouldSoundStartPlaying = false;
                    } else {
                        conicalFactor = (soundDef.conicalAngle - conicalAngle) / soundDef.conicalAngle;
                    }
                }
            }
            SoundInstance playingSound = null;
            for (SoundInstance sound : this.sounds) {
                if (sound.soundDef != soundDef) continue;
                playingSound = sound;
                break;
            }
            if (shouldSoundStartPlaying) {
                if (playingSound == null || !soundDef.looping) {
                    InterfaceManager.soundInterface.playQuickSound(new SoundInstance((AEntityB_Existing)this, soundDef));
                }
            } else {
                if (!soundDef.looping || playingSound == null) continue;
                playingSound.stopSound = true;
                continue;
            }
            for (SoundInstance sound : this.sounds) {
                if (sound.soundDef != soundDef) continue;
                SoundSwitchbox volumeSwitchbox = this.soundVolumeSwitchboxes.get(soundDef);
                boolean definedVolume = false;
                if (volumeSwitchbox != null) {
                    volumeSwitchbox.runSound(partialTicks);
                    sound.volume = volumeSwitchbox.value;
                    definedVolume = volumeSwitchbox.definedValue;
                }
                if (!definedVolume) {
                    sound.volume = 1.0f;
                } else if (sound.volume < 0.0f) {
                    sound.volume = 0.0f;
                }
                if (soundDef.minDistanceVolume == 0.0 && soundDef.middleDistanceVolume == 0.0 && soundDef.maxDistanceVolume == 0.0) {
                    double maxDistance;
                    double d = maxDistance = soundDef.maxDistance != 0.0 ? soundDef.maxDistance : 32.0;
                    sound.volume = distance > maxDistance ? 0.0f : (float)((double)sound.volume * ((maxDistance - distance) / maxDistance));
                } else {
                    sound.volume = soundDef.middleDistance != 0.0 ? (distance < soundDef.middleDistance ? (sound.volume *= (float)(soundDef.minDistanceVolume + (distance - soundDef.minDistance) / (soundDef.middleDistance - soundDef.minDistance) * (soundDef.middleDistanceVolume - soundDef.minDistanceVolume))) : (sound.volume *= (float)(soundDef.middleDistanceVolume + (distance - soundDef.middleDistance) / (soundDef.maxDistance - soundDef.middleDistance) * (soundDef.maxDistanceVolume - soundDef.middleDistanceVolume)))) : (distance > soundDef.maxDistance ? 0.0f : (sound.volume *= (float)(soundDef.minDistanceVolume + (distance - soundDef.minDistance) / (soundDef.maxDistance - soundDef.minDistance) * (soundDef.maxDistanceVolume - soundDef.minDistanceVolume))));
                }
                sound.volume = (float)((double)sound.volume * conicalFactor);
                if (!(playerRidingThisEntity || entityRiding == null || sound.radio != null || playerRidingOpenTopped || InterfaceManager.clientInterface.getCameraMode() != CameraSystem.CameraMode.FIRST_PERSON || CameraSystem.activeCamera != null && CameraSystem.activeCamera.isInterior)) {
                    sound.volume *= 0.5f;
                }
                SoundSwitchbox pitchSwitchbox = this.soundPitchSwitchboxes.get(soundDef);
                boolean definedPitch = false;
                if (pitchSwitchbox != null) {
                    pitchSwitchbox.runSound(partialTicks);
                    sound.pitch = pitchSwitchbox.value;
                    definedPitch = pitchSwitchbox.definedValue;
                }
                if (!definedPitch) {
                    sound.pitch = 1.0f;
                    continue;
                }
                if (!(sound.volume < 0.0f)) continue;
                sound.pitch = 0.0f;
            }
        }
    }

    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "radio_active": {
                return new ComputedVariable(this, variable, partialTicks -> this.radio != null && this.radio.isPlaying() ? 1.0 : 0.0, false);
            }
            case "radio_volume": {
                return new ComputedVariable(this, variable, partialTicks -> this.radio != null ? (double)this.radio.volume : 0.0, false);
            }
            case "radio_preset": {
                return new ComputedVariable(this, variable, partialTicks -> this.radio != null ? (double)this.radio.preset : 0.0, false);
            }
            case "tick": {
                return new ComputedVariable(this, variable, partialTicks -> (float)this.ticksExisted + partialTicks, true);
            }
            case "tick_sin": {
                return new ComputedVariable(this, variable, partialTicks -> Math.sin(Math.toRadians((float)this.ticksExisted + partialTicks)), true);
            }
            case "tick_cos": {
                return new ComputedVariable(this, variable, partialTicks -> Math.cos(Math.toRadians((float)this.ticksExisted + partialTicks)), true);
            }
            case "time": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.getTime(), false);
            }
            case "random": {
                return new ComputedVariable(this, variable, partialTicks -> Math.random(), true);
            }
            case "random_flip": {
                return new ComputedVariable(this, variable, partialTicks -> Math.random() < 0.5 ? 0.0 : 1.0, true);
            }
            case "rain_strength": {
                return new ComputedVariable(this, variable, partialTicks -> (int)this.world.getRainStrength(this.position), false);
            }
            case "rain_sin": {
                return new ComputedVariable(this, variable, partialTicks -> {
                    int rainStrength = (int)this.world.getRainStrength(this.position);
                    return rainStrength > 0 ? Math.sin((double)rainStrength * Math.toRadians(360.0f * ((float)this.ticksExisted + partialTicks) / 20.0f)) / 2.0 + 0.5 : 0.0;
                }, false);
            }
            case "rain_cos": {
                return new ComputedVariable(this, variable, partialTicks -> {
                    int rainStrength = (int)this.world.getRainStrength(this.position);
                    return rainStrength > 0 ? Math.cos((double)rainStrength * Math.toRadians(360.0f * ((float)this.ticksExisted + partialTicks) / 20.0f)) / 2.0 + 0.5 : 0.0;
                }, false);
            }
            case "light_sunlight": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.getLightBrightness(this.position, false), false);
            }
            case "light_total": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.getLightBrightness(this.position, true), false);
            }
            case "terrain_distance": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.getHeight(this.position), false);
            }
            case "posX": {
                return new ComputedVariable(this, variable, partialTicks -> this.position.x, false);
            }
            case "posY": {
                return new ComputedVariable(this, variable, partialTicks -> this.position.y, false);
            }
            case "posZ": {
                return new ComputedVariable(this, variable, partialTicks -> this.position.z, false);
            }
            case "inliquid": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.isBlockLiquid(this.position) ? 1.0 : 0.0, false);
            }
            case "player_interacting": {
                return new ComputedVariable(this, variable, partialTicks -> !this.playersInteracting.isEmpty() ? 1.0 : 0.0, false);
            }
            case "player_crafteditem": {
                return new ComputedVariable(this, variable, partialTicks -> this.playerCraftedItem ? 1.0 : 0.0, false);
            }
            case "config_simplethrottle": {
                return new ComputedVariable(this, variable, partialTicks -> (Boolean)ConfigSystem.client.controlSettings.simpleThrottle.value != false ? 1.0 : 0.0, false);
            }
            case "config_innerwindows": {
                return new ComputedVariable(this, variable, partialTicks -> (Boolean)ConfigSystem.client.renderingSettings.innerWindows.value != false ? 1.0 : 0.0, false);
            }
        }
        if (variable.endsWith("_cycle")) {
            String[] parsedVariable = variable.split("_");
            int offTime = Integer.parseInt(parsedVariable[0]);
            int onTime = Integer.parseInt(parsedVariable[1]);
            int totalTime = offTime + onTime + Integer.parseInt(parsedVariable[2]);
            return new ComputedVariable(this, variable, partialTicks -> {
                long timeInCycle = this.ticksExisted % (long)totalTime;
                return timeInCycle > (long)offTime && timeInCycle - (long)offTime < (long)onTime ? 1.0 : 0.0;
            }, false);
        }
        if (variable.startsWith("text_") && variable.endsWith("_present")) {
            if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.textObjects != null) {
                int textIndex = Integer.parseInt(variable.substring("text_".length(), variable.length() - "_present".length())) - 1;
                if (((AJSONMultiModelProvider)this.definition).rendering.textObjects.size() > textIndex) {
                    return new ComputedVariable(this, variable, partialTicks -> !this.text.get(((AJSONMultiModelProvider)this.definition).rendering.textObjects.get(textIndex)).isEmpty() ? 1.0 : 0.0, false);
                }
                return new ComputedVariable(false);
            }
            return new ComputedVariable(false);
        }
        if (variable.startsWith("blockname_")) {
            String blockName = variable.substring("blockname_".length()).toLowerCase();
            return new ComputedVariable(this, variable, partialTicks -> this.world.getBlockName(this.position).equals(blockName) ? 1.0 : 0.0, false);
        }
        if (variable.startsWith("terrain_blockname_")) {
            String blockName = variable.substring("terrain_blockname_".length()).toLowerCase();
            return new ComputedVariable(this, variable, partialTicks -> {
                double height = this.world.getHeight(this.position) + 1.0;
                this.position.y -= height;
                String actualBlockName = this.world.getBlockName(this.position);
                this.position.y += height;
                return actualBlockName.equals(blockName) ? 1.0 : 0.0;
            }, false);
        }
        if (variable.startsWith("blockmaterial_")) {
            String materialName = variable.substring("blockmaterial_".length()).toUpperCase();
            return new ComputedVariable(this, variable, partialTicks -> {
                ABlockBase.BlockMaterial material = this.world.getBlockMaterial(this.position);
                if (material != null) {
                    return material.name().equals(materialName) ? 1.0 : 0.0;
                }
                return 0.0;
            }, false);
        }
        if (variable.startsWith("terrain_blockmaterial_")) {
            String materialName = variable.substring("terrain_blockmaterial_".length()).toUpperCase();
            return new ComputedVariable(this, variable, partialTicks -> {
                double height = this.world.getHeight(this.position) + 1.0;
                this.position.y -= height;
                ABlockBase.BlockMaterial material = this.world.getBlockMaterial(this.position);
                this.position.y += height;
                if (material != null) {
                    return material.name().equals(materialName) ? 1.0 : 0.0;
                }
                return 0.0;
            }, false);
        }
        ComputedVariable exsitingVariable = this.computedVariables.get(variable);
        if (exsitingVariable != null) {
            return exsitingVariable;
        }
        if (createDefaultIfNotPresent) {
            ComputedVariable newVariable = new ComputedVariable(this, variable, null);
            this.addVariable(newVariable);
            return newVariable;
        }
        return null;
    }

    public String getRawTextVariableValue(JSONText textDef, float partialTicks) {
        return null;
    }

    public final double getAnimatedVariableValue(DurationDelayClock clock, double scaleFactor, double offset, float partialTicks) {
        double value = this.getOrCreateVariable(clock.animation.variable).computeValue(partialTicks);
        return clock.clampAndScale(this, value, scaleFactor, offset, partialTicks);
    }

    public final double getAnimatedVariableValue(DurationDelayClock clock, double scaleFactor, float partialTicks) {
        return this.getAnimatedVariableValue(clock, scaleFactor, 0.0, partialTicks);
    }

    public ComputedVariable getOrCreateVariable(String variable) {
        ComputedVariable computedVar = this.computedVariables.get(variable);
        if (computedVar == null) {
            if (variable.startsWith("!")) {
                String normalVariable = variable.substring("!".length());
                computedVar = this.computedVariables.get(normalVariable);
                if (computedVar == null) {
                    computedVar = this.createComputedVariable(normalVariable, true);
                    this.computedVariables.put(normalVariable, computedVar);
                }
                computedVar = computedVar.invertedVariable;
            } else {
                computedVar = this.createComputedVariable(variable, true);
            }
            this.computedVariables.put(variable, computedVar);
        }
        return computedVar;
    }

    public void addVariable(ComputedVariable variable) {
        this.computedVariables.put(variable.variableKey, variable);
        if (variable.invertedVariable != null) {
            this.computedVariables.put(variable.invertedVariable.variableKey, variable.invertedVariable);
        }
    }

    public void resetAllVariables() {
        this.computedVariables.entrySet().removeIf(entry -> ((ComputedVariable)entry.getValue()).entity != this || ((ComputedVariable)entry.getValue()).shouldReset);
    }

    public boolean containsVariable(String variable) {
        return this.computedVariables.containsKey(variable);
    }

    protected double adjustVariable(JSONVariableModifier modifier, double currentValue) {
        double modifiedValue = modifier.setValue != 0.0f ? (double)modifier.setValue : currentValue + (double)modifier.addValue;
        VariableModifierSwitchbox switchbox = this.variableModiferSwitchboxes.get(modifier);
        if (switchbox != null) {
            switchbox.modifiedValue = (float)modifiedValue;
            if (switchbox.runSwitchbox(0.0f, true)) {
                modifiedValue = switchbox.modifiedValue;
            } else {
                return currentValue;
            }
        }
        if (modifier.minValue != 0.0f || modifier.maxValue != 0.0f) {
            if (modifiedValue < (double)modifier.minValue) {
                return modifier.minValue;
            }
            if (modifiedValue > (double)modifier.maxValue) {
                return modifier.maxValue;
            }
        }
        return modifiedValue;
    }

    public boolean isVariableListTrue(List<List<String>> list) {
        if (list != null) {
            for (List<String> variableList : list) {
                boolean listIsTrue = false;
                for (String variableName : variableList) {
                    if (!(this.getOrCreateVariable(variableName).computeValue(0.0f) > 0.0)) continue;
                    listIsTrue = true;
                    break;
                }
                if (listIsTrue) continue;
                return false;
            }
        }
        return true;
    }

    public void performAction(JSONAction action, boolean conditionsTrue) {
        switch (action.action) {
            case BUTTON: {
                if (conditionsTrue) {
                    this.getOrCreateVariable(action.variable).setTo(action.value, true);
                    break;
                }
                this.getOrCreateVariable(action.variable).setTo(0.0, true);
                break;
            }
            case INCREMENT: {
                if (!conditionsTrue) break;
                this.getOrCreateVariable(action.variable).increment(action.value, action.clampMin, action.clampMax, true);
                break;
            }
            case SET: {
                if (!conditionsTrue) break;
                this.getOrCreateVariable(action.variable).setTo(action.value, true);
                break;
            }
            case TOGGLE: {
                if (!conditionsTrue) break;
                this.getOrCreateVariable(action.variable).toggle(true);
            }
        }
    }

    public final void closeDoors() {
        this.computedVariables.forEach((variableKey, variableValue) -> {
            if (variableKey.contains("door")) {
                variableValue.setTo(0.0, true);
            }
        });
    }

    public void setVariableDefaults() {
    }

    public void updateVariableModifiers() {
        if (((AJSONMultiModelProvider)this.definition).variableModifiers != null) {
            for (JSONVariableModifier modifier : ((AJSONMultiModelProvider)this.definition).variableModifiers) {
                ComputedVariable variable = this.getOrCreateVariable(modifier.variable);
                variable.setTo(this.adjustVariable(modifier, variable.currentValue), false);
            }
        }
    }

    @Override
    protected void renderModel(TransformationMatrix transform, boolean blendingEnabled, float partialTicks) {
        this.world.beginProfiling("LightStateUpdates", true);
        this.updateLightBrightness(partialTicks);
        this.world.beginProfiling("MainModel", false);
        if (this.objectList == null) {
            this.objectList = AModelParser.generateRenderables(this);
        }
        this.objectList.forEach(modelObject -> modelObject.render(this, transform, blendingEnabled, partialTicks));
        this.world.beginProfiling("MainText", false);
        if (!blendingEnabled) {
            for (Map.Entry<JSONText, String> textEntry : this.text.entrySet()) {
                JSONText textDef = textEntry.getKey();
                if (textDef.attachedTo != null) continue;
                RenderText.draw3DText(textEntry.getValue(), this, transform, textDef, false);
            }
        }
        if (!(InterfaceManager.clientInterface.isGamePaused() || this.ticksExisted == this.lastTickParticlesSpawned && partialTicks == this.lastPartialTickParticlesSpawned)) {
            this.world.beginProfiling("Particles", false);
            this.spawnParticles(partialTicks);
            this.lastTickParticlesSpawned = this.ticksExisted;
            this.lastPartialTickParticlesSpawned = partialTicks;
        }
        this.world.endProfiling();
    }

    @Override
    protected boolean disableRendering() {
        return super.disableRendering() || ((AJSONMultiModelProvider)this.definition).rendering.modelType.equals((Object)JSONRendering.ModelType.NONE);
    }

    public void resetModelsAndAnimations() {
        if (((AJSONMultiModelProvider)this.definition).rendering.modelType != JSONRendering.ModelType.NONE && this.objectList != null) {
            this.objectList.forEach(object -> object.destroy());
            this.objectList = null;
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setPackItem((AJSONMultiModelProvider)this.definition, this.subDefinition.subName);
        this.text.entrySet().forEach(textEntry -> data.setString("text" + ((JSONText)textEntry.getKey()).fieldName, (String)textEntry.getValue()));
        ArrayList<String> savedNames = new ArrayList<String>();
        this.computedVariables.values().forEach(variable -> {
            if (variable.entity == this) {
                variable.saveToNBT(savedNames, data);
            }
        });
        if (!savedNames.isEmpty()) {
            data.setStrings("variables", savedNames);
        }
        return data;
    }

    private static class VariableModifierSwitchbox
    extends AnimationSwitchbox {
        private float modifiedValue = 0.0f;

        private VariableModifierSwitchbox(AEntityD_Definable<?> entity, List<JSONAnimationDefinition> animations) {
            super(entity, animations, null);
        }

        @Override
        public void runTranslation(DurationDelayClock clock, float partialTicks) {
            this.modifiedValue = clock.animation.axis.x != 0.0 ? (float)((double)this.modifiedValue * (clock.animation.axis.y == 0.0 ? this.entity.getAnimatedVariableValue(clock, clock.animation.axis.x, partialTicks) : Math.pow(this.entity.getAnimatedVariableValue(clock, clock.animation.axis.x, partialTicks), clock.animation.axis.y))) : (clock.animation.axis.y != 0.0 ? (float)((double)this.modifiedValue + (clock.animation.axis.z == 0.0 ? this.entity.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks) : Math.pow(this.entity.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks), clock.animation.axis.z))) : (float)this.entity.getAnimatedVariableValue(clock, clock.animation.axis.z, partialTicks));
        }

        @Override
        public void runRotation(DurationDelayClock clock, float partialTicks) {
            float trigValue = 0.0f;
            if (clock.animation.invert) {
                if (clock.animation.axis.x != 0.0) {
                    trigValue = (float)((double)trigValue + clock.animation.axis.x * Math.toDegrees(Math.asin(this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks) + clock.animation.centerPoint.x)));
                }
                if (clock.animation.axis.y != 0.0) {
                    trigValue = (float)((double)trigValue + clock.animation.axis.y * Math.toDegrees(Math.acos(this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks) + clock.animation.centerPoint.y)));
                }
                if (clock.animation.axis.z != 0.0) {
                    trigValue = (float)((double)trigValue + clock.animation.axis.z * Math.toDegrees(Math.atan(this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks) + clock.animation.centerPoint.z)));
                }
            } else {
                if (clock.animation.axis.x != 0.0) {
                    trigValue = (float)((double)trigValue + clock.animation.axis.x * Math.sin(Math.toRadians(this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks) + clock.animation.centerPoint.x)));
                }
                if (clock.animation.axis.y != 0.0) {
                    trigValue = (float)((double)trigValue + clock.animation.axis.y * Math.cos(Math.toRadians(this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks) + clock.animation.centerPoint.y)));
                }
                if (clock.animation.axis.z != 0.0) {
                    trigValue = (float)((double)trigValue + clock.animation.axis.z * Math.tan(Math.toRadians(this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks) + clock.animation.centerPoint.z)));
                }
            }
            this.modifiedValue *= trigValue;
        }
    }

    private static class SoundSwitchbox
    extends AnimationSwitchbox {
        private boolean definedValue = false;
        private float value = 0.0f;

        private SoundSwitchbox(AEntityD_Definable<?> entity, List<JSONAnimationDefinition> animations) {
            super(entity, animations, null);
        }

        public boolean runSound(float partialTicks) {
            this.value = 0.0f;
            this.definedValue = false;
            return this.runSwitchbox(partialTicks, true);
        }

        @Override
        public void runTranslation(DurationDelayClock clock, float partialTicks) {
            this.definedValue = true;
            this.value = (float)((double)this.value + this.entity.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks));
        }

        @Override
        public void runRotation(DurationDelayClock clock, float partialTicks) {
            this.definedValue = true;
            double parabolaValue = this.entity.getAnimatedVariableValue(clock, clock.animation.axis.y, -clock.animation.offset, partialTicks);
            this.value = (float)((double)this.value + (clock.animation.axis.x * Math.pow(parabolaValue - clock.animation.axis.z, 2.0) + clock.animation.offset));
        }
    }

    private static class LightSwitchbox
    extends AnimationSwitchbox {
        private boolean definedBrightness = false;
        private float brightness = 0.0f;
        private ColorRGB color = null;

        private LightSwitchbox(AEntityD_Definable<?> entity, List<JSONAnimationDefinition> animations) {
            super(entity, animations, null);
        }

        public boolean runLight(float partialTicks) {
            this.definedBrightness = false;
            this.brightness = 0.0f;
            this.color = null;
            return this.runSwitchbox(partialTicks, true);
        }

        @Override
        public void runTranslation(DurationDelayClock clock, float partialTicks) {
            this.definedBrightness = true;
            this.brightness = clock.animation.axis.x != 0.0 ? (float)((double)this.brightness * this.entity.getAnimatedVariableValue(clock, clock.animation.axis.x, partialTicks)) : (clock.animation.axis.y != 0.0 ? (float)((double)this.brightness + this.entity.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks)) : (float)this.entity.getAnimatedVariableValue(clock, clock.animation.axis.z, partialTicks));
        }

        @Override
        public void runRotation(DurationDelayClock clock, float partialTicks) {
            double colorZ;
            double colorY;
            double colorX;
            double colorFactor = this.entity.getAnimatedVariableValue(clock, 1.0, -clock.animation.offset, partialTicks);
            if (this.color == null) {
                colorX = clock.animation.axis.x * colorFactor + clock.animation.offset;
                colorY = clock.animation.axis.y * colorFactor + clock.animation.offset;
                colorZ = clock.animation.axis.z * colorFactor + clock.animation.offset;
            } else {
                colorX = clock.animation.axis.x * colorFactor + clock.animation.offset + (double)this.color.red;
                colorY = clock.animation.axis.y * colorFactor + clock.animation.offset + (double)this.color.green;
                colorZ = clock.animation.axis.z * colorFactor + clock.animation.offset + (double)this.color.blue;
            }
            if (colorX < 0.0) {
                colorX = 0.0;
            }
            if (colorY < 0.0) {
                colorY = 0.0;
            }
            if (colorZ < 0.0) {
                colorZ = 0.0;
            }
            if (colorX > 1.0) {
                colorX = 1.0;
            }
            if (colorY > 1.0) {
                colorY = 1.0;
            }
            if (colorZ > 1.0) {
                colorZ = 1.0;
            }
            this.color = new ColorRGB((float)colorX, (float)colorY, (float)colorZ, false);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD})
    public static @interface ModifiableValue {
    }
}

