/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TowingConnection;
import minecrafttransportsimulator.baseclasses.VehicleGroundDeviceCollection;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.RoadFollowingState;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.AEntityVehicleC_Colliding;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketVehicleServerMovement;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

abstract class AEntityVehicleD_Moving
extends AEntityVehicleC_Colliding {
    public final ComputedVariable leftTurnLightVar;
    public final ComputedVariable rightTurnLightVar;
    public final ComputedVariable brakeVar;
    public final ComputedVariable parkingBrakeVar;
    public final ComputedVariable lockedVar;
    public static final double MAX_BRAKE = 1.0;
    public UUID keyUUID;
    public boolean goingInReverse;
    public boolean slipping;
    public boolean skidSteerActive;
    public boolean lockedOnRoad;
    private boolean updateGroundDevicesRequest;
    private int lastBlockCollisionBoxesCount;
    private int crashDebounce;
    public double groundVelocity;
    public double turningForce;
    public double weightTransfer = 0.0;
    public final RotationMatrix rotation = new RotationMatrix();
    private final IWrapperPlayer placingPlayer;
    public final ComputedVariable steeringForceIgnoresSpeedVar;
    public final ComputedVariable steeringForceFactorVar;
    public final ComputedVariable brakingFactorVar;
    public final ComputedVariable overSteerVar;
    public final ComputedVariable underSteerVar;
    protected RoadFollowingState frontFollower;
    protected RoadFollowingState rearFollower;
    private RoadLane.LaneSelectionRequest selectedSegment = RoadLane.LaneSelectionRequest.NONE;
    private double totalPathDelta;
    private double prevTotalPathDelta;
    private boolean invertedRoadOrientation;
    private final Point3D serverDeltaM;
    private final Point3D serverDeltaR;
    private double serverDeltaP;
    private final Point3D serverDeltaMApplied = new Point3D();
    private final Point3D serverDeltaRApplied = new Point3D();
    private double serverDeltaPApplied;
    private final Point3D clientDeltaM;
    private final Point3D clientDeltaR;
    private double clientDeltaP;
    private final Point3D clientDeltaMApplied = new Point3D();
    private final Point3D clientDeltaRApplied = new Point3D();
    private double clientDeltaPApplied;
    private final Point3D roadMotion = new Point3D();
    private final Point3D roadRotation = new Point3D();
    private final Point3D vehicleCollisionMotion = new Point3D();
    private final RotationMatrix vehicleCollisionRotation = new RotationMatrix();
    private final Point3D groundMotion = new Point3D();
    private final Point3D motionApplied = new Point3D();
    private final RotationMatrix rotationApplied = new RotationMatrix();
    private double pathingApplied;
    private final Point3D tempBoxPosition = new Point3D();
    private final Point3D normalizedGroundVelocityVector = new Point3D();
    private final Point3D normalizedGroundHeadingVector = new Point3D();
    public final List<BoundingBox> allBlockCollisionBoxes = new ArrayList<BoundingBox>();
    private AEntityE_Interactable<?> lastCollidedEntity;
    public VehicleGroundDeviceCollection groundDeviceCollective;

    public AEntityVehicleD_Moving(AWrapperWorld world, IWrapperPlayer placingPlayer, ItemVehicle item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        if (data != null) {
            this.keyUUID = data.getUUID("keyUUID");
            this.prevTotalPathDelta = this.totalPathDelta = data.getDouble("totalPathDelta");
            this.serverDeltaM = data.getPoint3d("serverDeltaM");
            this.serverDeltaR = data.getPoint3d("serverDeltaR");
            this.serverDeltaP = data.getDouble("serverDeltaP");
        } else {
            this.serverDeltaM = new Point3D();
            this.serverDeltaR = new Point3D();
        }
        this.clientDeltaM = this.serverDeltaM.copy();
        this.clientDeltaR = this.serverDeltaR.copy();
        this.clientDeltaP = this.serverDeltaP;
        this.groundDeviceCollective = new VehicleGroundDeviceCollection((EntityVehicleF_Physics)this);
        this.placingPlayer = placingPlayer;
        this.leftTurnLightVar = new ComputedVariable(this, "left_turn_signal", data);
        this.addVariable(this.leftTurnLightVar);
        this.rightTurnLightVar = new ComputedVariable(this, "right_turn_signal", data);
        this.addVariable(this.rightTurnLightVar);
        this.brakeVar = new ComputedVariable(this, "brake", data);
        this.addVariable(this.brakeVar);
        this.parkingBrakeVar = new ComputedVariable(this, "p_brake", data);
        this.addVariable(this.parkingBrakeVar);
        this.lockedVar = new ComputedVariable(this, "locked", data);
        this.addVariable(this.lockedVar);
        this.steeringForceIgnoresSpeedVar = new ComputedVariable(this, "steeringForceIgnoresSpeed");
        this.addVariable(this.steeringForceIgnoresSpeedVar);
        this.steeringForceFactorVar = new ComputedVariable(this, "steeringForceFactor");
        this.addVariable(this.steeringForceFactorVar);
        this.brakingFactorVar = new ComputedVariable(this, "brakingFactor");
        this.addVariable(this.brakingFactorVar);
        this.overSteerVar = new ComputedVariable(this, "overSteer");
        this.addVariable(this.overSteerVar);
        this.underSteerVar = new ComputedVariable(this, "underSteer");
        this.addVariable(this.underSteerVar);
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("VehicleD_Level", true);
        this.allBlockCollisionBoxes.clear();
        for (BoundingBox box : this.allCollisionBoxes) {
            if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.BLOCK)) continue;
            this.allBlockCollisionBoxes.add(box);
        }
        if (this.ticksExisted == 1L && this.placingPlayer != null && !this.world.isClient()) {
            double furthestDownPoint = 0.0;
            for (JSONCollisionGroup collisionGroup : ((JSONVehicle)this.definition).collisionGroups) {
                for (JSONCollisionBox collisionBox : collisionGroup.collisions) {
                    furthestDownPoint = Math.min(collisionBox.pos.y - (double)(collisionBox.height / 2.0f), furthestDownPoint);
                }
            }
            for (APart part : this.allParts) {
                furthestDownPoint = Math.min(part.placementDefinition.pos.y - part.getHeight() / 2.0, furthestDownPoint);
            }
            this.motionApplied.set(0.0, -(furthestDownPoint -= 0.1), 0.0);
            this.rotationApplied.angles.set(0.0, 0.0, 0.0);
            this.position.add(this.motionApplied);
            for (BoundingBox coreBox : this.allBlockCollisionBoxes) {
                coreBox.updateToEntity(this, null);
                if (coreBox.updateCollisions(this.world, new Point3D(0.0, -furthestDownPoint, 0.0), false)) {
                    this.placingPlayer.sendPacket(new PacketPlayerChatMessage(this.placingPlayer, LanguageSystem.INTERACT_VEHICLE_NOSPACE, new Object[0]));
                    if (!this.placingPlayer.isCreative()) {
                        this.placingPlayer.setHeldStack(this.getStack());
                    }
                    this.remove();
                    this.world.endProfiling();
                    return;
                }
                this.addToServerDeltas(null, null, 0.0);
            }
        }
        if (!((Boolean)ConfigSystem.settings.general.noclipVehicles.value).booleanValue() || this.groundDeviceCollective.isReady()) {
            this.world.beginProfiling("GroundForces", true);
            this.getForcesAndMotions();
            this.world.beginProfiling("GroundOperations", false);
            if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
                this.performGroundOperations();
            } else {
                this.slipping = false;
            }
            this.world.beginProfiling("TotalMovement", false);
            this.moveVehicle();
            if (!this.world.isClient()) {
                this.adjustControlSurfaces();
            }
            this.world.endProfiling();
        }
        this.world.endProfiling();
    }

    @Override
    public void doPostUpdateLogic() {
        super.doPostUpdateLogic();
        if (this.velocity != 0.0) {
            this.world.beginProfiling("MoveAlongEntities", true);
            this.encompassingBox.heightRadius += 1.0;
            List<IWrapperEntity> nearbyEntities = this.world.getEntitiesWithin(this.encompassingBox);
            this.encompassingBox.heightRadius -= 1.0;
            block0: for (IWrapperEntity entity : nearbyEntities) {
                if (entity.getEntityRiding() != null || entity instanceof IWrapperPlayer && ((IWrapperPlayer)entity).isSpectator()) continue;
                BoundingBox entityBounds = entity.getBounds();
                entityBounds.heightRadius += 0.25;
                for (BoundingBox box : this.allCollisionBoxes) {
                    double entityBottomDelta;
                    if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ENTITY) || !entityBounds.intersects(box) || !((entityBottomDelta = box.globalCenter.y + box.heightRadius - (entityBounds.globalCenter.y - entityBounds.heightRadius + 0.25)) >= -0.5) || !(entityBottomDelta <= 0.5)) continue;
                    Point3D entityVelocity = entity.getVelocity();
                    if (!(entityVelocity.y <= 0.0) && !(entityVelocity.y < entityBottomDelta)) continue;
                    Point3D entityPositionVector = entity.getPosition().copy().subtract(this.position);
                    Point3D startingAngles = entityPositionVector.copy().getAngles(true);
                    Point3D entityPositionDelta = entityPositionVector.copy();
                    entityPositionDelta.rotate(this.orientation).reOrigin(this.prevOrientation);
                    Point3D entityAngleDelta = entityPositionDelta.copy().getAngles(true).subtract(startingAngles);
                    entityPositionDelta.add(this.position).subtract(this.prevPosition);
                    entityPositionDelta.subtract(entityPositionVector).add(0.0, entityBottomDelta, 0.0);
                    entity.setPosition(entityPositionDelta.add(entity.getPosition()), true);
                    entity.setYaw((double)entity.getYaw() + entityAngleDelta.y);
                    entity.setBodyYaw((double)entity.getBodyYaw() + entityAngleDelta.y);
                    continue block0;
                }
            }
            this.world.endProfiling();
        }
    }

    @Override
    public void setVariableDefaults() {
        super.setVariableDefaults();
        this.steeringForceIgnoresSpeedVar.setTo(((JSONVehicle)this.definition).motorized.steeringForceIgnoresSpeed ? 1.0 : 0.0, false);
        this.steeringForceFactorVar.setTo(((JSONVehicle)this.definition).motorized.steeringForceFactor, false);
        this.brakingFactorVar.setTo(((JSONVehicle)this.definition).motorized.brakingFactor, false);
        this.overSteerVar.setTo(((JSONVehicle)this.definition).motorized.overSteer, false);
        this.underSteerVar.setTo(((JSONVehicle)this.definition).motorized.underSteer, false);
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        if (this.ticksExisted > 1L) {
            this.updateGroundDevicesRequest = true;
        }
    }

    @Override
    protected void updateEncompassingBox() {
        super.updateEncompassingBox();
        if (this.ticksExisted == 1L || this.updateGroundDevicesRequest || this.lastBlockCollisionBoxesCount != this.allBlockCollisionBoxes.size()) {
            this.groundDeviceCollective.updateMembers();
            this.groundDeviceCollective.updateBounds();
            this.groundDeviceCollective.updateCollisions(true);
            this.updateGroundDevicesRequest = false;
            this.lastBlockCollisionBoxesCount = this.allBlockCollisionBoxes.size();
        }
    }

    @Override
    public void connectTrailer(TowingConnection connection, boolean notifyClient) {
        super.connectTrailer(connection, notifyClient);
        EntityVehicleF_Physics towedVehicle = connection.towedVehicle;
        if (towedVehicle.parkingBrakeVar.isActive) {
            towedVehicle.parkingBrakeVar.toggle(false);
        }
        towedVehicle.brakeVar.setTo(0.0, false);
        towedVehicle.frontFollower = null;
        towedVehicle.rearFollower = null;
        towedVehicle.groundDeviceCollective.groundedGroundDevices.clear();
        if (connection.hitchConnection.mounted) {
            for (APart part : towedVehicle.allParts) {
                if (!(part instanceof PartGroundDevice)) continue;
                PartGroundDevice ground = (PartGroundDevice)part;
                ground.angularVelocity = 0.0;
                ground.skipAngularCalcs = false;
                ground.animateAsOnGround = false;
            }
        }
    }

    @Override
    public void disconnectTrailer(int connectionIndex) {
        TowingConnection connection = (TowingConnection)this.towingConnections.get(connectionIndex);
        if (((JSONVehicle)connection.towedVehicle.definition).motorized.isTrailer) {
            connection.towedVehicle.parkingBrakeVar.setTo(1.0, false);
        }
        super.disconnectTrailer(connectionIndex);
    }

    private RoadFollowingState getFollower() {
        Point3D contactPoint = this.groundDeviceCollective.getContactPoint(false);
        if (contactPoint != null) {
            TileEntityRoad road;
            contactPoint.rotate(this.orientation).add(this.position);
            ABlockBase block = this.world.getBlock(contactPoint);
            if (block instanceof BlockCollision && (road = ((BlockCollision)block).getMasterRoad(this.world, contactPoint)) != null) {
                Point3D testPoint = new Point3D();
                for (RoadLane lane : road.lanes) {
                    for (BezierCurve curve : lane.curves) {
                        for (float f = 0.0f; f < curve.pathLength; f += 1.0f) {
                            boolean oppositeDirection;
                            curve.setPointToPositionAt(testPoint, f);
                            if (!testPoint.isDistanceToCloserThan(contactPoint, 1.0)) continue;
                            Point3D testRotation = curve.getRotationAt((float)f).angles;
                            boolean sameDirection = Math.abs(testRotation.getClampedYDelta(this.orientation.angles.y)) < 10.0;
                            boolean bl = oppositeDirection = Math.abs(testRotation.getClampedYDelta(this.orientation.angles.y)) > 170.0;
                            if (!sameDirection && !oppositeDirection) continue;
                            return new RoadFollowingState(lane, curve, sameDirection, f);
                        }
                    }
                }
            }
        }
        return null;
    }

    private void performGroundOperations() {
        float skiddingFactor;
        double brakingFactor;
        double d = brakingFactor = this.towedByConnection == null ? (double)this.getBrakingForce() * this.brakingFactorVar.currentValue : 0.0;
        if (brakingFactor > 0.0) {
            double brakingForce = 20.0 * brakingFactor / this.currentMass;
            if (brakingForce > this.velocity) {
                this.motion.x = 0.0;
                this.motion.z = 0.0;
                this.rotation.angles.y = 0.0;
            } else {
                this.motion.x -= brakingForce * this.motion.x / this.velocity;
                this.motion.z -= brakingForce * this.motion.z / this.velocity;
            }
        }
        this.normalizedGroundVelocityVector.set(this.motion.x, 0.0, this.motion.z);
        this.groundVelocity = this.normalizedGroundVelocityVector.length();
        this.normalizedGroundVelocityVector.normalize();
        this.normalizedGroundHeadingVector.set(this.headingVector.x, 0.0, this.headingVector.z);
        this.normalizedGroundHeadingVector.normalize();
        double turningForce = this.getTurningForce();
        double dotProduct = this.normalizedGroundVelocityVector.dotProduct(this.normalizedGroundHeadingVector, true);
        if (this.skidSteerActive) {
            this.goingInReverse = false;
        } else if (!this.goingInReverse && dotProduct < -0.75 && (turningForce == 0.0 || this.velocity < 0.1)) {
            this.goingInReverse = true;
        } else if (this.goingInReverse && dotProduct > 0.75 && (turningForce == 0.0 || this.velocity < 0.1)) {
            this.goingInReverse = false;
        }
        if (turningForce != 0.0) {
            this.rotation.angles.y = this.rotation.angles.y + (this.goingInReverse ? -turningForce : turningForce);
        }
        if ((skiddingFactor = this.getSkiddingForce()) != 0.0f && this.groundVelocity > 0.01) {
            Point3D crossProduct = this.normalizedGroundVelocityVector.crossProduct(this.normalizedGroundHeadingVector);
            double vectorDelta = Math.toDegrees(Math.atan2(crossProduct.y, dotProduct));
            if (this.goingInReverse && dotProduct < 0.0) {
                if (vectorDelta >= 90.0) {
                    vectorDelta = -(180.0 - vectorDelta);
                } else if (vectorDelta <= -90.0) {
                    vectorDelta = 180.0 + vectorDelta;
                }
            }
            if (this.towedByConnection == null) {
                double overSteerForce = Math.max(this.velocity / 4.0, 1.0);
                if (((JSONVehicle)this.definition).motorized.overSteerAccel != 0.0f) {
                    this.weightTransfer += (this.motion.dotProduct(this.motion, false) - this.prevMotion.dotProduct(this.prevMotion, false)) * this.weightTransfer * this.overSteerVar.currentValue;
                    if (Math.abs(this.weightTransfer) > (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerAccel) && Math.abs(this.weightTransfer) > (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerDecel)) {
                        this.weightTransfer = ((JSONVehicle)this.definition).motorized.overSteerAccel;
                    } else if (Math.abs(this.weightTransfer) < (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerDecel) && this.weightTransfer < (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerAccel)) {
                        this.weightTransfer = ((JSONVehicle)this.definition).motorized.overSteerDecel;
                    }
                } else {
                    this.weightTransfer = this.overSteerVar.currentValue;
                }
                this.rotation.angles.y += crossProduct.y * this.weightTransfer + Math.abs(crossProduct.y) * -this.underSteerVar.currentValue * turningForce * overSteerForce;
            }
            if (Math.abs(vectorDelta) > 0.001) {
                double motionFactor = vectorDelta > (double)skiddingFactor ? (double)skiddingFactor / vectorDelta : (vectorDelta < (double)(-skiddingFactor) ? (double)(-skiddingFactor) / vectorDelta : 1.0);
                Point3D idealMotion = this.goingInReverse ? this.normalizedGroundHeadingVector.copy().scale(-this.groundVelocity) : this.normalizedGroundHeadingVector.copy().scale(this.groundVelocity);
                idealMotion.scale(motionFactor).add(this.motion.x * (1.0 - motionFactor), 0.0, this.motion.z * (1.0 - motionFactor));
                this.motion.x = idealMotion.x;
                this.motion.z = idealMotion.z;
                this.slipping = this.towedByConnection == null ? this.world.isClient() && motionFactor != 1.0 && this.velocity > 0.75 : this.towedByConnection.towingVehicle.slipping;
            }
        }
    }

    private float getBrakingForce() {
        double brakingPower = this.parkingBrakeVar.isActive ? 1.0 : this.brakeVar.currentValue;
        float brakingFactor = 0.0f;
        if (brakingPower > 0.0) {
            for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
                brakingFactor = (float)((double)brakingFactor + groundDevice.motiveFrictionVar.currentValue);
            }
            if (brakingPower > 0.0) {
                brakingFactor = (float)((double)brakingFactor + 0.15 * brakingPower * (double)this.groundDeviceCollective.getNumberBoxesInLiquid());
            }
        }
        return brakingFactor;
    }

    private float getSkiddingForce() {
        float skiddingFactor = 0.0f;
        for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
            skiddingFactor = (float)((double)skiddingFactor + groundDevice.lateralFrictionVar.currentValue);
        }
        return (skiddingFactor = (float)((double)skiddingFactor + 0.5 * (double)this.groundDeviceCollective.getNumberBoxesInLiquid())) > 0.0f ? skiddingFactor : 0.0f;
    }

    private double getTurningForce() {
        double turningDistance;
        this.skidSteerActive = false;
        double steeringAngle = this.getSteeringAngle() * 45.0;
        if (((JSONVehicle)this.definition).motorized.hasPermanentSkidSteer) {
            return steeringAngle / 20.0;
        }
        if (steeringAngle != 0.0 && (turningDistance = this.groundDeviceCollective.getTurningWheelbase()) > 0.0) {
            if (((JSONVehicle)this.definition).motorized.hasSkidSteer) {
                if (this.groundDeviceCollective.isReady() && this.groundVelocity < 0.05) {
                    boolean foundNeutralEngine = false;
                    boolean leftWheelGrounded = false;
                    boolean rightWheelGrounded = false;
                    for (APart part : this.parts) {
                        if (part instanceof PartGroundDevice) {
                            if (!this.groundDeviceCollective.groundedGroundDevices.contains(part)) continue;
                            if (part.placementDefinition.pos.x > 0.0) {
                                leftWheelGrounded = true;
                                continue;
                            }
                            rightWheelGrounded = true;
                            continue;
                        }
                        if (!(part instanceof PartEngine) || ((PartEngine)part).currentGearVar.currentValue != 0.0 || !((PartEngine)part).running) continue;
                        foundNeutralEngine = true;
                    }
                    boolean bl = this.skidSteerActive = foundNeutralEngine && leftWheelGrounded && rightWheelGrounded;
                }
                if (this.skidSteerActive) {
                    return steeringAngle / 20.0;
                }
            }
            this.turningForce = steeringAngle / turningDistance;
            if (this.groundVelocity > 0.35 && !this.steeringForceIgnoresSpeedVar.isActive) {
                this.turningForce *= Math.pow(0.3f, this.groundVelocity * (1.0 - this.steeringForceFactorVar.currentValue) - 0.35);
            } else if (this.steeringForceIgnoresSpeedVar.isActive) {
                this.turningForce *= this.steeringForceFactorVar.currentValue;
            }
            return this.turningForce * this.groundVelocity * (this.speedFactor / 0.35) / 2.0;
        }
        return 0.0;
    }

    private void moveVehicle() {
        if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
            this.world.beginProfiling("GDBInit", true);
            this.collidedEntities.clear();
            this.groundDeviceCollective.updateCollisions(true);
            if (!((JSONVehicle)this.definition).motorized.isAircraft) {
                this.world.beginProfiling("RoadChecks", false);
                if ((this.frontFollower == null || this.rearFollower == null) && this.ticksExisted % 20L == 0L) {
                    Point3D frontContact = this.groundDeviceCollective.getContactPoint(true);
                    Point3D rearContact = this.groundDeviceCollective.getContactPoint(false);
                    if (frontContact != null && rearContact != null) {
                        this.rearFollower = this.getFollower();
                        if (this.rearFollower != null) {
                            float pointDelta = (float)rearContact.distanceTo(frontContact);
                            if (this.towedByConnection == null) {
                                this.frontFollower = new RoadFollowingState(this.rearFollower, false).updateCurvePoints(pointDelta, RoadLane.LaneSelectionRequest.NONE);
                            } else if (this.towedByConnection.towingVehicle.lockedOnRoad) {
                                boolean frontHitch = this.towedByConnection.towingEntity instanceof APart ? ((APart)this.towedByConnection.towingEntity).localOffset.z > 0.0 : this.towedByConnection.hitchConnection.pos.z > 0.0;
                                Point3D towingContact = this.towedByConnection.towingVehicle.groundDeviceCollective.getContactPoint(frontHitch);
                                Point3D towingHitchDelta = this.towedByConnection.hitchConnection.pos.copy().multiply(this.towedByConnection.towingEntity.scale);
                                if (this.towedByConnection.towingEntity instanceof APart) {
                                    APart part = (APart)this.towedByConnection.towingEntity;
                                    towingHitchDelta.rotate(part.localOrientation);
                                    towingHitchDelta.add(part.localOffset);
                                }
                                towingHitchDelta.subtract(towingContact);
                                towingHitchDelta.y = 0.0;
                                boolean frontHookup = this.towedByConnection.towedEntity instanceof APart ? ((APart)this.towedByConnection.towedEntity).localOffset.z > 0.0 : this.towedByConnection.hookupConnection.pos.z > 0.0;
                                Point3D towedContact = this.towedByConnection.towedVehicle.groundDeviceCollective.getContactPoint(frontHookup);
                                Point3D towedHitchDelta = this.towedByConnection.hookupConnection.pos.copy().multiply(this.towedByConnection.towedEntity.scale);
                                if (this.towedByConnection.towedEntity instanceof APart) {
                                    APart part = (APart)this.towedByConnection.towedEntity;
                                    towedHitchDelta.rotate(part.localOrientation);
                                    towedHitchDelta.add(part.localOffset);
                                }
                                towedHitchDelta.subtract(towedContact);
                                towedHitchDelta.y = 0.0;
                                float segmentDelta = (float)(towingHitchDelta.length() + towedHitchDelta.length());
                                this.selectedSegment = this.towedByConnection.towingVehicle.selectedSegment;
                                if (frontHitch) {
                                    if (frontHookup) {
                                        this.invertedRoadOrientation = true;
                                        this.frontFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.frontFollower, this.invertedRoadOrientation);
                                        this.frontFollower.updateCurvePoints(-segmentDelta, this.selectedSegment);
                                        this.rearFollower = new RoadFollowingState(this.frontFollower, false);
                                        this.rearFollower.updateCurvePoints(-pointDelta, this.selectedSegment);
                                    } else {
                                        this.invertedRoadOrientation = false;
                                        this.rearFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.frontFollower, this.invertedRoadOrientation);
                                        this.rearFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                                        this.frontFollower = new RoadFollowingState(this.rearFollower, false);
                                        this.frontFollower.updateCurvePoints(pointDelta, this.selectedSegment);
                                    }
                                } else if (frontHookup) {
                                    this.invertedRoadOrientation = false;
                                    this.frontFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.rearFollower, this.invertedRoadOrientation);
                                    this.frontFollower.updateCurvePoints(-segmentDelta, this.selectedSegment);
                                    this.rearFollower = new RoadFollowingState(this.frontFollower, false);
                                    this.rearFollower.updateCurvePoints(-pointDelta, this.selectedSegment);
                                } else {
                                    this.invertedRoadOrientation = true;
                                    this.rearFollower = new RoadFollowingState(this.towedByConnection.towingVehicle.rearFollower, this.invertedRoadOrientation);
                                    this.rearFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                                    this.frontFollower = new RoadFollowingState(this.rearFollower, false);
                                    this.frontFollower.updateCurvePoints(pointDelta, this.selectedSegment);
                                }
                            }
                        }
                    }
                }
            }
            if (this.frontFollower != null && this.rearFollower != null) {
                RoadLane.LaneSelectionRequest requestedSegment;
                this.world.beginProfiling("RoadOperations", false);
                if (this.leftTurnLightVar.isActive == this.rightTurnLightVar.isActive) {
                    requestedSegment = RoadLane.LaneSelectionRequest.NONE;
                } else if (this.leftTurnLightVar.isActive) {
                    requestedSegment = this.goingInReverse ? RoadLane.LaneSelectionRequest.RIGHT : RoadLane.LaneSelectionRequest.LEFT;
                } else {
                    RoadLane.LaneSelectionRequest laneSelectionRequest = requestedSegment = this.goingInReverse ? RoadLane.LaneSelectionRequest.LEFT : RoadLane.LaneSelectionRequest.RIGHT;
                }
                if (this.frontFollower.equals(this.rearFollower)) {
                    this.selectedSegment = requestedSegment;
                }
                float segmentDelta = (float)(this.totalPathDelta - this.prevTotalPathDelta);
                this.prevTotalPathDelta = this.totalPathDelta;
                this.frontFollower = this.frontFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                this.rearFollower = this.rearFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
                Point3D rearPoint = this.groundDeviceCollective.getContactPoint(false);
                if (this.frontFollower != null && this.rearFollower != null && rearPoint != null) {
                    rearPoint.rotate(this.orientation).add(this.position);
                    Point3D rearDesiredPoint = this.rearFollower.getCurrentPoint();
                    this.roadMotion.set(rearDesiredPoint);
                    this.roadMotion.subtract(rearPoint);
                    if (this.roadMotion.length() > 1.0) {
                        this.roadMotion.set(0.0, 0.0, 0.0);
                        this.frontFollower = null;
                        this.rearFollower = null;
                    } else {
                        this.motion.y = 0.0;
                        Point3D desiredVector = this.frontFollower.getCurrentPoint().subtract(rearDesiredPoint);
                        double yawDelta = Math.toDegrees(Math.atan2(desiredVector.x, desiredVector.z));
                        double pitchDelta = -Math.toDegrees(Math.atan2(desiredVector.y, Math.hypot(desiredVector.x, desiredVector.z)));
                        double rollDelta = this.rearFollower.getCurrentRoll();
                        if (((JSONVehicle)this.definition).motorized.maxTiltAngle != 0.0f) {
                            rollDelta -= (double)((JSONVehicle)this.definition).motorized.maxTiltAngle * 2.0 * Math.min(0.5, this.velocity / 2.0) * this.getSteeringAngle();
                        }
                        this.roadRotation.set(pitchDelta - this.orientation.angles.x, yawDelta, rollDelta - this.orientation.angles.z);
                        this.roadRotation.y = this.roadRotation.getClampedYDelta(this.orientation.angles.y);
                        if (!this.world.isClient()) {
                            if (this.towedByConnection != null) {
                                this.addToSteeringAngle(this.towedByConnection.towingVehicle.getSteeringAngle() - this.getSteeringAngle());
                            } else {
                                this.addToSteeringAngle((this.goingInReverse ? -this.roadRotation.y : this.roadRotation.y) * 1.5);
                            }
                        }
                    }
                } else {
                    this.frontFollower = null;
                    this.rearFollower = null;
                }
            }
            this.groundMotion.set(0.0, 0.0, 0.0);
            boolean fallingDown = this.motion.y < 0.0;
            boolean bl = this.lockedOnRoad = this.frontFollower != null && this.rearFollower != null;
            if (!this.lockedOnRoad) {
                this.world.beginProfiling("GroundBoostCheck", false);
                this.groundMotion.y = this.groundDeviceCollective.getMaxCollisionDepth() / this.speedFactor;
                if (this.groundMotion.y > 0.0) {
                    this.world.beginProfiling("GroundBoostApply", false);
                    this.groundMotion.y = Math.min(this.groundMotion.y, (Double)ConfigSystem.settings.general.climbSpeed.value / this.speedFactor);
                    if (this.motion.y <= 0.0 && this.motion.y + this.groundMotion.y > 0.0) {
                        this.groundMotion.y += this.motion.y;
                        this.motion.y = 0.0;
                    } else {
                        this.motion.y += this.groundMotion.y;
                        this.groundMotion.y = 0.0;
                    }
                    this.groundDeviceCollective.updateCollisions(false);
                }
                this.world.beginProfiling("CollisionCheck_" + this.lastBlockCollisionBoxesCount, false);
                if (this.crashDebounce > 0) {
                    --this.crashDebounce;
                }
                if (this.isCollisionBoxCollided()) {
                    this.world.beginProfiling("CollisionHandling", false);
                    if (this.towedByConnection != null) {
                        Point3D initalMotion = this.motion.copy();
                        if (this.correctCollidingMovement()) {
                            this.world.endProfiling();
                            return;
                        }
                        this.towedByConnection.towingVehicle.motion.add(this.motion).subtract(initalMotion);
                    } else if (this.correctCollidingMovement()) {
                        this.world.endProfiling();
                        return;
                    }
                    this.groundDeviceCollective.updateCollisions(false);
                }
                if (!this.groundDeviceCollective.isBlockedVertically() && (fallingDown || this.towedByConnection != null)) {
                    this.world.beginProfiling("GroundHandlingPitch", false);
                    this.groundDeviceCollective.performPitchCorrection(this.groundMotion);
                    if (this.groundDeviceCollective.canDoRollChecks()) {
                        this.world.beginProfiling("GroundHandlingRoll", false);
                        this.groundDeviceCollective.performRollCorrection(this.groundMotion);
                    }
                    if (((JSONVehicle)this.definition).motorized.maxTiltAngle != 0.0f) {
                        this.rotation.angles.z = -this.orientation.angles.z - (double)((JSONVehicle)this.definition).motorized.maxTiltAngle * 2.0 * Math.min(0.5, this.velocity / 2.0) * this.getSteeringAngle();
                    }
                }
            }
            if (!this.collidedEntities.isEmpty()) {
                this.world.beginProfiling("EntityMoveAlong", false);
                Iterator iterator = this.collidedEntities.iterator();
                if (iterator.hasNext()) {
                    AEntityE_Interactable interactable = (AEntityE_Interactable)iterator.next();
                    if (interactable instanceof AEntityVehicleD_Moving) {
                        this.vehicleCollisionRotation.set(interactable.orientation).multiplyTranspose(interactable.prevOrientation);
                        this.vehicleCollisionRotation.convertToAngles();
                    }
                    Point3D centerOffset = this.position.copy().subtract(interactable.prevPosition);
                    this.vehicleCollisionMotion.set(centerOffset);
                    this.vehicleCollisionMotion.rotate(this.vehicleCollisionRotation);
                    this.vehicleCollisionMotion.subtract(centerOffset);
                    this.vehicleCollisionMotion.add(interactable.position).subtract(interactable.prevPosition);
                    if (this.lastCollidedEntity == null) {
                        this.lastCollidedEntity = interactable;
                        this.motion.subtract(this.lastCollidedEntity.motion);
                    }
                }
            } else if (this.lastCollidedEntity != null) {
                this.motion.add(this.lastCollidedEntity.motion);
                this.lastCollidedEntity = null;
            }
            this.world.beginProfiling("ApplyMotions", false);
            this.motionApplied.set(this.motion).scale(this.speedFactor).add(this.groundMotion);
            this.rotationApplied.angles.set(this.rotation.angles);
            if (this.lockedOnRoad) {
                this.motionApplied.add(this.roadMotion);
                this.rotationApplied.angles.add(this.roadRotation);
                if (this.towedByConnection != null) {
                    this.pathingApplied = this.towedByConnection.towingVehicle.pathingApplied;
                    if (this.invertedRoadOrientation) {
                        this.pathingApplied = -this.pathingApplied;
                    }
                } else {
                    this.pathingApplied = this.goingInReverse ? -this.velocity * this.speedFactor : this.velocity * this.speedFactor;
                }
            } else {
                this.pathingApplied = 0.0;
            }
            if (this.lastCollidedEntity != null) {
                this.motionApplied.add(this.vehicleCollisionMotion);
                this.rotationApplied.angles.add(this.vehicleCollisionRotation.angles);
            }
            this.position.add(this.motionApplied);
            if (!this.rotationApplied.angles.isZero()) {
                this.rotationApplied.updateToAngles();
                this.orientation.multiply(this.rotationApplied).convertToAngles();
            }
            this.totalPathDelta += this.pathingApplied;
            if (this.world.isClient()) {
                this.clientDeltaM.add(this.motionApplied);
                this.clientDeltaMApplied.set(this.serverDeltaM).subtract(this.clientDeltaM);
                if (!this.clientDeltaMApplied.isZero()) {
                    this.clientDeltaMApplied.x *= Math.abs(this.clientDeltaMApplied.x);
                    this.clientDeltaMApplied.y *= Math.abs(this.clientDeltaMApplied.y);
                    this.clientDeltaMApplied.z *= Math.abs(this.clientDeltaMApplied.z);
                    this.clientDeltaMApplied.scale(0.04).clamp(5.0);
                    this.clientDeltaM.add(this.clientDeltaMApplied);
                    this.position.add(this.clientDeltaMApplied);
                }
                if (!this.rotationApplied.angles.isZero()) {
                    this.rotationApplied.angles.set(this.orientation.angles).subtract(this.prevOrientation.angles).clamp180();
                    this.clientDeltaR.add(this.rotationApplied.angles);
                }
                this.clientDeltaRApplied.set(this.serverDeltaR).subtract(this.clientDeltaR);
                if (!this.clientDeltaRApplied.isZero()) {
                    this.clientDeltaRApplied.x *= Math.abs(this.clientDeltaRApplied.x);
                    this.clientDeltaRApplied.y *= Math.abs(this.clientDeltaRApplied.y);
                    this.clientDeltaRApplied.z *= Math.abs(this.clientDeltaRApplied.z);
                    this.clientDeltaRApplied.scale(0.04).clamp(5.0);
                    this.clientDeltaR.add(this.clientDeltaRApplied);
                    this.orientation.angles.add(this.clientDeltaRApplied);
                    this.orientation.updateToAngles();
                }
                this.clientDeltaP += this.pathingApplied;
                this.clientDeltaPApplied = this.serverDeltaP - this.clientDeltaP;
                if (this.clientDeltaPApplied != 0.0) {
                    this.clientDeltaPApplied *= Math.abs(this.clientDeltaPApplied);
                    this.clientDeltaPApplied *= 0.04;
                    if (this.clientDeltaPApplied > 5.0) {
                        this.clientDeltaPApplied = 5.0;
                    } else if (this.clientDeltaPApplied < -5.0) {
                        this.clientDeltaPApplied = -5.0;
                    }
                    this.clientDeltaP += this.clientDeltaPApplied;
                    this.totalPathDelta += this.clientDeltaPApplied;
                }
            } else {
                this.addToServerDeltas(null, null, 0.0);
            }
        } else {
            this.world.beginProfiling("ApplyMotions", true);
            this.motionApplied.set(this.motion).scale(this.speedFactor);
            this.position.add(this.motionApplied);
            this.orientation.set(this.rotation).convertToAngles();
            EntityVehicleF_Physics towingVehicle = this.towedByConnection.towingVehicle;
            if (this.world.isClient()) {
                this.clientDeltaM.add(towingVehicle.clientDeltaMApplied);
                this.clientDeltaR.add(towingVehicle.clientDeltaRApplied);
                this.clientDeltaP += towingVehicle.clientDeltaPApplied;
            } else {
                this.serverDeltaM.add(towingVehicle.serverDeltaMApplied);
                this.serverDeltaR.add(towingVehicle.serverDeltaRApplied);
                this.serverDeltaP += towingVehicle.serverDeltaPApplied;
            }
        }
        this.world.endProfiling();
    }

    private boolean isCollisionBoxCollided() {
        if (!((Boolean)ConfigSystem.settings.general.noclipVehicles.value).booleanValue() && this.motion.length() > 0.001) {
            boolean clearedCache = false;
            for (BoundingBox box : this.allBlockCollisionBoxes) {
                this.tempBoxPosition.set(box.globalCenter).subtract(this.position).rotate(this.rotation).subtract(box.globalCenter).add(this.position).addScaled(this.motion, this.speedFactor);
                if (!box.collidesWithLiquids && this.world.checkForCollisions(box, this.tempBoxPosition, !clearedCache, !this.world.isClient() && (Boolean)ConfigSystem.settings.damage.vehicleBlockBreaking.value != false)) {
                    return true;
                }
                clearedCache = true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean correctCollidingMovement() {
        double hardnessHitThisTick = 0.0;
        Point3D collisionMotion = this.motion.copy().scale(this.speedFactor);
        Iterator<BoundingBox> iterator = this.allBlockCollisionBoxes.iterator();
        while (true) {
            Iterator<Point3D> iterator2;
            boolean inhibitMovement;
            float hardnessHitThisBox;
            BoundingBox box;
            if (iterator.hasNext()) {
                box = iterator.next();
                if (!box.updateCollisions(this.world, collisionMotion, true)) continue;
                hardnessHitThisBox = 0.0f;
                inhibitMovement = false;
                iterator2 = box.collidingBlockPositions.iterator();
            } else {
                if (this.rotation.angles.isZero()) return false;
                iterator = this.allBlockCollisionBoxes.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    box = iterator.next();
                    this.tempBoxPosition.set(box.globalCenter).subtract(this.position).rotate(this.rotation).add(this.position).addScaled(this.motion, this.speedFactor);
                } while (!box.updateCollisions(this.world, this.tempBoxPosition.subtract(box.globalCenter), false));
                this.rotation.setToZero();
                this.rotation.angles.set(0.0, 0.0, 0.0);
                return false;
            }
            while (iterator2.hasNext()) {
                Point3D blockPosition = iterator2.next();
                float blockHardness = this.world.getBlockHardness(blockPosition);
                if (this.world.isBlockLiquid(blockPosition)) continue;
                if ((double)blockHardness <= this.velocity * this.currentMass / 250.0 && blockHardness >= 0.0f) {
                    hardnessHitThisBox += blockHardness;
                    if (collisionMotion.y > -0.01) {
                        hardnessHitThisTick += (double)blockHardness;
                    }
                    if (((Boolean)ConfigSystem.settings.damage.vehicleBlockBreaking.value).booleanValue() && this.ticksExisted > 500L) {
                        this.motion.scale(Math.max(1.0 - (double)(blockHardness * 0.5f) / ((1000.0 + this.currentMass) / 1000.0), 0.0));
                        if (this.world.isClient()) continue;
                        this.world.destroyBlock(blockPosition, true);
                        if (box.groupDef == null || !(blockHardness > 0.0f)) continue;
                        this.damageCollisionBox(box, blockHardness >= 20.0f ? (double)(blockHardness * 2.0f) : (double)(blockHardness * 4.0f));
                        continue;
                    }
                }
                inhibitMovement = true;
            }
            if (!this.world.isClient()) {
                if (((Boolean)ConfigSystem.settings.damage.vehicleDestruction.value).booleanValue() && hardnessHitThisTick > this.currentMass / (0.75 + this.velocity) / 250.0) {
                    APart partHit = this.getPartWithBox(box);
                    if (partHit == null) {
                        this.destroy(box);
                        return false;
                    }
                    hardnessHitThisTick -= (double)hardnessHitThisBox;
                    partHit.remove();
                } else if (hardnessHitThisTick > 0.0 && ((JSONVehicle)this.definition).motorized.crashSpeedMax > 0.0f && this.velocity > (double)((JSONVehicle)this.definition).motorized.crashSpeedMin && this.crashDebounce == 0) {
                    this.attack(new Damage((double)((JSONVehicle)this.definition).general.health * (this.velocity - (double)((JSONVehicle)this.definition).motorized.crashSpeedMin) / (double)(((JSONVehicle)this.definition).motorized.crashSpeedMax - ((JSONVehicle)this.definition).motorized.crashSpeedMin), null, null, null, null));
                    this.crashDebounce = 60;
                }
            }
            if (!inhibitMovement) continue;
            this.motion.subtract(box.currentCollisionDepth.scale(1.0 / this.speedFactor));
            collisionMotion.set(this.motion.copy().scale(this.speedFactor));
        }
    }

    public void addToServerDeltas(Point3D motionAdded, Point3D rotationAdded, double pathingAdded) {
        if (rotationAdded != null) {
            this.serverDeltaM.add(motionAdded);
            this.serverDeltaR.add(rotationAdded);
            this.serverDeltaP += pathingAdded;
        } else if (!this.motionApplied.isZero()) {
            this.serverDeltaMApplied.set(this.motionApplied);
            this.serverDeltaM.add(this.motionApplied);
            if (!this.orientation.angles.equals(this.prevOrientation.angles)) {
                this.rotationApplied.angles.set(this.orientation.angles).subtract(this.prevOrientation.angles).clamp180();
                this.serverDeltaRApplied.set(this.rotationApplied.angles);
                this.serverDeltaR.add(this.rotationApplied.angles);
            }
            this.serverDeltaPApplied += this.pathingApplied;
            this.serverDeltaP += this.pathingApplied;
            InterfaceManager.packetInterface.sendToAllClients(new PacketVehicleServerMovement((EntityVehicleF_Physics)this, this.motionApplied, this.rotationApplied.angles, this.pathingApplied));
        }
    }

    public void toggleLock() {
        this.lockedVar.toggle(true);
        if (this.lockedVar.isActive) {
            this.closeDoors();
        }
    }

    protected abstract double getSteeringAngle();

    protected abstract void addToSteeringAngle(double var1);

    protected abstract void getForcesAndMotions();

    protected abstract void adjustControlSurfaces();

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.keyUUID != null) {
            data.setUUID("keyUUID", this.keyUUID);
        }
        data.setPoint3d("serverDeltaM", this.serverDeltaM);
        data.setPoint3d("serverDeltaR", this.serverDeltaR);
        data.setDouble("serverDeltaP", this.serverDeltaP);
        return data;
    }
}

