/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemPartGun
extends AItemPart {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("gun");
        }

        @Override
        public ItemPartGun createItem(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
            return new ItemPartGun(definition, subDefinition, sourcePackID);
        }
    };

    public ItemPartGun(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, JSONSubDefinition subDefinition, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subDefinition, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).gun.diameter && placementDefinition.maxValue >= ((JSONPart)this.definition).gun.diameter);
    }

    @Override
    public PartGun createPart(AEntityF_Multipart<?> entity, IWrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, IWrapperNBT partData) {
        return new PartGun(entity, placingPlayer, packVehicleDef, this, partData);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        tooltipLines.add(LanguageSystem.ITEMINFO_GUN_DIAMETER.getCurrentValue() + ((JSONPart)this.definition).gun.diameter);
        tooltipLines.add(LanguageSystem.ITEMINFO_GUN_CASERANGE.getCurrentValue() + ((JSONPart)this.definition).gun.minCaseLength + "-" + ((JSONPart)this.definition).gun.maxCaseLength);
        tooltipLines.add(LanguageSystem.ITEMINFO_GUN_FIREDELAY.getCurrentValue() + ((JSONPart)this.definition).gun.fireDelay);
        tooltipLines.add(LanguageSystem.ITEMINFO_GUN_MUZZLEVELOCITY.getCurrentValue() + ((JSONPart)this.definition).gun.muzzleVelocity);
        tooltipLines.add(LanguageSystem.ITEMINFO_GUN_CAPACITY.getCurrentValue() + ((JSONPart)this.definition).gun.capacity);
        if (((JSONPart)this.definition).gun.autoReload) {
            tooltipLines.add(LanguageSystem.ITEMINFO_GUN_AUTORELOAD.getCurrentValue());
        }
        tooltipLines.add(LanguageSystem.ITEMINFO_GUN_YAWRANGE.getCurrentValue() + ((JSONPart)this.definition).gun.minYaw + "-" + ((JSONPart)this.definition).gun.maxYaw);
        tooltipLines.add(LanguageSystem.ITEMINFO_GUN_PITCHRANGE.getCurrentValue() + ((JSONPart)this.definition).gun.minPitch + "-" + ((JSONPart)this.definition).gun.maxPitch);
    }

    @Override
    public boolean canBreakBlocks() {
        return !((JSONPart)this.definition).gun.handHeld;
    }

    @Override
    public void registerEntities(Map<String, IItemEntityProvider.IItemEntityFactory> entityMap) {
        super.registerEntities(entityMap);
        entityMap.put(EntityPlayerGun.class.getSimpleName(), (world, data) -> new EntityPlayerGun(world, null, data));
    }
}

