/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.items.instances.ItemRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.packloading.PackParser;

public class PacketTileEntityRoadChange
extends APacketEntityInteract<TileEntityRoad, IWrapperPlayer> {
    private final TileEntityRoad.RoadComponent componentType;
    private final ItemRoadComponent componentItem;

    public PacketTileEntityRoadChange(TileEntityRoad road, IWrapperPlayer player, TileEntityRoad.RoadComponent componentType, ItemRoadComponent componentItem) {
        super(road, player);
        this.componentType = componentType;
        this.componentItem = componentItem;
    }

    public PacketTileEntityRoadChange(ByteBuf buf) {
        super(buf);
        this.componentType = TileEntityRoad.RoadComponent.values()[buf.readByte()];
        this.componentItem = buf.readBoolean() ? (ItemRoadComponent)PackParser.getItem(PacketTileEntityRoadChange.readStringFromBuffer(buf), PacketTileEntityRoadChange.readStringFromBuffer(buf)) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.componentType.ordinal());
        if (this.componentItem != null) {
            buf.writeBoolean(true);
            PacketTileEntityRoadChange.writeStringToBuffer(((JSONRoadComponent)this.componentItem.definition).packID, buf);
            PacketTileEntityRoadChange.writeStringToBuffer(((JSONRoadComponent)this.componentItem.definition).systemName, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    protected boolean handle(AWrapperWorld world, TileEntityRoad road, IWrapperPlayer player) {
        if (this.componentItem != null) {
            road.components.put(this.componentType, this.componentItem);
            if (!player.isCreative()) {
                player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
            }
            return true;
        }
        if (road.components.containsKey((Object)this.componentType) && (world.isClient() || player.isCreative() || player.getInventory().addStack(road.components.get((Object)this.componentType).getNewStack(null)))) {
            road.components.remove((Object)this.componentType);
            return true;
        }
        return false;
    }
}

