/*
 * Decompiled with CFR 0.152.
 */
package xland.mcplugin.fwds;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bukkit.configuration.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcplugin.fwds.IntRange;

public final class Config
implements Cloneable {
    @NotNull
    private String language = "en";
    @NotNull
    private IntRange safeTime = new IntRange(30, 120);
    @NotNull
    private IntRange unsafeTime = new IntRange(20, 80);
    @NotNull
    private IntRange countdownTime = new IntRange(10);
    private boolean allowPortal = true;
    private boolean allowPvp = true;
    private boolean loseOnQuit = true;
    @NotNull
    private DealEnderPearl dealEnderPearl = DealEnderPearl.DEFAULT;

    public void saveTo(Configuration conf) {
        conf.set("language", (Object)this.getLanguage());
        conf.set("safe-time", this.getSafeTime().asObject());
        conf.set("unsafe-time", this.getUnsafeTime().asObject());
        conf.set("countdown-time", this.getCountdownTime().asObject());
        conf.set("allow-portal", (Object)this.isAllowPortal());
        conf.set("allow-pvp", (Object)this.isAllowPvp());
        conf.set("lose-on-quit", (Object)this.isLoseOnQuit());
        conf.set("deal-ender-pearl", (Object)this.getDealEnderPearl().toString());
    }

    public void loadFrom(Configuration conf) {
        this.setLanguage(conf.getString("language", this.getLanguage()));
        this.setSafeTime(Config.getIntRange(conf, "safe-time", this.getSafeTime()));
        this.setUnsafeTime(Config.getIntRange(conf, "unsafe-time", this.getUnsafeTime()));
        this.setCountdownTime(Config.getIntRange(conf, "countdown-time", this.getCountdownTime()));
        this.setAllowPortal(conf.getBoolean("allow-portal", this.isAllowPortal()));
        this.setAllowPvp(conf.getBoolean("allow-pvp", this.isAllowPvp()));
        this.setLoseOnQuit(conf.getBoolean("lose-on-quit", this.isLoseOnQuit()));
        this.setDealEnderPearl(DealEnderPearl.fromString(conf.getString("deal-ender-pearl", this.getDealEnderPearl().toString())));
    }

    @NotNull
    private static IntRange getIntRange(Configuration conf, String key, @NotNull IntRange defaultValue) {
        return Objects.requireNonNullElse(Config.getIntRange(conf, key), defaultValue);
    }

    @Nullable
    private static IntRange getIntRange(Configuration conf, String key) {
        if (conf.isInt(key)) {
            return new IntRange(conf.getInt(key));
        }
        List list = conf.getIntegerList(key);
        return switch (list.size()) {
            case 1 -> new IntRange((Integer)list.getFirst());
            case 2 -> new IntRange((Integer)list.getFirst(), (Integer)list.getLast());
            default -> null;
        };
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@NotNull String language) {
        Objects.requireNonNull(language, "language");
        this.language = language;
    }

    @NotNull
    public IntRange getSafeTime() {
        return this.safeTime;
    }

    public void setSafeTime(@NotNull IntRange safeTime) {
        Objects.requireNonNull(safeTime, "safeTime");
        this.safeTime = safeTime;
    }

    @NotNull
    public IntRange getUnsafeTime() {
        return this.unsafeTime;
    }

    public void setUnsafeTime(@NotNull IntRange unsafeTime) {
        Objects.requireNonNull(unsafeTime, "unsafeTime");
        this.unsafeTime = unsafeTime;
    }

    @NotNull
    public IntRange getCountdownTime() {
        return this.countdownTime;
    }

    public void setCountdownTime(@NotNull IntRange countdownTime) {
        Objects.requireNonNull(countdownTime, "countdownTime");
        this.countdownTime = countdownTime;
    }

    public boolean isAllowPortal() {
        return this.allowPortal;
    }

    public void setAllowPortal(boolean allowPortal) {
        this.allowPortal = allowPortal;
    }

    public boolean isAllowPvp() {
        return this.allowPvp;
    }

    public void setAllowPvp(boolean allowPvp) {
        this.allowPvp = allowPvp;
    }

    public boolean isLoseOnQuit() {
        return this.loseOnQuit;
    }

    public void setLoseOnQuit(boolean loseOnQuit) {
        this.loseOnQuit = loseOnQuit;
    }

    @NotNull
    public DealEnderPearl getDealEnderPearl() {
        return this.dealEnderPearl;
    }

    public void setDealEnderPearl(@NotNull DealEnderPearl dealEnderPearl) {
        Objects.requireNonNull(dealEnderPearl, "dealEnderPearl");
        this.dealEnderPearl = dealEnderPearl;
    }

    public Config clone() {
        try {
            return (Config)super.clone();
        }
        catch (Exception e) {
            throw new AssertionError("Shall never happen", e);
        }
    }

    public static enum DealEnderPearl {
        NO_OP("no-op", "0", "noop", "none"),
        CHANGE_OWNER("change-owner", "1", "swap"),
        KILL_EXISTING_PEARLS("kill-existing-pearls", "-1", "kill");

        private final String id;
        private final Collection<String> aliases;
        static final DealEnderPearl DEFAULT;

        private DealEnderPearl(String id, String ... aliases) {
            this.id = id;
            this.aliases = Arrays.asList(aliases);
        }

        @NotNull
        public static DealEnderPearl fromString(@Nullable String value) {
            if (value == null) {
                return DEFAULT;
            }
            for (DealEnderPearl each : DealEnderPearl.values()) {
                if (!value.equals(each.id) && !each.aliases.contains(value)) continue;
                return each;
            }
            return DEFAULT;
        }

        public String toString() {
            return this.id;
        }

        static {
            DEFAULT = KILL_EXISTING_PEARLS;
        }
    }
}

