/*
 * Decompiled with CFR 0.152.
 */
package xland.mcplugin.fwds;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.random.RandomGenerator;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import xland.mcplugin.fwds.Config;
import xland.mcplugin.fwds.I18n;
import xland.mcplugin.fwds.Shuffling;
import xland.mcplugin.fwds.StageRunner;
import xland.mcplugin.fwds.Tickable;

public final class DSGameManager
implements Tickable {
    private final Config config;
    private final SequencedSet<Player> players;
    private final RandomGenerator random;
    @NotNull
    private StageRunner stageRunner;
    private final Audience forwardingAudience;
    private final Player[] allPlayers;
    private static final Player[] EMPTY_PLAYER_ARRAY = new Player[0];

    public DSGameManager(@NotNull Config config, @NotNull Collection<Player> players, @NotNull RandomGenerator random) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(players, "players");
        Objects.requireNonNull(random, "random");
        Preconditions.checkArgument((players.size() >= 2 ? 1 : 0) != 0, (Object)"The game requires at least 2 players");
        this.config = config.clone();
        this.players = new LinkedHashSet<Player>(players);
        this.random = random;
        this.stageRunner = new SafeStage();
        this.allPlayers = this.players.toArray(EMPTY_PLAYER_ARRAY);
        this.forwardingAudience = Audience.audience((Audience[])this.allPlayers);
    }

    void deathSwap() {
        SequencedSet<Player> downstreamPlayers = this.players;
        List<@NotNull Location> downstreamLocations = downstreamPlayers.stream().map(OfflinePlayer::getLocation).toList();
        Object[] upstreamPlayers = downstreamPlayers.toArray(EMPTY_PLAYER_ARRAY);
        Shuffling.shuffle(upstreamPlayers, this.random);
        for (int i = upstreamPlayers.length - 1; i >= 0; --i) {
            upstreamPlayers[i].teleport(downstreamLocations.get(i));
        }
        switch (this.config.getDealEnderPearl()) {
            case NO_OP: {
                break;
            }
            case CHANGE_OWNER: {
                int idx = 0;
                for (Player downstreamPlayer : downstreamPlayers) {
                    Object upstreamPlayer = upstreamPlayers[idx++];
                    for (EnderPearl pearl : downstreamPlayer.getEnderPearls()) {
                        pearl.setShooter((ProjectileSource)upstreamPlayer);
                    }
                }
                break;
            }
            case KILL_EXISTING_PEARLS: {
                for (Player player : downstreamPlayers) {
                    for (EnderPearl pearl : player.getEnderPearls()) {
                        pearl.remove();
                    }
                }
                break;
            }
        }
    }

    public void onPlayerGameOver(@NotNull Player player, @NotNull I18n i18n, @NotNull Runnable removeCallback) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(i18n, "i18n");
        if (!this.players.remove(player)) {
            return;
        }
        switch (this.players.size()) {
            case 0: {
                this.forwardingAudience.sendMessage(i18n.get("end.unexpected"));
                break;
            }
            case 1: {
                this.forwardingAudience.sendMessage(MiniMessage.miniMessage().deserialize(i18n.getRaw("end.winner"), (TagResolver)Placeholder.component((String)"player", (ComponentLike)((Player)this.players.getFirst()).displayName())));
                break;
            }
            default: {
                return;
            }
        }
        removeCallback.run();
    }

    public Component query(@NotNull I18n i18n) {
        return Component.text(builder -> {
            builder.append(i18n.get("commands.players.query.ongoing.header", this.players.size(), this.allPlayers.length));
            for (Player player : this.allPlayers) {
                ((TextComponent.Builder)builder.appendNewline()).append(MiniMessage.miniMessage().deserialize(i18n.getRaw(this.players.contains(player) ? "commands.players.query.ongoing.alive" : "commands.players.query.ongoing.lose"), (TagResolver)Placeholder.component((String)"player", (ComponentLike)player.displayName())));
            }
        });
    }

    public boolean isPlayerLoseOnQuit() {
        return this.config.isLoseOnQuit();
    }

    private boolean isAlivePlayer(Entity entity) {
        return entity instanceof Player && this.players.contains(entity);
    }

    public boolean cancelAttack(Entity attacker, Entity attacked) {
        if (this.config.isAllowPvp()) {
            return false;
        }
        return this.isAlivePlayer(attacker) && this.isAlivePlayer(attacked);
    }

    public boolean disallowsPortal(Player player) {
        if (!this.isAlivePlayer((Entity)player)) {
            return false;
        }
        return !this.config.isAllowPortal();
    }

    public void onGameAbort(@NotNull I18n i18n, @NotNull Runnable removeCallback) {
        Objects.requireNonNull(i18n, "i18n");
        this.forwardingAudience.sendMessage(i18n.get("end.aborted"));
        removeCallback.run();
    }

    @Override
    public void tick(I18n i18n) {
        this.stageRunner.tick(i18n);
    }

    private final class SafeStage
    extends ReportableStageRunner {
        SafeStage() {
            super("stages.safe", DSGameManager.this.config.getSafeTime().select(DSGameManager.this.random));
        }

        @Override
        void onTickEnds(I18n i18n) {
            DSGameManager.this.stageRunner = new UnsafeStage();
        }
    }

    private abstract class ReportableStageRunner
    extends StageRunner {
        private final String reportKey;

        ReportableStageRunner(String reportKey, int maxTick) {
            super(maxTick);
            this.reportKey = reportKey;
        }

        @Override
        void reportTick(int tick, I18n i18n) {
            Component component = i18n.get(this.reportKey, tick);
            DSGameManager.this.players.forEach(p -> p.sendActionBar(component));
        }
    }

    private final class CountdownStage
    extends ReportableStageRunner {
        private final int prevMaxTicks;

        CountdownStage(int prevMaxTicks) {
            super("stages.unsafe", DSGameManager.this.config.getCountdownTime().select(DSGameManager.this.random));
            this.prevMaxTicks = prevMaxTicks;
        }

        @Override
        void reportTick(int tick, I18n i18n) {
            super.reportTick(this.prevMaxTicks + tick, i18n);
            int remainingTicks = this.maxTick - tick;
            if (remainingTicks > 0) {
                Component component = i18n.get("swap.countdown", remainingTicks);
                DSGameManager.this.players.forEach(p -> p.sendMessage(component));
            }
        }

        @Override
        void onTickEnds(I18n i18n) {
            Component component = i18n.get("swap.now");
            DSGameManager.this.players.forEach(p -> p.sendMessage(component));
            DSGameManager.this.deathSwap();
            DSGameManager.this.stageRunner = new SafeStage();
        }
    }

    private final class UnsafeStage
    extends ReportableStageRunner {
        UnsafeStage() {
            super("stages.unsafe", DSGameManager.this.config.getUnsafeTime().select(DSGameManager.this.random));
        }

        @Override
        void onTickEnds(I18n i18n) {
            DSGameManager dSGameManager = DSGameManager.this;
            Objects.requireNonNull(dSGameManager);
            DSGameManager.this.stageRunner = dSGameManager.new CountdownStage(this.maxTick);
        }
    }
}

