/*
 * Decompiled with CFR 0.152.
 */
package xland.mcplugin.fwds;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcplugin.fwds.Config;
import xland.mcplugin.fwds.DSGameManager;
import xland.mcplugin.fwds.I18n;

public final class FWDeathSwap2
extends JavaPlugin {
    private final Config config = new Config();
    private final I18n i18n = new I18n();
    @Nullable
    private DSGameManager gameManager;
    @NotNull
    private final LinkedHashSet<Player> candidatePlayers = new LinkedHashSet();
    private final ThreadLocal<RandomGenerator> random = ThreadLocal.withInitial(Random::new);

    private void initConfig() {
        this.config.loadFrom((Configuration)this.getConfig());
        this.saveDefaultConfig();
        String fnLanguage = "language/" + this.config.getLanguage() + ".yml";
        this.saveResource(fnLanguage, false);
        if (!"language/en.yml".equals(fnLanguage)) {
            this.saveResource("language/en.yml", false);
        }
        this.i18n.loadFrom(this.getTextResource(fnLanguage), "language/en.yml".equals(fnLanguage) ? null : this.getTextResource("language/en.yml"));
    }

    private void removeManager() {
        this.gameManager = null;
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new TheListener(), (Plugin)this);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, task -> {
            DSGameManager manager = this.gameManager;
            if (manager != null) {
                manager.tick(this.i18n);
            }
        }, 1L, 20L);
    }

    public void onEnable() {
        this.initConfig();
        this.registerEvents();
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, this::registerCommands);
    }

    private void registerCommands(ReloadableRegistrarEvent<@NotNull Commands> event) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"deathswap").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"players").then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)ArgumentTypes.players()).requires(FWDeathSwap2.requirePermission("fwds.command.players"))).executes(context -> {
            int sizeBefore = this.candidatePlayers.size();
            List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("players", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
            this.candidatePlayers.addAll(players);
            int sizeAfter = this.candidatePlayers.size();
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.players.add", sizeAfter - sizeBefore));
            return 1;
        })))).then(Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)ArgumentTypes.players()).requires(FWDeathSwap2.requirePermission("fwds.command.players"))).executes(context -> {
            int sizeBefore = this.candidatePlayers.size();
            List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("players", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
            players.forEach(this.candidatePlayers::remove);
            int sizeAfter = this.candidatePlayers.size();
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.players.remove", sizeBefore - sizeAfter));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(FWDeathSwap2.requirePermission("fwds.command.players"))).executes(context -> {
            if (this.candidatePlayers.isEmpty()) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.players.clear.nought"));
                return 0;
            }
            this.candidatePlayers.clear();
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.players.clear.success"));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").requires(FWDeathSwap2.requirePermission("fwds.command.players.query"))).executes(context -> this.gameManager == null ? this.queryUpcoming((CommandContext<CommandSourceStack>)context) : this.queryOngoing((CommandContext<CommandSourceStack>)context))).then(((LiteralArgumentBuilder)Commands.literal((String)"upcoming").requires(FWDeathSwap2.requirePermission("fwds.command.players.query"))).executes(this::queryUpcoming))).then(((LiteralArgumentBuilder)Commands.literal((String)"ongoing").requires(FWDeathSwap2.requirePermission("fwds.command.players.query"))).executes(this::queryOngoing))))).then(((LiteralArgumentBuilder)Commands.literal((String)"start").requires(FWDeathSwap2.requirePermission("fwds.command.start"))).executes(context -> {
            if (this.gameManager != null) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.start.fail.started"));
                return 0;
            }
            List<Player> candidatePlayers = this.candidatePlayers.stream().filter(OfflinePlayer::isOnline).toList();
            if (candidatePlayers.size() < 2) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.start.fail.not-enough-players", candidatePlayers.size()));
                return 0;
            }
            this.gameManager = new DSGameManager(this.config, candidatePlayers, this.random.get());
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.start.success"));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"stop").requires(FWDeathSwap2.requirePermission("fwds.command.stop"))).executes(context -> {
            DSGameManager manager = this.gameManager;
            if (manager == null) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.stop.fail.unstarted"));
                return 0;
            }
            manager.onGameAbort(this.i18n, this::removeManager);
            return 1;
        }));
        ((Commands)event.registrar()).register(builder.build(), "Death Swap Game", List.of("fwds", "ds"));
    }

    private static Predicate<CommandSourceStack> requirePermission(String perm) {
        return stack -> stack.getSender().hasPermission(perm);
    }

    private int queryUpcoming(CommandContext<CommandSourceStack> context) {
        int candidatePlayerCount = this.candidatePlayers.size();
        NamedTextColor textColor = switch (candidatePlayerCount) {
            case 0, 1 -> NamedTextColor.RED;
            case 2 -> NamedTextColor.YELLOW;
            default -> NamedTextColor.GREEN;
        };
        TextComponent component = Component.text(arg_0 -> this.lambda$queryUpcoming$8(candidatePlayerCount, (TextColor)textColor, arg_0));
        ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)component);
        return 1;
    }

    private int queryOngoing(CommandContext<CommandSourceStack> context) {
        DSGameManager manager = this.gameManager;
        if (manager == null) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.i18n.get("commands.stop.fail.unstarted"));
            return 0;
        }
        Component queried = manager.query(this.i18n);
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(queried);
        return 1;
    }

    private /* synthetic */ void lambda$queryUpcoming$8(int candidatePlayerCount, TextColor textColor, TextComponent.Builder builder) {
        builder.append(MiniMessage.miniMessage().deserialize(this.i18n.getRaw("commands.players.query.upcoming.header"), (TagResolver)Placeholder.component((String)"count", (ComponentLike)Component.text((int)candidatePlayerCount, (TextColor)textColor))));
        for (Player player : this.candidatePlayers) {
            ((TextComponent.Builder)builder.appendNewline()).append(MiniMessage.miniMessage().deserialize(this.i18n.getRaw(player.isOnline() ? "commands.players.query.upcoming.online" : "commands.player.query.upcoming.offline"), (TagResolver)Placeholder.component((String)"player", (ComponentLike)player.displayName())));
        }
    }

    private final class TheListener
    implements Listener {
        private TheListener() {
        }

        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            DSGameManager manager = FWDeathSwap2.this.gameManager;
            if (manager != null && manager.isPlayerLoseOnQuit()) {
                manager.onPlayerGameOver(event.getPlayer(), FWDeathSwap2.this.i18n, FWDeathSwap2.this::removeManager);
            }
        }

        @EventHandler
        public void onPlayerDeath(PlayerDeathEvent event) {
            DSGameManager manager = FWDeathSwap2.this.gameManager;
            if (manager != null) {
                manager.onPlayerGameOver(event.getPlayer(), FWDeathSwap2.this.i18n, FWDeathSwap2.this::removeManager);
            }
        }

        @EventHandler
        public void onAttack(PrePlayerAttackEntityEvent event) {
            DSGameManager manager = FWDeathSwap2.this.gameManager;
            if (manager != null && manager.cancelAttack((Entity)event.getPlayer(), event.getAttacked())) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onPlayerPortal(PlayerPortalEvent event) {
            DSGameManager manager = FWDeathSwap2.this.gameManager;
            if (manager != null && manager.disallowsPortal(event.getPlayer())) {
                event.setCancelled(true);
            }
        }
    }
}

