/*
 * Decompiled with CFR 0.152.
 */
package xland.mcplugin.fwds;

import java.io.Reader;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class I18n {
    @NotNull
    private Configuration config = new MemoryConfiguration();
    @Nullable
    private Configuration defaultConfig;

    public void loadFrom(Reader r1, @Nullable Reader r2) {
        try (Reader reader = r1;
             Reader reader2 = r2;){
            this.config = YamlConfiguration.loadConfiguration((Reader)r1);
            if (r2 != null) {
                this.defaultConfig = YamlConfiguration.loadConfiguration((Reader)r2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public String getRaw(@NotNull String key) {
        Objects.requireNonNull(key, "key");
        String s = this.config.getString(key);
        if (s == null && this.defaultConfig != null) {
            s = this.defaultConfig.getString(key);
        }
        if (s == null) {
            return key;
        }
        return s;
    }

    @NotNull
    public String getRaw(@NotNull String key, Object ... args) {
        Objects.requireNonNull(args, "args");
        if (args.length == 0) {
            return this.getRaw(key);
        }
        return String.format(this.getRaw(key), args);
    }

    @NotNull
    public Component get(@NotNull String key) {
        return MiniMessage.miniMessage().deserialize((Object)this.getRaw(key));
    }

    @NotNull
    public Component get(@NotNull String key, Object ... args) {
        return MiniMessage.miniMessage().deserialize((Object)this.getRaw(key, args));
    }
}

