/*
 * Decompiled with CFR 0.152.
 */
package net.relics_rpgs.spell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.relics_rpgs.spell.CustomStatusEffect;
import net.relics_rpgs.util.SpellSchoolUtil;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;

public class RelicEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    private static final float T1_BUFF_MULTIPLIER = 0.1f;
    private static final float T2_BUFF_MULTIPLIER = 0.2f;
    public static final Effects.Entry LESSER_ATTACK_DAMAGE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_attack_damage"), "Sharpness", "Increases attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry LESSER_ATTACKS_SPEED = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_attack_speed"), "Valor", "Increases attack speed.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 34816), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry LESSER_RANGED_DAMAGE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_ranged_damage"), "Eagle Eye", "Increases ranged attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 136), new EffectConfig(List.of(new AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry LESSER_SPELL_POWER = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_spell_power"), "Spell Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(SpellSchoolUtil.allMagicSchools().stream().map(school -> new AttributeModifier(school.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry LESSER_SPELL_HASTE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_spell_haste"), "Spell Haste", "Increases spell haste.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880088), new EffectConfig(List.of(new AttributeModifier(SpellPowerMechanics.HASTE.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry LESSER_SPELL_CRIT = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_spell_crit_chance"), "Volatility", "Increases spell critical strike chance.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888888), new EffectConfig(List.of(new AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id.toString(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry LESSER_POWER_ARCANE_FIRE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_arcane_fire"), "Spell Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(SpellSchools.ARCANE, SpellSchools.FIRE).stream().map(school -> new AttributeModifier(school.id.toString(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry LESSER_POWER_FROST_HEALING = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_frost_healing"), "Spell Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(SpellSchools.FROST, SpellSchools.HEALING).stream().map(school -> new AttributeModifier(school.id.toString(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry LESSER_PROC_CRIT_DAMAGE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"lesser_spell_crit_damage"), "Amplify Spell", "Increases spell critical damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id.toString(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry MEDIUM_ATTACK_DAMAGE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_attack_damage"), "Strength", "Increases attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry MEDIUM_ATTACKS_SPEED = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_attack_speed"), "Tempo", "Increases attack speed.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 34816), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry MEDIUM_RANGED_DAMAGE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_ranged_damage"), "Power", "Increases ranged attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 136), new EffectConfig(List.of(new AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry MEDIUM_DEFENSE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_defense"), "Toughness", "Increases armor toughness.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888888), new EffectConfig(List.of(new AttributeModifier(Attributes.ARMOR_TOUGHNESS.getRegisteredName(), 4.0f, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry MEDIUM_EVASION = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_evasion"), "Monkey's Agility", "Increases evasion chance.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888888), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.EVASION_CHANCE.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry MEDIUM_SPELL_POWER = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_spell_power"), "Spell Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(SpellSchoolUtil.allMagicSchools().stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_SPELL_HASTE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_spell_haste"), "Spell Haste", "Increases spell haste.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880088), new EffectConfig(List.of(new AttributeModifier(SpellPowerMechanics.HASTE.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry MEDIUM_ARCANE_POWER = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_arcane_power"), "Arcane Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(SpellSchools.ARCANE).stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_FIRE_POWER = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_fire_power"), "Fire Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(SpellSchools.FIRE).stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_FROST_POWER = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_frost_power"), "Frost Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(SpellSchools.FROST).stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry MEDIUM_HEALING_POWER = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"medium_healing_power"), "Healing Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(SpellSchools.HEALING).stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry STUN = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"stun"), "Stunned", "Cannot move or act.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.JUMP_STRENGTH.getRegisteredName(), 0.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)))));
    public static Effects.Entry GREATER_EVASION_ATTACK = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"greater_evasion_attack"), "Evasion", "Increases attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888888), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_PHYSICAL_TRANCE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"greater_physical_trance"), "Battle Trance", "Increases melee and ranged attack speed.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_SPELL_TRANCE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"greater_spell_trance"), "Spell Trance", "Increases spell haste.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(List.of(new AttributeModifier(SpellPowerMechanics.HASTE.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GREATER_DEFENSE_ARMOR = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"greater_defense_armor"), "Fortitude", "Increases armor.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888888), new EffectConfig(List.of(new AttributeModifier(Attributes.ARMOR.getRegisteredName(), 10.0f, AttributeModifier.Operation.ADD_VALUE)))));
    public static Effects.Entry SUPERIOR_ATTACK_DAMAGE = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"superior_attack_damage"), "Might", "Increases attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x880000), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.SCALE.getRegisteredName(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SUPERIOR_SPELL_POWER = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"superior_spell_power"), "Spell Power", "Increases spell power.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x888800), new EffectConfig(SpellSchoolUtil.allOffensiveMagicSchools().stream().map(school -> new AttributeModifier(school.id.toString(), 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList())));
    public static Effects.Entry SUPERIOR_HEALING_TAKEN = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"superior_healing_taken"), "Divinity", "Increases healing taken.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 34816), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.HEALING_TAKEN.id.toString(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SUPERIOR_DEFENSE_HEALTH = RelicEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"superior_defense_health"), "Vigor", "Increases maximum health.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 34816), new EffectConfig(List.of(new AttributeModifier(Attributes.MAX_HEALTH.getRegisteredName(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        ActionImpairing.configure((MobEffect)RelicEffects.STUN.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        for (Effects.Entry entry : entries) {
            Synchronized.configure((MobEffect)entry.effect, (boolean)true);
        }
        Effects.register(entries, (Map)config.effects);
    }
}

