/*
 * Decompiled with CFR 0.152.
 */
package net.relics_rpgs.spell;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellHandlers;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import org.jetbrains.annotations.Nullable;

public class RelicMechanics {
    public static final ResourceLocation SHIELD_RESET = ResourceLocation.fromNamespaceAndPath((String)"relics_rpgs", (String)"shield_reset");

    public static void init() {
        SpellHandlers.registerCustomImpact((ResourceLocation)SHIELD_RESET, (SpellHandlers.CustomImpact)new SpellHandlers.CustomImpact(){

            public SpellHandlers.ImpactResult onSpellImpact(Holder<Spell> registryEntry, SpellPower.Result result, LivingEntity caster, @Nullable Entity entity, SpellHelper.ImpactContext impactContext) {
                if (caster instanceof Player) {
                    Player player = (Player)caster;
                    boolean success = this.tryResetShield(player, player.getMainHandItem()) || this.tryResetShield(player, player.getOffhandItem());
                    return new SpellHandlers.ImpactResult(success, false);
                }
                return new SpellHandlers.ImpactResult(false, false);
            }

            private boolean tryResetShield(Player player, ItemStack itemStack) {
                Item item;
                if (itemStack != null && (item = itemStack.getItem()) instanceof ShieldItem) {
                    ShieldItem shield = (ShieldItem)item;
                    if (player.getCooldowns().isOnCooldown((Item)shield)) {
                        player.getCooldowns().addCooldown((Item)shield, 0);
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

