/*
 * Decompiled with CFR 0.152.
 */
package net.relics_rpgs.datagen;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.resources.ResourceLocation;
import net.relics_rpgs.item.Group;
import net.relics_rpgs.item.RelicItemTags;
import net.relics_rpgs.item.RelicItems;
import net.relics_rpgs.spell.RelicEffects;
import net.relics_rpgs.spell.RelicSounds;
import net.relics_rpgs.spell.RelicSpells;
import net.spell_engine.api.datagen.SimpleSoundGenerator;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;

public class RelicsDataGen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(LangGenerator::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(RelicsSpellGen::new);
        pack.addProvider(SoundGen::new);
    }

    public static class SoundGen
    extends SimpleSoundGenerator {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGenerator.Builder builder) {
            builder.entries.add(new SimpleSoundGenerator.Entry("relics_rpgs", RelicSounds.entries.stream().map(RelicSounds.Entry::name).toList()));
        }
    }

    public static class RelicsSpellGen
    extends SpellGenerator {
        public RelicsSpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (RelicSpells.Entry entry : RelicSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        }

        public void generateItemModels(ItemModelGenerators itemModelGenerator) {
            RelicItems.entries.forEach(entry -> itemModelGenerator.generateFlatItem(entry.item().get(), ModelTemplates.FLAT_ITEM));
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(HolderLookup.Provider wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            translationBuilder.add("trinkets.slot.spell.trinket", "Trinket");
            translationBuilder.add("trinkets.slot.charm.trinket", "Trinket");
            translationBuilder.add(Group.translationKey, "Relics");
            RelicItems.entries.forEach(entry -> translationBuilder.add(entry.item().get().getDescriptionId(), entry.translatedName()));
            RelicSpells.entries.forEach(entry -> {
                ResourceLocation id = entry.id();
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".name", entry.title());
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".description", entry.description());
            });
            RelicEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.getDescriptionId(), entry.title);
                translationBuilder.add(entry.effect.getDescriptionId() + ".description", entry.description);
            });
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            FabricTagProvider.FabricTagBuilder all = this.getOrCreateTagBuilder(RelicItemTags.ALL);
            RelicItems.entries.forEach(entry -> all.addOptional(entry.id()));
            HashMap<ResourceLocation, Equipment.LootProperties> relicEntries = new HashMap<ResourceLocation, Equipment.LootProperties>();
            for (RelicItems.Entry entry2 : RelicItems.entries) {
                ResourceLocation id = entry2.id();
                Equipment.LootProperties lootProperties = Equipment.LootProperties.of((int)entry2.tier(), (String)entry2.lootTheme);
                relicEntries.put(id, lootProperties);
            }
            this.generateRelicTags(relicEntries);
        }
    }
}

