/*
 * Decompiled with CFR 0.152.
 */
package de.tert0.containerclaims;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.tert0.containerclaims.GroupComponent;
import de.tert0.containerclaims.GroupState;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;

public record ClaimComponent(UUID owner, Instant timestamp, ImmutableSet<UUID> trusted, ImmutableSet<UUID> trustedGroups) {
    public static final Codec<ClaimComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("owner").forGetter(ClaimComponent::owner), (App)Codec.LONG.xmap(Instant::ofEpochMilli, Instant::toEpochMilli).fieldOf("timestamp").forGetter(ClaimComponent::timestamp), (App)class_4844.field_25122.listOf().xmap(ImmutableSet::copyOf, ImmutableCollection::asList).fieldOf("trusted").forGetter(ClaimComponent::trusted), (App)class_4844.field_25122.listOf().xmap(ImmutableSet::copyOf, ImmutableCollection::asList).optionalFieldOf("trusted_groups").xmap(o -> o.orElse(ImmutableSet.of()), Optional::of).forGetter(ClaimComponent::trustedGroups)).apply((Applicative)instance, ClaimComponent::new));

    public ClaimComponent withTrusted(ImmutableSet<UUID> trusted) {
        return new ClaimComponent(this.owner, this.timestamp, trusted, this.trustedGroups);
    }

    public ClaimComponent addTrusted(Collection<UUID> entries) {
        return this.withTrusted((ImmutableSet<UUID>)ImmutableSet.builder().addAll(this.trusted).addAll(entries).build());
    }

    public ClaimComponent removeTrusted(Collection<UUID> entries) {
        return this.withTrusted((ImmutableSet<UUID>)((ImmutableSet)this.trusted.stream().filter(uuid -> !entries.contains(uuid)).collect(ImmutableSet.toImmutableSet())));
    }

    public ClaimComponent withTrustedGroups(ImmutableSet<UUID> trustedGroups) {
        return new ClaimComponent(this.owner, this.timestamp, this.trusted, trustedGroups);
    }

    public ClaimComponent addTrustedGroups(Collection<UUID> entries) {
        return this.withTrustedGroups((ImmutableSet<UUID>)ImmutableSet.builder().addAll(this.trustedGroups).addAll(entries).build());
    }

    public ClaimComponent removeTrustedGroups(Collection<UUID> entries) {
        return this.withTrustedGroups((ImmutableSet<UUID>)((ImmutableSet)this.trustedGroups.stream().filter(uuid -> !entries.contains(uuid)).collect(ImmutableSet.toImmutableSet())));
    }

    public ClaimComponent fixup(MinecraftServer server) {
        if (this.trustedGroups.isEmpty()) {
            return this;
        }
        Collection groupUuids = GroupState.getState(server).getGroups().stream().map(GroupComponent::uuid).collect(Collectors.toSet());
        return this.withTrustedGroups((ImmutableSet<UUID>)((ImmutableSet)this.trustedGroups.stream().filter(groupUuids::contains).collect(ImmutableSet.toImmutableSet())));
    }
}

