/*
 * Decompiled with CFR 0.152.
 */
package de.tert0.containerclaims;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_4844;

public record GroupComponent(UUID uuid, String name, UUID owner, ImmutableSet<UUID> members) {
    public static final Codec<GroupComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("uuid").forGetter(GroupComponent::uuid), (App)Codec.STRING.fieldOf("name").forGetter(GroupComponent::name), (App)class_4844.field_25122.fieldOf("owner").forGetter(GroupComponent::owner), (App)class_4844.field_25122.listOf().fieldOf("members").xmap(ImmutableSet::copyOf, ImmutableCollection::asList).forGetter(GroupComponent::members)).apply((Applicative)instance, GroupComponent::new));

    public GroupComponent withOwner(UUID owner) {
        return new GroupComponent(this.uuid, this.name, owner, this.members);
    }

    public GroupComponent withMembers(ImmutableSet<UUID> members) {
        return new GroupComponent(this.uuid, this.name, this.owner, members);
    }

    public GroupComponent addMembers(Collection<UUID> entries) {
        return this.withMembers((ImmutableSet<UUID>)ImmutableSet.builder().addAll(this.members).addAll(entries).build());
    }

    public GroupComponent removeMembers(Collection<UUID> entries) {
        return this.withMembers((ImmutableSet<UUID>)((ImmutableSet)this.members.stream().filter(uuid -> !entries.contains(uuid)).collect(ImmutableSet.toImmutableSet())));
    }

    public boolean isMember(class_1657 player) {
        return this.isMember(player.method_5667());
    }

    public boolean isMember(UUID uuid) {
        return this.owner.equals(uuid) || this.members.contains((Object)uuid);
    }
}

