/*
 * Decompiled with CFR 0.152.
 */
package de.tert0.containerclaims;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.tert0.containerclaims.AdminModeAccess;
import de.tert0.containerclaims.ClaimAccess;
import de.tert0.containerclaims.ClaimComponent;
import de.tert0.containerclaims.ClaimUtils;
import de.tert0.containerclaims.ContainerClaimMod;
import de.tert0.containerclaims.DoubleChestUtils;
import de.tert0.containerclaims.GlobalClaimState;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class ClaimCommand {
    private static final SimpleCommandExceptionType NO_CONTAINER_FOCUSED = new SimpleCommandExceptionType((Message)new LiteralMessage("You have to look at a container block"));
    private static final SimpleCommandExceptionType BLOCK_TYPE_NOT_SUPPORTED = new SimpleCommandExceptionType((Message)new LiteralMessage("This block type is not supported"));
    private static final SimpleCommandExceptionType INTERNAL_ERROR = new SimpleCommandExceptionType((Message)new LiteralMessage("Internal error. Please report this error"));
    private static final SimpleCommandExceptionType NOT_CLAIMED = new SimpleCommandExceptionType((Message)new LiteralMessage("The container is not claimed!"));
    private static final SimpleCommandExceptionType NOT_OWNER = new SimpleCommandExceptionType((Message)new LiteralMessage("The container is not yours!"));
    private static final SimpleCommandExceptionType ALREADY_CLAIMED = new SimpleCommandExceptionType((Message)new LiteralMessage("The container is already claimed!"));
    private static final SimpleCommandExceptionType PAGE_OUT_OF_BOUNDS = new SimpleCommandExceptionType((Message)new LiteralMessage("Page out of bounds"));
    private static final SimpleCommandExceptionType MISSING_DIMENSION_REGISTRY_KEY = new SimpleCommandExceptionType((Message)new LiteralMessage("Internal Error. Dimension has no Registry Key"));
    private static final int LIST_PAGE_SIZE = 8;

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cclaim").executes(ClaimCommand::helpCommand)).then(class_2170.method_9247((String)"help").executes(ClaimCommand::helpCommand))).then(class_2170.method_9247((String)"info").executes(ClaimCommand::infoCommand))).then(class_2170.method_9247((String)"claim").executes(ClaimCommand::claimCommand))).then(class_2170.method_9247((String)"unclaim").executes(ClaimCommand::unclaimCommand))).then(class_2170.method_9247((String)"trust").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(ClaimCommand::trustCommand)))).then(class_2170.method_9247((String)"untrust").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(ClaimCommand::untrustCommand)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"adminmode").requires(Permissions.require((String)"cclaim.adminmode", (int)3))).executes(ClaimCommand::adminmodeCommand))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"cclaim.list", (int)2))).executes(ctx -> ClaimCommand.listCommand((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_9207().method_51469(), 1))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> ClaimCommand.listCommand((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ClaimCommand.listCommand((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(class_2170.method_9247((String)"all").executes(ctx -> ClaimCommand.listCommand((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), -1)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(Permissions.require((String)"cclaim.debug", (int)4))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"verify").requires(Permissions.require((String)"cclaim.debug.verify", (int)4))).executes(ctx -> ClaimCommand.verifyCommand((CommandContext<class_2168>)ctx, ((class_2168)ctx.getSource()).method_9207().method_51469(), false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> ClaimCommand.verifyCommand((CommandContext<class_2168>)ctx, class_2181.method_9289((CommandContext)ctx, (String)"dimension"), false))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"load").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"WARNING: This will load all chunks with registered claims in them. Be careful, especially in production!").method_54663(-256), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"To confirm that you want to do this, run /cclaim debug verify <dimension> load confirm"), false);
            return 0;
        })).then(class_2170.method_9247((String)"confirm").executes(ctx -> ClaimCommand.verifyCommand((CommandContext<class_2168>)ctx, class_2181.method_9289((CommandContext)ctx, (String)"dimension"), true)))))))));
    }

    private static ClaimAccess getFocusedClaimAccess(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_239 class_2392 = player.method_5745(player.method_45325(class_5134.field_47758), 1.0f, false);
        if (!(class_2392 instanceof class_3965)) {
            throw NO_CONTAINER_FOCUSED.create();
        }
        class_3965 result = (class_3965)class_2392;
        class_2338 pos = result.method_17777();
        class_2586 blockEntity = player.method_51469().method_8321(pos);
        if (blockEntity == null) {
            throw NO_CONTAINER_FOCUSED.create();
        }
        if (!ContainerClaimMod.SUPPORTED_BLOCK_ENTITIES.contains(blockEntity.method_11017())) {
            throw BLOCK_TYPE_NOT_SUPPORTED.create();
        }
        if (!(blockEntity instanceof ClaimAccess)) {
            throw INTERNAL_ERROR.create();
        }
        ClaimAccess claimAccess = (ClaimAccess)blockEntity;
        return claimAccess;
    }

    private static void checkForOwnedClaim(ClaimAccess claimAccess, class_3222 player) throws CommandSyntaxException {
        if (!ClaimUtils.isClaimed(claimAccess)) {
            throw NOT_CLAIMED.create();
        }
        if (!ClaimUtils.isOwnerOrAdmin(claimAccess, (class_1657)player)) {
            throw NOT_OWNER.create();
        }
    }

    private static int helpCommand(CommandContext<class_2168> ctx) {
        class_5250 text = class_2561.method_43470((String)"");
        text.method_10852((class_2561)class_2561.method_43470((String)"Container Claim Mod - Help\n").method_54663(-11010079));
        text.method_27693("-".repeat(20) + "\n");
        text.method_27693("This can be used to claim container blocks like chests or barrels.\n");
        text.method_27693("To claim a container block, look at the block and run ");
        text.method_10852((class_2561)class_2561.method_43470((String)"/cclaim claim\n").method_54663(-256).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/cclaim claim"))));
        text.method_10852((class_2561)class_2561.method_43470((String)"/cclaim unlaim").method_54663(-256).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/cclaim unclaim"))));
        text.method_27693(" can be used to unclaim a container\n");
        text.method_27693("You can allow others to use a claimed container using ");
        text.method_10852((class_2561)class_2561.method_43470((String)"/cclaim trust <player>").method_54663(-256).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/cclaim trust "))));
        text.method_27693(". To revoke these permissions, you can use ");
        text.method_10852((class_2561)class_2561.method_43470((String)"/cclaim untrust <player>").method_54663(-256).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/cclaim untrust "))));
        text.method_27693("\n");
        text.method_27693("To get information about a claim, you can use ");
        text.method_10852((class_2561)class_2561.method_43470((String)"/cclaim info").method_54663(-256).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/cclaim info"))));
        text.method_27693(".\n");
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private static int infoCommand(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ClaimAccess claimAccess = ClaimCommand.getFocusedClaimAccess(ctx);
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_5250 text = class_2561.method_43470((String)"");
        text.method_10852((class_2561)class_2561.method_43470((String)"Container Claim Info\n").method_54663(-11010079));
        text.method_27693("-".repeat(20) + "\n");
        if (!ClaimUtils.isClaimed(claimAccess)) {
            text.method_10852((class_2561)class_2561.method_43470((String)"This container is not claimed!").method_54663(-2142128));
        } else if (!ClaimUtils.canUse(claimAccess, (class_1657)player) && !Permissions.check((class_1297)player, (String)"cclaim.info.admin", (int)2)) {
            text.method_10852((class_2561)class_2561.method_43470((String)"This container is claimed!").method_54663(-171));
        } else {
            class_11561 userCache = ((class_2168)ctx.getSource()).method_9211().method_73550().comp_4407();
            text.method_27693("Owner: ");
            UUID ownerUuid = claimAccess.cclaims$getClaim().owner();
            text.method_10852((class_2561)class_2561.method_43470((String)Optional.ofNullable(userCache).flatMap(uc -> uc.method_14512(ownerUuid)).map(class_11560::comp_4423).orElse(ownerUuid.toString())).method_54663(-16711936));
            text.method_27693("\n");
            text.method_27693("Trusted: ");
            ImmutableSet<UUID> trustedUuids = claimAccess.cclaims$getClaim().trusted();
            if (trustedUuids.isEmpty()) {
                text.method_10852((class_2561)class_2561.method_43470((String)"\u00af\\_(\u30c4)_/\u00af").method_54663(-256));
            } else {
                for (UUID trustedUuid : trustedUuids) {
                    text.method_10852(class_2561.method_30163((String)"\n  - "));
                    text.method_10852((class_2561)class_2561.method_43470((String)Optional.ofNullable(userCache).flatMap(uc -> uc.method_14512(trustedUuid)).map(class_11560::comp_4423).orElse(trustedUuid.toString())).method_54663(-171));
                }
            }
            if (Permissions.check((class_1297)player, (String)"cclaim.info.admin", (int)2)) {
                String formattedTimestamp = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC).format(claimAccess.cclaims$getClaim().timestamp());
                text.method_27693("\n");
                text.method_27693("Timestamp: " + formattedTimestamp);
            }
        }
        ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private static int claimCommand(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ClaimAccess claimAccess = ClaimCommand.getFocusedClaimAccess(ctx);
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        if (ClaimUtils.isClaimed(claimAccess)) {
            throw ALREADY_CLAIMED.create();
        }
        ClaimUtils.claim(claimAccess, player.method_5667(), player.method_51469());
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"Claimed container"), false);
        return 1;
    }

    private static int unclaimCommand(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ClaimAccess claimAccess = ClaimCommand.getFocusedClaimAccess(ctx);
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        ClaimCommand.checkForOwnedClaim(claimAccess, player);
        ClaimUtils.unclaim(claimAccess, player.method_51469());
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"Unclaimed container"), false);
        return 1;
    }

    private static int trustCommand(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ClaimAccess claimAccess = ClaimCommand.getFocusedClaimAccess(ctx);
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        ClaimCommand.checkForOwnedClaim(claimAccess, player);
        Collection targets = class_2191.method_9330(ctx, (String)"targets");
        ArrayList<UUID> entries = new ArrayList<UUID>();
        for (class_11560 target : targets) {
            entries.add(target.comp_4422());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)("Added " + target.comp_4423() + " as trusted player")), false);
        }
        ClaimUtils.trust(claimAccess, entries);
        if (targets.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"No targets found"), false);
        }
        return targets.size();
    }

    private static int untrustCommand(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ClaimAccess claimAccess = ClaimCommand.getFocusedClaimAccess(ctx);
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        ClaimCommand.checkForOwnedClaim(claimAccess, player);
        Collection targets = class_2191.method_9330(ctx, (String)"targets");
        ArrayList<UUID> entries = new ArrayList<UUID>();
        for (class_11560 target : targets) {
            if (ClaimUtils.isTrusted(claimAccess, target.comp_4422())) {
                entries.add(target.comp_4422());
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)("Removed " + target.comp_4423() + " as a trusted player")), false);
                continue;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)(target.comp_4423() + " was not trusted")), false);
        }
        ClaimUtils.untrust(claimAccess, entries);
        if (entries.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"No player to untrust found"), false);
        }
        return entries.size();
    }

    private static int adminmodeCommand(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        AdminModeAccess adminModeAccess;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        adminModeAccess.cclaims$setAdminMode(!(adminModeAccess = (AdminModeAccess)player).cclaims$getAdminMode());
        if (adminModeAccess.cclaims$getAdminMode()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"Enabled Container Claim Admin Mode"), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)"Disabled Container Claim Admin Mode"), true);
        }
        return 1;
    }

    private static class_5250 getTextOfBlockPos(class_2338 pos, boolean copyable) {
        String formattedPos = pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
        class_5250 text = class_2561.method_43470((String)formattedPos).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)"Click to teleport"))).method_10958((class_2558)new class_2558.class_10609("/tp " + formattedPos)));
        if (copyable) {
            text.method_10852((class_2561)class_2561.method_43470((String)" (Copy)").method_54663(-6250336).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)"Click to copy"))).method_10958((class_2558)new class_2558.class_10606(formattedPos))));
        }
        return text;
    }

    private static int listCommand(class_2168 source, class_3218 serverWorld, int page) throws CommandSyntaxException {
        List positions = GlobalClaimState.getWorldState(serverWorld).getPositions().stream().sorted().toList();
        class_2960 dimension = ((class_5321)serverWorld.method_40134().method_40230().orElseThrow(() -> ((SimpleCommandExceptionType)MISSING_DIMENSION_REGISTRY_KEY).create())).method_29177();
        String dimensionName = dimension.method_12832();
        int totalPageCount = Math.ceilDiv(positions.size(), 8);
        class_5250 text = class_2561.method_43470((String)"");
        text.method_10852((class_2561)class_2561.method_43470((String)("--- Container Claims - " + dimensionName + " (" + positions.size() + ") ---")).method_54663(-11010079));
        if (positions.isEmpty()) {
            text.method_10852((class_2561)class_2561.method_43470((String)"\nNo registered claims").method_54663(-2142128));
        } else {
            if (page > totalPageCount) {
                throw PAGE_OUT_OF_BOUNDS.create();
            }
            if (page != -1) {
                positions = positions.subList((page - 1) * 8, Math.min(page * 8, positions.size()));
            }
            for (class_2338 pos : positions) {
                ClaimAccess claimAccess;
                Optional<class_2561> extraText = Optional.empty();
                if (serverWorld.method_8477(pos) && (claimAccess = (ClaimAccess)serverWorld.method_8321(pos)) != null) {
                    UUID ownerUuid = claimAccess.cclaims$getClaim().owner();
                    List<String> trustedNames = claimAccess.cclaims$getClaim().trusted().stream().map(uuid -> serverWorld.method_8503().method_73550().comp_4407() != null ? (String)serverWorld.method_8503().method_73550().comp_4407().method_14512(uuid).map(class_11560::comp_4423).orElse(null) : null).filter(Objects::nonNull).toList();
                    extraText = Optional.ofNullable(serverWorld.method_8503().method_73550().comp_4407()).flatMap(userCache -> userCache.method_14512(ownerUuid)).map(class_11560::comp_4423).map(name -> class_2561.method_43470((String)(" - " + name)).method_54663(-256).method_27694(style -> !trustedNames.isEmpty() ? style.method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)String.join((CharSequence)"\n", trustedNames)))) : style));
                }
                text.method_10852(class_2561.method_30163((String)"\n  - "));
                text.method_10852((class_2561)ClaimCommand.getTextOfBlockPos(pos, true).method_27661().method_54663(-16711936));
                extraText.ifPresent(arg_0 -> ((class_5250)text).method_10852(arg_0));
            }
            if (page != -1) {
                class_5250 btnPrev = page > 1 ? class_2561.method_43470((String)"<<").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/cclaim list " + String.valueOf(dimension) + " " + (page - 1))).method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)"Previous Page")))) : class_2561.method_43470((String)"<<");
                class_5250 btnNext = page + 1 <= totalPageCount ? class_2561.method_43470((String)">>").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/cclaim list " + String.valueOf(dimension) + " " + (page + 1))).method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)"Next Page")))) : class_2561.method_43470((String)">>");
                text.method_10852((class_2561)class_2561.method_43470((String)"\n----- ").method_54663(-11010079).method_10852((class_2561)btnPrev).method_10852(class_2561.method_30163((String)(" Page " + page + " of " + totalPageCount + " "))).method_10852((class_2561)btnNext).method_27693(" -----"));
            } else {
                text.method_10852((class_2561)class_2561.method_43470((String)("\n" + "-".repeat(30))).method_54663(-11010079));
            }
        }
        source.method_9226(() -> text, false);
        return 1;
    }

    private static int verifyCommand(CommandContext<class_2168> ctx, class_3218 serverWorld, boolean loadChunks) {
        ImmutableSet<class_2338> allPositions = GlobalClaimState.getWorldState(serverWorld).getPositions();
        Set loadedPositions = allPositions.stream().filter(pos -> serverWorld.method_8477(pos) || loadChunks).collect(Collectors.toSet());
        ArrayList<class_3545> problems = new ArrayList<class_3545>();
        for (class_2338 pos2 : loadedPositions) {
            ClaimAccess claimAccess = (ClaimAccess)serverWorld.method_8321(pos2);
            if (claimAccess == null || !ClaimUtils.isClaimed(claimAccess)) {
                problems.add(new class_3545((Object)pos2, (Object)class_2561.method_43470((String)"Claim not found").method_54663(-65536)));
                continue;
            }
            ClaimAccess otherClaimAccess = (ClaimAccess)DoubleChestUtils.getNeighborBlockEntity(pos2, (class_1937)serverWorld);
            if (otherClaimAccess == null) continue;
            if (!ClaimUtils.isClaimed(otherClaimAccess)) {
                problems.add(new class_3545((Object)pos2, (Object)class_2561.method_43470((String)"Double Chest not fully claimed").method_54663(-256)));
                continue;
            }
            ClaimComponent claim = claimAccess.cclaims$getClaim();
            ClaimComponent otherClaim = otherClaimAccess.cclaims$getClaim();
            if (!claim.owner().equals(otherClaim.owner())) {
                problems.add(new class_3545((Object)pos2, (Object)class_2561.method_43470((String)"Double Chest owners do not match").method_54663(-256)));
                continue;
            }
            if (claim.trusted().equals(otherClaim.trusted())) continue;
            problems.add(new class_3545((Object)pos2, (Object)class_2561.method_43470((String)"Double Chest trusted players do not match").method_54663(-256)));
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_30163((String)("Checked " + loadedPositions.size() + "/" + allPositions.size() + " positions")), false);
        if (problems.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No problems found").method_54663(-16711936), false);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)(problems.size() + " problems found")).method_54663(-65536), false);
            for (class_3545 entry : problems) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"- ").method_10852((class_2561)ClaimCommand.getTextOfBlockPos((class_2338)entry.method_15442(), false).method_54663(-16711936)).method_27693(": ").method_10852((class_2561)entry.method_15441()), false);
            }
        }
        return 1;
    }
}

