/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftearthmod.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftearthmod.init.MinecraftEarthModModEntities;
import net.minecraftearthmod.procedures.FurnaceGolemOnEntityTickUpdateProcedure;
import net.minecraftearthmod.procedures.GetSpawnGolemsProcedure;
import net.minecraftearthmod.procedures.IfFurnaceGolemAngryProcedure;
import net.minecraftearthmod.procedures.SetPissedProcedure;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class FurnaceGolemEntity
extends IronGolem {
    public FurnaceGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FurnaceGolemEntity>)((EntityType)MinecraftEarthModModEntities.FURNACE_GOLEM.get()), world);
    }

    public FurnaceGolemEntity(EntityType<FurnaceGolemEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
        this.m_21557_(false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected double m_6639_(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.iron_golem.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        SetPissedProcedure.execute((Entity)this);
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        FurnaceGolemOnEntityTickUpdateProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public void m_8107_() {
        super.m_8107_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        FurnaceGolemEntity entity = this;
        Level world = this.f_19853_;
        if (IfFurnaceGolemAngryProcedure.execute((Entity)entity)) {
            for (int l = 0; l < 5; ++l) {
                double x0 = x + 0.5 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.5;
                double y0 = y + 1.2 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.5;
                double z0 = z + 0.5 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.5;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x0, y0, z0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)MinecraftEarthModModEntities.FURNACE_GOLEM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return GetSpawnGolemsProcedure.execute((LevelAccessor)world);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 100.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 10.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.5);
        return builder;
    }
}

