/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftearthmod.entity;

import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftearthmod.entity.MelonGolemEntityProjectile;
import net.minecraftearthmod.init.MinecraftEarthModModBlocks;
import net.minecraftearthmod.init.MinecraftEarthModModEntities;
import net.minecraftearthmod.procedures.GetSpawnGolemsProcedure;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class MelonGolemEntity
extends PathfinderMob
implements RangedAttackMob {
    public MelonGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<MelonGolemEntity>)((EntityType)MinecraftEarthModModEntities.MELON_GOLEM.get()), world);
    }

    public MelonGolemEntity(EntityType<MelonGolemEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 3;
        this.m_21557_(false);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)MinecraftEarthModModBlocks.CARVED_MELON.get()));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 20, 10.0f){

            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.snow_golem.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.snow_golem.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.break"));
    }

    public void m_6504_(LivingEntity target, float flval) {
        MelonGolemEntityProjectile entityarrow = new MelonGolemEntityProjectile((EntityType<? extends MelonGolemEntityProjectile>)((EntityType)MinecraftEarthModModEntities.MELON_GOLEM_PROJECTILE.get()), (LivingEntity)this, this.f_19853_);
        double d0 = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double d1 = target.m_20185_() - this.m_20185_();
        double d3 = target.m_20189_() - this.m_20189_();
        entityarrow.m_6686_(d1, d0 - entityarrow.m_20186_() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f, d3, 1.6f, 12.0f);
        this.f_19853_.m_7967_((Entity)entityarrow);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)MinecraftEarthModModEntities.MELON_GOLEM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return GetSpawnGolemsProcedure.execute((LevelAccessor)world);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 4.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.1);
        builder = builder.m_22268_(Attributes.f_22281_, 20.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

