/*
 * Decompiled with CFR 0.152.
 */
package fuzs.convenienteffects.client.handler;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.convenienteffects.ConvenientEffects;
import fuzs.convenienteffects.config.ClientConfig;
import fuzs.convenienteffects.config.ServerConfig;
import fuzs.convenienteffects.handler.VanillaEffectsHandler;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import org.jetbrains.annotations.Nullable;

public class VanillaEffectsClientHandler {
    public static void onRenderFog$1(GameRenderer gameRenderer, Camera camera, float partialTicks, FogRenderer.FogMode fogMode, FogType fogType, MutableFloat fogStart, MutableFloat fogEnd, MutableValue<FogShape> fogShape) {
        LocalPlayer player;
        Entity entity;
        if (!((ServerConfig)ConvenientEffects.CONFIG.get(ServerConfig.class)).strongerBlindness) {
            return;
        }
        if (fogType != FogType.LAVA && fogType != FogType.POWDER_SNOW && (entity = camera.getEntity()) instanceof LocalPlayer && (player = (LocalPlayer)entity).hasEffect(MobEffects.BLINDNESS)) {
            MobEffectInstance mobEffectInstance = player.getEffect(MobEffects.BLINDNESS);
            float multiplier = VanillaEffectsHandler.getVisibilityMultiplier(mobEffectInstance.getAmplifier());
            fogStart.mapFloat(value -> Float.valueOf(value.floatValue() * multiplier));
            fogEnd.mapFloat(value -> Float.valueOf(value.floatValue() * multiplier));
        }
    }

    public static void onRenderFog$2(GameRenderer gameRenderer, Camera camera, float partialTicks, FogRenderer.FogMode fogMode, FogType fogType, MutableFloat fogStart, MutableFloat fogEnd, MutableValue<FogShape> fogShape) {
        LocalPlayer player;
        Entity entity;
        if (!((ClientConfig)ConvenientEffects.CONFIG.get(ClientConfig.class)).betterFireResistanceVision) {
            return;
        }
        if (fogType == FogType.LAVA && (entity = camera.getEntity()) instanceof LocalPlayer && VanillaEffectsClientHandler.applyFireResistanceEffects((Player)(player = (LocalPlayer)entity))) {
            float fogDistance;
            MobEffectInstance mobEffectInstance = player.getEffect(MobEffects.FIRE_RESISTANCE);
            if (player.isCreative() || mobEffectInstance.isInfiniteDuration()) {
                fogDistance = 1.0f;
            } else {
                float effectFadeTime = (float)((ClientConfig)ConvenientEffects.CONFIG.get(ClientConfig.class)).effectFadeTime * 20.0f;
                fogDistance = Mth.clamp((float)(((float)mobEffectInstance.getDuration() - partialTicks) / effectFadeTime), (float)0.0f, (float)1.0f);
            }
            fogStart.accept(Mth.lerp((float)fogDistance, (float)0.25f, (float)-4.0f));
            fogEnd.accept(Mth.lerp((float)fogDistance, (float)1.0f, (float)(gameRenderer.getRenderDistance() * 0.25f)));
        }
    }

    public static EventResult onRenderBlockOverlay(LocalPlayer player, PoseStack poseStack, @Nullable BlockState blockState) {
        if (!((ClientConfig)ConvenientEffects.CONFIG.get(ClientConfig.class)).betterFireResistanceVision) {
            return EventResult.PASS;
        }
        if (blockState == Blocks.FIRE.defaultBlockState() && VanillaEffectsClientHandler.applyFireResistanceEffects((Player)player)) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    private static boolean applyFireResistanceEffects(Player player) {
        return player.isCreative() || !player.isSpectator() && player.hasEffect(MobEffects.FIRE_RESISTANCE);
    }
}

