/*
 * Decompiled with CFR 0.152.
 */
package fuzs.convenienteffects.client.util;

import com.mojang.serialization.DynamicOps;
import fuzs.convenienteffects.ConvenientEffects;
import fuzs.convenienteffects.config.ClientConfig;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelHeightAccessor;

public class EffectParticleRenderHelper {
    public static boolean addEffectParticles(Entity entity, List<ParticleOptions> effectParticles) {
        boolean isCameraEntity;
        boolean bl = isCameraEntity = entity == Minecraft.getInstance().getCameraEntity();
        if (isCameraEntity || ((ClientConfig)ConvenientEffects.CONFIG.get(ClientConfig.class)).reduceEffectParticlesForAllEntities) {
            ClientConfig.EffectParticleStatus particleStatus = ClientConfig.getParticleStatus(isCameraEntity);
            if (particleStatus == ClientConfig.EffectParticleStatus.DISCREET) {
                EffectParticleRenderHelper.addDiscreetEffectParticles(entity, effectParticles);
            }
            return particleStatus != ClientConfig.EffectParticleStatus.ALL;
        }
        return false;
    }

    public static void addDiscreetEffectParticles(Entity entity, List<ParticleOptions> effectParticles) {
        if (!effectParticles.isEmpty()) {
            ParticleOptions particleOptions;
            Particle particle;
            int invisibleMultiplier = entity.isInvisible() ? 15 : 4;
            int ambientMultiplier = 5;
            if (entity.getRandom().nextInt(invisibleMultiplier * ambientMultiplier) == 0 && (particle = EffectParticleRenderHelper.addParticle(particleOptions = (ParticleOptions)Util.getRandom(effectParticles, (RandomSource)entity.getRandom()), entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 1.0, 1.0, 1.0)) != null) {
                particle.setAlpha(0.15f);
            }
        }
    }

    public static Particle addParticle(ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return EffectParticleRenderHelper.addParticle(options, options.getType().getOverrideLimiter(), false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static Particle addParticle(ParticleOptions options, boolean force, boolean decreased, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Minecraft minecraft = Minecraft.getInstance();
        try {
            return minecraft.levelRenderer.addParticleInternal(options, force, decreased, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        catch (Throwable var19) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)var19, (String)"Exception while adding particle");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Particle being added");
            crashReportCategory.setDetail("ID", (Object)BuiltInRegistries.PARTICLE_TYPE.getKey((Object)options.getType()));
            crashReportCategory.setDetail("Parameters", () -> ParticleTypes.CODEC.encodeStart((DynamicOps)minecraft.level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)options).toString());
            crashReportCategory.setDetail("Position", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)minecraft.level, (double)x, (double)y, (double)z));
            throw new ReportedException(crashReport);
        }
    }
}

