/*
 * Decompiled with CFR 0.152.
 */
package fuzs.convenienteffects.handler;

import fuzs.convenienteffects.ConvenientEffects;
import fuzs.convenienteffects.config.ServerConfig;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public class VanillaEffectsHandler {
    public static void onEndEntityTick(Entity entity) {
        LivingEntity livingEntity;
        if (!((ServerConfig)ConvenientEffects.CONFIG.get(ServerConfig.class)).noFireResistanceBurnTime) {
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(MobEffects.FIRE_RESISTANCE)) {
            entity.setRemainingFireTicks(Math.min(1, entity.getRemainingFireTicks()));
        }
    }

    public static void onLivingVisibility(LivingEntity entity, @Nullable Entity lookingEntity, MutableDouble visibilityPercentage) {
        Mob mob;
        if (!((ServerConfig)ConvenientEffects.CONFIG.get(ServerConfig.class)).strongerBlindness) {
            return;
        }
        if (lookingEntity instanceof Mob && (mob = (Mob)lookingEntity).hasEffect(MobEffects.BLINDNESS)) {
            visibilityPercentage.accept((double)(VanillaEffectsHandler.getVisibilityMultiplier(mob.getEffect(MobEffects.BLINDNESS).getAmplifier()) * 0.5f));
        }
    }

    public static float getVisibilityMultiplier(int amplifier) {
        return Mth.clamp((float)(1.0f / (float)Math.sqrt(Math.max(1.0f, (float)amplifier + 1.0f))), (float)0.0f, (float)1.0f);
    }
}

