/*
 * Decompiled with CFR 0.152.
 */
package fuzs.convenienteffects.mixin.client;

import fuzs.convenienteffects.ConvenientEffects;
import fuzs.convenienteffects.config.ClientConfig;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
abstract class GameRendererMixin {
    GameRendererMixin() {
    }

    @Inject(method={"getNightVisionScale"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getNightVisionScale(LivingEntity livingEntity, float partialTick, CallbackInfoReturnable<Float> callback) {
        if (!((ClientConfig)ConvenientEffects.CONFIG.get(ClientConfig.class)).noNightVisionFlashing) {
            return;
        }
        MobEffectInstance mobEffect = livingEntity.getEffect(MobEffects.NIGHT_VISION);
        if (mobEffect != null && !mobEffect.isInfiniteDuration()) {
            float fadeTime = (float)((ClientConfig)ConvenientEffects.CONFIG.get(ClientConfig.class)).effectFadeTime * 20.0f;
            float nightVisionScale = Mth.clamp((float)(((float)mobEffect.getDuration() - partialTick) / fadeTime), (float)0.0f, (float)1.0f);
            callback.setReturnValue((Object)Float.valueOf(nightVisionScale));
        }
    }
}

