/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.api;

import fr.traqueur.commands.api.arguments.Argument;
import fr.traqueur.commands.api.arguments.ArgumentConverter;
import fr.traqueur.commands.api.arguments.Arguments;
import fr.traqueur.commands.api.arguments.TabCompleter;
import fr.traqueur.commands.api.exceptions.ArgumentIncorrectException;
import fr.traqueur.commands.api.exceptions.TypeArgumentNotExistException;
import fr.traqueur.commands.api.logging.Logger;
import fr.traqueur.commands.api.logging.MessageHandler;
import fr.traqueur.commands.api.models.Command;
import fr.traqueur.commands.api.models.CommandInvoker;
import fr.traqueur.commands.api.models.CommandPlatform;
import fr.traqueur.commands.api.models.collections.CommandTree;
import fr.traqueur.commands.api.updater.Updater;
import fr.traqueur.commands.impl.arguments.BooleanArgument;
import fr.traqueur.commands.impl.arguments.DoubleArgument;
import fr.traqueur.commands.impl.arguments.IntegerArgument;
import fr.traqueur.commands.impl.arguments.LongArgument;
import fr.traqueur.commands.impl.logging.InternalLogger;
import fr.traqueur.commands.impl.logging.InternalMessageHandler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class CommandManager<T, S> {
    public static final String TYPE_PARSER = ":";
    private static final String INFINITE = "infinite";
    private final CommandPlatform<T, S> platform;
    private final CommandTree<T, S> commands;
    private final Map<String, Map.Entry<Class<?>, ArgumentConverter<?>>> typeConverters;
    private final Map<String, Map<Integer, TabCompleter<S>>> completers;
    private final CommandInvoker<T, S> invoker;
    private MessageHandler messageHandler;
    private Logger logger;
    private boolean debug;

    public CommandManager(CommandPlatform<T, S> platform) {
        Updater.checkUpdates();
        this.platform = platform;
        this.platform.injectManager(this);
        this.messageHandler = new InternalMessageHandler();
        this.logger = new InternalLogger(platform.getLogger());
        this.debug = false;
        this.commands = new CommandTree();
        this.typeConverters = new HashMap();
        this.completers = new HashMap<String, Map<Integer, TabCompleter<S>>>();
        this.invoker = new CommandInvoker(this);
        this.registerInternalConverters();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void registerCommand(Command<T, S> command2) {
        try {
            for (String alias : command2.getAliases()) {
                this.addCommand(command2, alias);
                this.registerSubCommands(alias, command2.getSubcommands());
            }
        }
        catch (TypeArgumentNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterCommand(String label) {
        this.unregisterCommand(label, true);
    }

    public void unregisterCommand(String label, boolean subcommands) {
        String[] rawArgs = label.split("\\.");
        Optional commandOptional = this.commands.findNode(rawArgs).flatMap(result2 -> result2.node.getCommand());
        if (!commandOptional.isPresent()) {
            throw new IllegalArgumentException("Command with label '" + label + "' does not exist.");
        }
        this.unregisterCommand((Command)commandOptional.get(), subcommands);
    }

    public void unregisterCommand(Command<T, S> command2) {
        this.unregisterCommand(command2, true);
    }

    public void unregisterCommand(Command<T, S> command2, boolean subcommands) {
        ArrayList<String> aliases = new ArrayList<String>(command2.getAliases());
        aliases.add(command2.getName());
        for (String alias : aliases) {
            this.removeCommand(alias, subcommands);
            if (!subcommands) continue;
            this.unregisterSubCommands(alias, command2.getSubcommands());
        }
    }

    public <C> void registerConverter(Class<C> typeClass, ArgumentConverter<C> converter) {
        this.typeConverters.put(typeClass.getSimpleName().toLowerCase(), new AbstractMap.SimpleEntry<Class<C>, ArgumentConverter<C>>(typeClass, converter));
    }

    @Deprecated
    public <C> void registerConverter(Class<C> typeClass, String type, ArgumentConverter<C> converter) {
        this.typeConverters.put(type, new AbstractMap.SimpleEntry<Class<C>, ArgumentConverter<C>>(typeClass, converter));
    }

    public Arguments parse(Command<T, S> command2, String[] args) throws TypeArgumentNotExistException, ArgumentIncorrectException {
        String input;
        String input2;
        Arguments arguments = new Arguments(this.logger);
        List<Argument<S>> templates = command2.getArgs();
        for (int i = 0; i < templates.size() && !this.applyParsing(args, arguments, templates, i, input2 = args[i]); ++i) {
        }
        List<Argument<S>> optArgs = command2.getOptinalArgs();
        if (optArgs.isEmpty()) {
            return arguments;
        }
        for (int i = 0; !(i >= optArgs.size() || args.length > templates.size() + i && this.applyParsing(args, arguments, optArgs, i, input = args[templates.size() + i])); ++i) {
        }
        return arguments;
    }

    public CommandTree<T, S> getCommands() {
        return this.commands;
    }

    public Map<String, Map<Integer, TabCompleter<S>>> getCompleters() {
        return this.completers;
    }

    public CommandPlatform<T, S> getPlatform() {
        return this.platform;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void registerSubCommands(String parentLabel, List<Command<T, S>> subcommands) throws TypeArgumentNotExistException {
        if (subcommands == null || subcommands.isEmpty()) {
            return;
        }
        for (Command<T, S> subcommand : subcommands) {
            ArrayList<String> aliasesSub = new ArrayList<String>(subcommand.getAliases());
            aliasesSub.add(subcommand.getName());
            for (String aliasSub : aliasesSub) {
                this.addCommand(subcommand, parentLabel + "." + aliasSub);
                this.registerSubCommands(parentLabel + "." + aliasSub, subcommand.getSubcommands());
            }
        }
    }

    private void unregisterSubCommands(String parentLabel, List<Command<T, S>> subcommandsList) {
        if (subcommandsList == null || subcommandsList.isEmpty()) {
            return;
        }
        for (Command<T, S> subcommand : subcommandsList) {
            ArrayList<String> aliasesSub = new ArrayList<String>(subcommand.getAliases());
            aliasesSub.add(subcommand.getName());
            for (String aliasSub : aliasesSub) {
                this.removeCommand(parentLabel + "." + aliasSub, true);
                this.unregisterSubCommands(parentLabel + "." + aliasSub, subcommand.getSubcommands());
            }
        }
    }

    private void removeCommand(String label, boolean subcommand) {
        this.platform.removeCommand(label, subcommand);
        this.commands.removeCommand(label, subcommand);
        this.completers.remove(label);
    }

    private void addCommand(Command<T, S> command2, String label) throws TypeArgumentNotExistException {
        if (this.isDebug()) {
            this.logger.info("Register command " + label);
        }
        List<Argument<S>> args = command2.getArgs();
        List<Argument<S>> optArgs = command2.getOptinalArgs();
        String[] labelParts = label.split("\\.");
        int labelSize = labelParts.length;
        if (!this.checkTypeForArgs(args) || !this.checkTypeForArgs(optArgs)) {
            throw new TypeArgumentNotExistException();
        }
        command2.setManager(this);
        this.platform.addCommand(command2, label);
        this.commands.addCommand(label, command2);
        this.addCompletionsForLabel(labelParts);
        this.addCompletionForArgs(label, labelSize, args);
        this.addCompletionForArgs(label, labelSize + args.size(), optArgs);
    }

    private void addCompletionsForLabel(String[] labelParts) {
        StringBuilder currentLabel = new StringBuilder();
        for (int i = 0; i < labelParts.length - 1; ++i) {
            if (i > 0) {
                currentLabel.append(".");
            }
            currentLabel.append(labelParts[i]);
            String completionPart = labelParts[i + 1];
            this.addCompletion(currentLabel.toString(), i + 1, (s, args) -> new ArrayList<String>(Collections.singleton(completionPart)));
        }
    }

    private void addCompletionForArgs(String label, int commandSize, List<Argument<S>> args) {
        for (int i = 0; i < args.size(); ++i) {
            Argument<S> arg = args.get(i);
            String[] parts = arg.arg().split(TYPE_PARSER);
            String type = parts[1].trim();
            ArgumentConverter<?> converter = this.typeConverters.get(type).getValue();
            TabCompleter<S> argConverter = arg.tabConverter();
            if (argConverter != null) {
                this.addCompletion(label, commandSize + i, argConverter);
                continue;
            }
            if (converter instanceof TabCompleter) {
                TabCompleter tabCompleter = (TabCompleter)((Object)converter);
                this.addCompletion(label, commandSize + i, tabCompleter);
                continue;
            }
            this.addCompletion(label, commandSize + i, (s, argsInner) -> new ArrayList());
        }
    }

    private void addCompletion(String label, int commandSize, TabCompleter<S> converter) {
        Map mapInner = this.completers.getOrDefault(label, new HashMap());
        TabCompleter existing = (TabCompleter)mapInner.get(commandSize);
        TabCompleter<Object> combined = existing != null ? (s, args) -> {
            ArrayList<String> completions = new ArrayList<String>(existing.onCompletion(s, args));
            completions.addAll(converter.onCompletion(s, args));
            return completions;
        } : converter;
        mapInner.put(commandSize, combined);
        this.completers.put(label, mapInner);
    }

    private boolean checkTypeForArgs(List<Argument<S>> args) throws TypeArgumentNotExistException {
        for (String arg : args.stream().map(Argument::arg).collect(Collectors.toList())) {
            String[] parts = arg.split(TYPE_PARSER);
            if (parts.length != 2) {
                throw new TypeArgumentNotExistException();
            }
            String type = parts[1].trim();
            if (this.typeExist(type)) continue;
            return false;
        }
        return true;
    }

    private boolean typeExist(String type) {
        return this.typeConverters.containsKey(type);
    }

    private boolean applyParsing(String[] args, Arguments arguments, List<Argument<S>> templates, int argIndex, String input) throws TypeArgumentNotExistException, ArgumentIncorrectException {
        String template = templates.get(argIndex).arg();
        String[] parts = template.split(TYPE_PARSER);
        if (parts.length != 2) {
            throw new TypeArgumentNotExistException();
        }
        String key = parts[0].trim();
        String type = parts[1].trim();
        if (type.equals(INFINITE)) {
            StringBuilder builder = new StringBuilder();
            for (int i = argIndex; i < args.length; ++i) {
                builder.append(args[i]);
                if (i >= args.length - 1) continue;
                builder.append(" ");
            }
            arguments.add(key, String.class, builder.toString());
            return true;
        }
        if (this.typeConverters.containsKey(type)) {
            Class<?> typeClass = this.typeConverters.get(type).getKey();
            ArgumentConverter<?> converter = this.typeConverters.get(type).getValue();
            Object obj = converter.apply(input);
            if (obj == null) {
                throw new ArgumentIncorrectException(input);
            }
            arguments.add(key, typeClass, obj);
        }
        return false;
    }

    public CommandInvoker<T, S> getInvoker() {
        return this.invoker;
    }

    private void registerInternalConverters() {
        this.registerConverter(String.class, s -> s);
        this.registerConverter(Boolean.class, new BooleanArgument());
        this.registerConverter(Integer.class, new IntegerArgument());
        this.registerConverter(Double.class, new DoubleArgument());
        this.registerConverter(Long.class, new LongArgument());
        this.registerConverter(String.class, INFINITE, s -> s);
    }
}

