/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.spigot;

import fr.traqueur.commands.api.CommandManager;
import fr.traqueur.commands.api.models.Command;
import fr.traqueur.commands.api.models.CommandPlatform;
import fr.traqueur.commands.spigot.SpigotExecutor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPlatform<T extends JavaPlugin>
implements CommandPlatform<T, CommandSender> {
    private final T plugin;
    private CommandMap commandMap;
    private CommandManager<T, CommandSender> commandManager;
    private SpigotExecutor<T> spigotExecutor;
    private Constructor<? extends PluginCommand> pluginConstructor;

    public SpigotPlatform(T plugin) {
        this.plugin = plugin;
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            this.commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            this.pluginConstructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            this.pluginConstructor.setAccessible(true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            this.getLogger().severe("Unable to get the command map.");
            plugin.getServer().getPluginManager().disablePlugin(plugin);
        }
    }

    @Override
    public T getPlugin() {
        return this.plugin;
    }

    @Override
    public void injectManager(CommandManager<T, CommandSender> commandManager) {
        this.commandManager = commandManager;
        this.spigotExecutor = new SpigotExecutor<T>(this.plugin, this.commandManager);
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    public boolean hasPermission(CommandSender sender, String permission) {
        if (sender != null) {
            return sender.hasPermission(permission);
        }
        return false;
    }

    @Override
    public boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    @Override
    public void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    @Override
    public void addCommand(Command<T, CommandSender> command2, String label) {
        boolean alreadyInMap;
        String[] labelParts = label.split("\\.");
        String cmdLabel = labelParts[0].toLowerCase();
        boolean alreadyInTree = this.commandManager.getCommands().getRoot().getChildren().containsKey(cmdLabel);
        boolean bl = alreadyInMap = this.commandMap.getCommand(cmdLabel) != null;
        if (!alreadyInTree && !alreadyInMap) {
            try {
                PluginCommand cmd = this.pluginConstructor.newInstance(cmdLabel, this.plugin);
                cmd.setExecutor(this.spigotExecutor);
                cmd.setTabCompleter(this.spigotExecutor);
                cmd.setAliases(command2.getAliases().stream().map(a -> a.split("\\.")[0]).filter(a -> !a.equalsIgnoreCase(cmdLabel)).distinct().collect(Collectors.toList()));
                if (!this.commandMap.register(cmdLabel, this.plugin.getName(), (org.bukkit.command.Command)cmd)) {
                    this.getLogger().severe("Unable to add command " + cmdLabel);
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!command2.getDescription().equalsIgnoreCase("") && labelParts.length == 1) {
            Objects.requireNonNull(this.commandMap.getCommand(cmdLabel)).setDescription(command2.getDescription());
        }
        if (!command2.getUsage().equalsIgnoreCase("") && labelParts.length == 1) {
            Objects.requireNonNull(this.commandMap.getCommand(cmdLabel)).setUsage(command2.getUsage());
        }
    }

    @Override
    public void removeCommand(String label, boolean subcommand) {
        if (subcommand && this.commandMap.getCommand(label) != null) {
            Objects.requireNonNull(this.commandMap.getCommand(label)).unregister(this.commandMap);
        }
    }
}

