/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux;

import io.github.Jadiefication.redstoneflux.api.EnergyAPI;
import io.github.Jadiefication.redstoneflux.api.EnergyManager;
import io.github.Jadiefication.redstoneflux.api.Manager;
import io.github.Jadiefication.redstoneflux.api.components.BaseComponent;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import io.github.Jadiefication.redstoneflux.api.mechanics.InteractableMechanic;
import io.github.Jadiefication.redstoneflux.lib.folialib.impl.PlatformScheduler;
import io.github.Jadiefication.redstoneflux.lib.folialib.wrapper.task.WrappedTask;
import java.util.NoSuchElementException;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/Jadiefication/redstoneflux/EnergyListener;", "Lorg/bukkit/event/Listener;", "api", "Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "<init>", "(Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;)V", "energyManager", "Lio/github/Jadiefication/redstoneflux/api/EnergyManager;", "onChunkLoad", "", "event", "Lorg/bukkit/event/world/ChunkLoadEvent;", "onEnergyComponentPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onEnergyComponentBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "onInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "RedstoneFlux"})
@SourceDebugExtension(value={"SMAP\nEnergyListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyListener.kt\nio/github/Jadiefication/redstoneflux/EnergyListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n230#2,2:120\n*S KotlinDebug\n*F\n+ 1 EnergyListener.kt\nio/github/Jadiefication/redstoneflux/EnergyListener\n*L\n29#1:120,2\n*E\n"})
public final class EnergyListener
implements Listener {
    @NotNull
    private final EnergyAPI api;
    @NotNull
    private final EnergyManager energyManager;

    /*
     * WARNING - void declaration
     */
    public EnergyListener(@NotNull EnergyAPI api) {
        Object element$iv2;
        block1: {
            void $this$first$iv;
            Intrinsics.checkNotNullParameter(api, "api");
            this.api = api;
            Iterable iterable = this.api.getManagers();
            EnergyListener energyListener = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Manager it = (Manager)element$iv2;
                boolean bl = false;
                if (!(it instanceof EnergyManager)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.EnergyManager");
        energyListener.energyManager = (EnergyManager)t;
    }

    @EventHandler
    public final void onChunkLoad(@NotNull ChunkLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Chunk chunk = event.getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        this.energyManager.loadNetworks(chunk);
    }

    @EventHandler
    public final void onEnergyComponentPlace(@NotNull BlockPlaceEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter(event, "event");
            ItemStack itemStack = event.getItemInHand();
            Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInHand(...)");
            ItemStack item = itemStack;
            if (!this.energyManager.isComponent(item)) {
                return;
            }
            Location location = event.getBlockPlaced().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Location location2 = location;
            PlatformScheduler platformScheduler = this.api.getScheduler();
            if (platformScheduler == null) break block1;
            platformScheduler.runAtLocation(location2, arg_0 -> EnergyListener.onEnergyComponentPlace$lambda$1(this, item, location2, arg_0));
        }
    }

    @EventHandler
    public final void onEnergyComponentBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        if (!this.energyManager.isBlockComponent(location2)) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.energyManager.breakComponent(player, location2);
    }

    @EventHandler
    public final void onInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Optional optComponent = this.energyManager.getComponentFromBlock(location2);
        if (optComponent.isEmpty()) {
            return;
        }
        Object c = optComponent.get();
        Intrinsics.checkNotNullExpressionValue(c, "get(...)");
        EnergyComponent component = (EnergyComponent)c;
        if (!(component.getMechanic() instanceof InteractableMechanic)) {
            return;
        }
        Object t = component.getMechanic();
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.InteractableMechanic");
        InteractableMechanic interactableMechanic = (InteractableMechanic)t;
        switch (WhenMappings.$EnumSwitchMapping$0[event.getAction().ordinal()]) {
            case 1: {
                interactableMechanic.onRightClick(event);
                break;
            }
            case 2: {
                interactableMechanic.onLeftClick(event);
                break;
            }
            case 3: {
                interactableMechanic.onPhysicalInteraction(event);
            }
        }
    }

    private static final void onEnergyComponentPlace$lambda$1(EnergyListener this$0, ItemStack $item, Location $location, WrappedTask t) {
        EnergyComponent component = (EnergyComponent)this$0.energyManager.createComponent($item);
        try {
            this$0.energyManager.placeComponent((BaseComponent)component, $location);
        }
        catch (SameEnergyTypeException sameEnergyTypeException) {
            // empty catch block
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Action.values().length];
            try {
                nArray[Action.RIGHT_CLICK_BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.LEFT_CLICK_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.PHYSICAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

