/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux.api.components;

import com.google.gson.Gson;
import io.github.Jadiefication.redstoneflux.api.EnergyAPI;
import io.github.Jadiefication.redstoneflux.api.Manager;
import io.github.Jadiefication.redstoneflux.api.components.BaseComponent;
import io.github.Jadiefication.redstoneflux.api.components.EnergyNetwork;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u0016\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0016J\u000e\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0016J\u0014\u0010*\u001a\u00020#2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u0010.\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010/\u001a\u00020#J\u0006\u00100\u001a\u00020#J\u0018\u00101\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000fH\u0002R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u001f0\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010,\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u00103\u001a\u0004\u0018\u00018\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u00066"}, d2={"Lio/github/Jadiefication/redstoneflux/api/components/BaseNetwork;", "C", "Lio/github/Jadiefication/redstoneflux/api/components/BaseComponent;", "", "<init>", "()V", "api", "Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "getApi$FluxAPI", "()Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "chunk", "Lorg/bukkit/Chunk;", "getChunk", "()Lorg/bukkit/Chunk;", "setChunk", "(Lorg/bukkit/Chunk;)V", "components", "", "Lorg/bukkit/Location;", "getComponents", "()Ljava/util/Map;", "networkKey", "Lorg/bukkit/NamespacedKey;", "getNetworkKey", "()Lorg/bukkit/NamespacedKey;", "manager", "Lkotlin/reflect/KClass;", "Lio/github/Jadiefication/redstoneflux/api/Manager;", "getManager", "()Lkotlin/reflect/KClass;", "addComponent", "", "component", "location", "(Lio/github/Jadiefication/redstoneflux/api/components/BaseComponent;Lorg/bukkit/Location;)V", "removeComponent", "contains", "", "mergeWith", "network", "isEmpty", "()Z", "isInChunk", "save", "delete", "isSameChunk", "chunk1", "root", "getRoot", "()Lio/github/Jadiefication/redstoneflux/api/components/BaseComponent;", "FluxAPI"})
@SourceDebugExtension(value={"SMAP\nBaseNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseNetwork.kt\nio/github/Jadiefication/redstoneflux/api/components/BaseNetwork\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n230#2,2:197\n230#2,2:199\n230#2,2:201\n*S KotlinDebug\n*F\n+ 1 BaseNetwork.kt\nio/github/Jadiefication/redstoneflux/api/components/BaseNetwork\n*L\n123#1:197,2\n162#1:199,2\n173#1:201,2\n*E\n"})
public abstract class BaseNetwork<C extends BaseComponent<C>> {
    public Chunk chunk;
    @NotNull
    private final Map<Location, C> components = new ConcurrentHashMap();

    @NotNull
    public abstract EnergyAPI getApi$FluxAPI();

    @Nullable
    public abstract UUID getId();

    @NotNull
    public final Chunk getChunk() {
        Chunk chunk = this.chunk;
        if (chunk != null) {
            return chunk;
        }
        Intrinsics.throwUninitializedPropertyAccessException("chunk");
        return null;
    }

    public final void setChunk(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "<set-?>");
        this.chunk = chunk;
    }

    @NotNull
    public final Map<Location, C> getComponents() {
        return this.components;
    }

    @NotNull
    public abstract NamespacedKey getNetworkKey();

    @NotNull
    public abstract KClass<? extends Manager<C>> getManager();

    public final void addComponent(@NotNull C component, @NotNull Location location) throws SameEnergyTypeException {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(location, "location");
        for (Map.Entry entry : this.components.entrySet().stream().filter(arg_0 -> BaseNetwork.addComponent$lambda$1(arg_0 -> BaseNetwork.addComponent$lambda$0(location, arg_0), arg_0)).toList()) {
            ((BaseComponent)entry.getValue()).connect(component);
        }
        if (this.chunk == null) {
            Chunk chunk = location.getChunk();
            Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
            this.setChunk(chunk);
        }
        this.components.put(location, component);
    }

    public final void removeComponent(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.components.entrySet().stream().filter(arg_0 -> BaseNetwork.removeComponent$lambda$3(arg_0 -> BaseNetwork.removeComponent$lambda$2(location, arg_0), arg_0)).forEach(arg_0 -> BaseNetwork.removeComponent$lambda$5(arg_0 -> BaseNetwork.removeComponent$lambda$4(this, location, arg_0), arg_0));
        this.components.remove(location);
    }

    public final boolean contains(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.components.containsKey(location);
    }

    public final void mergeWith(@NotNull BaseNetwork<C> network2) {
        Intrinsics.checkNotNullParameter(network2, "network");
        this.components.putAll(network2.components);
    }

    public final boolean isEmpty() {
        return this.components.isEmpty();
    }

    public final boolean isInChunk(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        return this.components.keySet().stream().anyMatch(arg_0 -> BaseNetwork.isInChunk$lambda$7(arg_0 -> BaseNetwork.isInChunk$lambda$6(this, chunk, arg_0), arg_0));
    }

    public final void save() {
        Object element$iv2;
        block3: {
            Iterable $this$first$iv = this.getApi$FluxAPI().getManagers();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Manager it = (Manager)element$iv2;
                boolean bl = false;
                if (!this.getManager().isInstance(it)) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Manager manager = (Manager)element$iv2;
        PersistentDataContainer container = null;
        try {
            PersistentDataContainer persistentDataContainer = this.getChunk().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            container = persistentDataContainer;
        }
        catch (Exception exception) {
            this.delete();
            return;
        }
        Gson gson = manager.getGson();
        String json = gson.toJson((Object)this, (Type)((Object)EnergyNetwork.class));
        List networks = (List)container.getOrDefault(this.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), new ArrayList());
        networks = new ArrayList(networks);
        ((ArrayList)networks).removeIf(arg_0 -> BaseNetwork.save$lambda$10(arg_0 -> BaseNetwork.save$lambda$9(gson, this, arg_0), arg_0));
        ((ArrayList)networks).add(json);
        container.set(this.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)networks);
    }

    public final void delete() {
        PersistentDataContainer container = null;
        try {
            PersistentDataContainer persistentDataContainer = this.getChunk().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            container = persistentDataContainer;
        }
        catch (Exception exception) {
            Object element$iv2;
            block3: {
                Iterable $this$first$iv = this.getApi$FluxAPI().getManagers();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Manager it = (Manager)element$iv2;
                    boolean bl = false;
                    if (!this.getManager().isInstance(it)) continue;
                    break block3;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            TypeIntrinsics.asMutableCollection(((Manager)element$iv2).getNetworks()).remove(this);
            return;
        }
        Object object = container.getOrDefault(this.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)new ArrayList());
        Intrinsics.checkNotNullExpressionValue(object, "getOrDefault(...)");
        List networks = (List)object;
        networks = new ArrayList(networks);
        ((ArrayList)networks).removeIf(arg_0 -> BaseNetwork.delete$lambda$14(arg_0 -> BaseNetwork.delete$lambda$13(this, arg_0), arg_0));
        container.set(this.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)networks);
    }

    private final boolean isSameChunk(Chunk chunk, Chunk chunk1) {
        return chunk.getX() == chunk1.getX() && chunk.getZ() == chunk1.getZ() && Intrinsics.areEqual(chunk.getWorld().getName(), chunk1.getWorld().getName());
    }

    private final C getRoot() {
        return (C)((BaseComponent)CollectionsKt.firstOrNull((Iterable)this.components.values()));
    }

    private static final boolean addComponent$lambda$0(Location $location, Map.Entry entry) {
        return ((Location)entry.getKey()).distance($location) == 1.0;
    }

    private static final boolean addComponent$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeComponent$lambda$2(Location $location, Map.Entry entry) {
        return ((Location)entry.getKey()).distance($location) == 1.0;
    }

    private static final boolean removeComponent$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit removeComponent$lambda$4(BaseNetwork this$0, Location $location, Map.Entry entry) {
        BaseComponent baseComponent = (BaseComponent)entry.getValue();
        Object c = this$0.components.get($location);
        Intrinsics.checkNotNull(c);
        baseComponent.disconnect((BaseComponent)c);
        return Unit.INSTANCE;
    }

    private static final void removeComponent$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean isInChunk$lambda$6(BaseNetwork this$0, Chunk $chunk, Location location) {
        Location location2 = location;
        Intrinsics.checkNotNull(location2);
        Chunk chunk = location2.getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        return this$0.isSameChunk($chunk, chunk);
    }

    private static final boolean isInChunk$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean save$lambda$9(Gson $gson, BaseNetwork this$0, String network2) {
        EnergyNetwork energyNetwork;
        EnergyNetwork energyNetwork2 = energyNetwork = (EnergyNetwork)$gson.fromJson(network2, EnergyNetwork.class);
        return Intrinsics.areEqual(energyNetwork2 != null ? energyNetwork2.getId() : null, this$0.getId());
    }

    private static final boolean save$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean delete$lambda$13(BaseNetwork this$0, String json) {
        EnergyNetwork network2;
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this$0.getApi$FluxAPI().getManagers();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Manager it = (Manager)element$iv2;
                boolean bl = false;
                if (!this$0.getManager().isInstance(it)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        EnergyNetwork energyNetwork = network2 = (EnergyNetwork)((Manager)element$iv2).getGson().fromJson(json, EnergyNetwork.class);
        return Intrinsics.areEqual(energyNetwork != null ? energyNetwork.getId() : null, this$0.getId());
    }

    private static final boolean delete$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

