/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux.api.components;

import io.github.Jadiefication.redstoneflux.api.components.BaseComponent;
import io.github.Jadiefication.redstoneflux.api.event.EnergyComponentConnectEvent;
import io.github.Jadiefication.redstoneflux.api.event.EnergyComponentDisconnectEvent;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyMechanic;
import io.github.Jadiefication.redstoneflux.api.types.EnergyType;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0010\u00a2\u0006\u0002\b\u0019J\u0019\u0010\u001a\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0010\u00a2\u0006\u0002\b\u001bJ\u0019\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0010\u00a2\u0006\u0002\b\u001eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0013X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;", "T", "Lio/github/Jadiefication/redstoneflux/api/mechanics/EnergyMechanic;", "Lio/github/Jadiefication/redstoneflux/api/components/BaseComponent;", "energyType", "Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;", "mechanic", "<init>", "(Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;Lio/github/Jadiefication/redstoneflux/api/mechanics/EnergyMechanic;)V", "getEnergyType", "()Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;", "setEnergyType", "(Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;)V", "getMechanic", "()Lio/github/Jadiefication/redstoneflux/api/mechanics/EnergyMechanic;", "setMechanic", "(Lio/github/Jadiefication/redstoneflux/api/mechanics/EnergyMechanic;)V", "Lio/github/Jadiefication/redstoneflux/api/mechanics/EnergyMechanic;", "connectedComponents", "", "getConnectedComponents$FluxAPI", "()Ljava/util/Set;", "connectionFunction", "", "component", "connectionFunction$FluxAPI", "disconnectionFunction", "disconnectionFunction$FluxAPI", "checker", "", "checker$FluxAPI", "FluxAPI"})
public class EnergyComponent<T extends EnergyMechanic>
extends BaseComponent<EnergyComponent<?>> {
    @NotNull
    private EnergyType energyType;
    @NotNull
    private T mechanic;
    @NotNull
    private final Set<EnergyComponent<?>> connectedComponents;

    public EnergyComponent(@NotNull EnergyType energyType, @NotNull T mechanic) {
        Intrinsics.checkNotNullParameter(energyType, "energyType");
        Intrinsics.checkNotNullParameter(mechanic, "mechanic");
        this.energyType = energyType;
        this.mechanic = mechanic;
        this.connectedComponents = new HashSet();
    }

    @NotNull
    public final EnergyType getEnergyType() {
        return this.energyType;
    }

    public final void setEnergyType(@NotNull EnergyType energyType) {
        Intrinsics.checkNotNullParameter(energyType, "<set-?>");
        this.energyType = energyType;
    }

    @NotNull
    public final T getMechanic() {
        return this.mechanic;
    }

    public final void setMechanic(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, "<set-?>");
        this.mechanic = t;
    }

    @Override
    @NotNull
    public Set<EnergyComponent<?>> getConnectedComponents$FluxAPI() {
        return this.connectedComponents;
    }

    @Override
    public void connectionFunction$FluxAPI(@NotNull EnergyComponent<?> component) {
        Intrinsics.checkNotNullParameter(component, "component");
        EnergyComponentConnectEvent componentConnectEvent = new EnergyComponentConnectEvent(component, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)componentConnectEvent);
    }

    @Override
    public void disconnectionFunction$FluxAPI(@NotNull EnergyComponent<?> component) {
        Intrinsics.checkNotNullParameter(component, "component");
        EnergyComponentDisconnectEvent componentDisconnectEvent = new EnergyComponentDisconnectEvent(component, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)componentDisconnectEvent);
    }

    @Override
    public boolean checker$FluxAPI(@NotNull EnergyComponent<?> component) {
        Intrinsics.checkNotNullParameter(component, "component");
        if (this.energyType != component.energyType) {
            throw new SameEnergyTypeException();
        }
        return true;
    }
}

