/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux.api.components;

import com.google.gson.Gson;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.components.ItemComponentBuilder;
import io.github.Jadiefication.redstoneflux.api.items.ItemsFactory;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyMechanic;
import io.github.Jadiefication.redstoneflux.api.persistents.EnergyTypePersistentDataType;
import io.github.Jadiefication.redstoneflux.api.types.EnergyType;
import io.github.Jadiefication.redstoneflux.api.types.MechanicType;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponentBuilder;", "Lio/github/Jadiefication/redstoneflux/api/components/ItemComponentBuilder;", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;", "gson", "Lcom/google/gson/Gson;", "energyTypeKey", "Lorg/bukkit/NamespacedKey;", "mechanicClassKey", "mechanicKey", "<init>", "(Lcom/google/gson/Gson;Lorg/bukkit/NamespacedKey;Lorg/bukkit/NamespacedKey;Lorg/bukkit/NamespacedKey;)V", "getGson", "()Lcom/google/gson/Gson;", "getEnergyTypeKey", "()Lorg/bukkit/NamespacedKey;", "getMechanicClassKey", "getMechanicKey", "buildItem", "Lorg/bukkit/inventory/ItemStack;", "component", "FluxAPI"})
@SourceDebugExtension(value={"SMAP\nEnergyComponentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyComponentBuilder.kt\nio/github/Jadiefication/redstoneflux/api/components/EnergyComponentBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class EnergyComponentBuilder
implements ItemComponentBuilder<EnergyComponent<?>> {
    @NotNull
    private final Gson gson;
    @NotNull
    private final NamespacedKey energyTypeKey;
    @NotNull
    private final NamespacedKey mechanicClassKey;
    @NotNull
    private final NamespacedKey mechanicKey;

    public EnergyComponentBuilder(@NotNull Gson gson, @NotNull NamespacedKey energyTypeKey, @NotNull NamespacedKey mechanicClassKey, @NotNull NamespacedKey mechanicKey) {
        Intrinsics.checkNotNullParameter(gson, "gson");
        Intrinsics.checkNotNullParameter(energyTypeKey, "energyTypeKey");
        Intrinsics.checkNotNullParameter(mechanicClassKey, "mechanicClassKey");
        Intrinsics.checkNotNullParameter(mechanicKey, "mechanicKey");
        this.gson = gson;
        this.energyTypeKey = energyTypeKey;
        this.mechanicClassKey = mechanicClassKey;
        this.mechanicKey = mechanicKey;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @NotNull
    public final NamespacedKey getEnergyTypeKey() {
        return this.energyTypeKey;
    }

    @NotNull
    public final NamespacedKey getMechanicClassKey() {
        return this.mechanicClassKey;
    }

    @NotNull
    public final NamespacedKey getMechanicKey() {
        return this.mechanicKey;
    }

    @Override
    @NotNull
    public ItemStack buildItem(@NotNull EnergyComponent<?> component) {
        Intrinsics.checkNotNullParameter(component, "component");
        Object mechanic = component.getMechanic();
        MechanicType mechanicType = MechanicType.Companion.fromComponent(component);
        EnergyType type = component.getEnergyType();
        if (!mechanic.getClass().isAssignableFrom(mechanicType.getClazz())) {
            boolean $i$a$-require-EnergyComponentBuilder$buildItem$22 = false;
            String $i$a$-require-EnergyComponentBuilder$buildItem$22 = "Mechanic type " + mechanicType.getClazz() + " is not compatible with mechanic " + mechanic.getClass();
            throw new IllegalArgumentException($i$a$-require-EnergyComponentBuilder$buildItem$22.toString());
        }
        ItemStack itemStack = ItemsFactory.INSTANCE.getItem(component).orElseThrow(() -> EnergyComponentBuilder.buildItem$lambda$1(mechanic));
        Intrinsics.checkNotNullExpressionValue(itemStack, "orElseThrow(...)");
        ItemStack item = itemStack;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            boolean $i$a$-requireNotNull-EnergyComponentBuilder$buildItem$32 = false;
            String $i$a$-requireNotNull-EnergyComponentBuilder$buildItem$32 = "ItemMeta is null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-EnergyComponentBuilder$buildItem$32.toString());
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        persistentDataContainer2.set(this.energyTypeKey, (PersistentDataType)EnergyTypePersistentDataType.Companion.getINSTANCE(), (Object)type);
        persistentDataContainer2.set(this.mechanicClassKey, PersistentDataType.STRING, (Object)mechanic.getClass().getName());
        persistentDataContainer2.set(this.mechanicKey, PersistentDataType.STRING, (Object)this.gson.toJson(mechanic, (Type)mechanic.getClass()));
        item.setItemMeta(meta);
        return item;
    }

    private static final IllegalArgumentException buildItem$lambda$1(EnergyMechanic $mechanic) {
        return new IllegalArgumentException("Item not found for mechanic " + $mechanic.getClass());
    }
}

