/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.api.models.collections;

import fr.traqueur.commands.api.models.Command;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CommandTree<T, S> {
    private final CommandNode<T, S> root = new CommandNode(null, null);

    public void addCommand(String label, Command<T, S> command2) {
        String[] parts = label.split("\\.");
        CommandNode node = this.root;
        for (String seg : parts) {
            String key = seg.toLowerCase();
            node.hadChildren = true;
            CommandNode finalNode = node;
            node = node.children.computeIfAbsent(key, k -> new CommandNode((String)k, finalNode));
        }
        node.command = command2;
    }

    public Optional<MatchResult<T, S>> findNode(String base, String[] rawArgs) {
        int i;
        if (base == null) {
            return Optional.empty();
        }
        CommandNode node = (CommandNode)((CommandNode)this.root).children.get(base.toLowerCase());
        if (node == null) {
            return Optional.empty();
        }
        for (i = 0; i < rawArgs.length; ++i) {
            String seg = rawArgs[i].toLowerCase();
            CommandNode child = (CommandNode)node.children.get(seg);
            if (child != null) {
                node = child;
                continue;
            }
            if (node.hadChildren && node.command == null) {
                return Optional.empty();
            }
            if (node.command != null) break;
            return Optional.empty();
        }
        String[] left = Arrays.copyOfRange(rawArgs, i, rawArgs.length);
        return Optional.of(new MatchResult(node, left));
    }

    public Optional<MatchResult<T, S>> findNode(String[] segments) {
        if (segments == null || segments.length == 0) {
            return Optional.empty();
        }
        CommandNode node = this.root;
        for (String seg : segments) {
            if ((node = (CommandNode)node.children.get(seg.toLowerCase())) != null) continue;
            return Optional.empty();
        }
        return Optional.of(new MatchResult<T, S>(node, new String[0]));
    }

    public void removeCommand(String label, boolean prune) {
        CommandNode target = this.findNode(label.split("\\.")).map(result2 -> result2.node).orElse(null);
        if (target == null) {
            return;
        }
        if (prune) {
            this.pruneSubtree(target);
        } else {
            this.clearOrPruneEmpty(target);
        }
    }

    private void pruneSubtree(CommandNode<T, S> node) {
        CommandNode parent = ((CommandNode)node).parent;
        if (parent != null) {
            parent.children.remove(((CommandNode)node).label);
            if (parent.children.isEmpty()) {
                parent.hadChildren = false;
            }
        }
    }

    private void clearOrPruneEmpty(CommandNode<T, S> node) {
        CommandNode parent;
        ((CommandNode)node).command = null;
        if (((CommandNode)node).children.isEmpty() && (parent = ((CommandNode)node).parent) != null) {
            parent.children.remove(((CommandNode)node).label);
            if (parent.children.isEmpty()) {
                parent.hadChildren = false;
            }
        }
    }

    public CommandNode<T, S> getRoot() {
        return this.root;
    }

    public static class CommandNode<T, S> {
        private final String label;
        private final CommandNode<T, S> parent;
        private final Map<String, CommandNode<T, S>> children = new HashMap<String, CommandNode<T, S>>();
        private Command<T, S> command;
        private boolean hadChildren = false;

        public CommandNode(String label, CommandNode<T, S> parent) {
            this.label = label;
            this.parent = parent;
        }

        public String getLabel() {
            return this.label;
        }

        public String getFullLabel() {
            if (this.parent == null || this.parent.label == null) {
                return this.label;
            }
            return this.parent.getFullLabel() + "." + this.label;
        }

        public Optional<Command<T, S>> getCommand() {
            return Optional.ofNullable(this.command);
        }

        public Map<String, CommandNode<T, S>> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }
    }

    public static class MatchResult<T, S> {
        public final CommandNode<T, S> node;
        public final String[] args;

        public MatchResult(CommandNode<T, S> node, String[] args) {
            this.node = node;
            this.args = args;
        }
    }
}

