/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.spigot;

import fr.traqueur.commands.api.CommandManager;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class SpigotExecutor<T extends Plugin>
implements CommandExecutor,
TabCompleter {
    private final T plugin;
    private final CommandManager<T, CommandSender> commandManager;

    public SpigotExecutor(T plugin, CommandManager<T, CommandSender> commandManager) {
        this.plugin = plugin;
        this.commandManager = commandManager;
    }

    private String parseLabel(String label) {
        if (label.contains(":")) {
            String[] split = label.split(":");
            label = split[1];
            if (!split[0].equalsIgnoreCase(this.plugin.getName())) {
                return null;
            }
        }
        return label.toLowerCase();
    }

    public boolean onCommand(CommandSender sender, Command command2, String label, String[] args) {
        if (!this.plugin.isEnabled()) {
            return false;
        }
        String labelLower = this.parseLabel(label);
        return this.commandManager.getInvoker().invoke(sender, labelLower, args);
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command2, String label, String[] args) {
        String labelLower = this.parseLabel(label);
        if (labelLower == null) {
            return Collections.emptyList();
        }
        return this.commandManager.getInvoker().suggest(commandSender, labelLower, args);
    }
}

