/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import fr.traqueur.commands.api.CommandManager;
import fr.traqueur.commands.api.models.Command;
import fr.traqueur.commands.api.models.CommandPlatform;
import fr.traqueur.commands.velocity.VelocityExecutor;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class VelocityPlatform<T>
implements CommandPlatform<T, CommandSource> {
    private static final LegacyComponentSerializer SERIALIZER = LegacyComponentSerializer.legacyAmpersand();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final T plugin;
    private final ProxyServer server;
    private final Logger logger;
    private CommandManager<T, CommandSource> commandManager;

    public VelocityPlatform(T plugin, ProxyServer server, Logger logger) {
        this.plugin = plugin;
        this.server = server;
        this.logger = logger;
    }

    @Override
    public T getPlugin() {
        return this.plugin;
    }

    @Override
    public void injectManager(CommandManager<T, CommandSource> commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean hasPermission(CommandSource sender, String permission) {
        return sender.hasPermission(permission);
    }

    @Override
    public boolean isPlayer(CommandSource sender) {
        return sender instanceof Player;
    }

    @Override
    public void sendMessage(CommandSource sender, String message) {
        sender.sendMessage(this.parse(message));
    }

    @Override
    public void addCommand(Command<T, CommandSource> command2, String label) {
        boolean alreadyInMap;
        String[] labelParts = label.split("\\.");
        String cmdLabel = labelParts[0].toLowerCase();
        com.velocitypowered.api.command.CommandManager velocityCmdManager = this.server.getCommandManager();
        boolean alreadyInTree = this.commandManager.getCommands().getRoot().getChildren().containsKey(cmdLabel);
        boolean bl = alreadyInMap = velocityCmdManager.getCommandMeta(cmdLabel) != null;
        if (!alreadyInTree && !alreadyInMap) {
            String[] aliases = (String[])command2.getAliases().stream().map(a -> a.split("\\.")[0].toLowerCase()).filter(a -> !a.equalsIgnoreCase(cmdLabel)).distinct().toArray(String[]::new);
            velocityCmdManager.register(velocityCmdManager.metaBuilder(cmdLabel).aliases(aliases).plugin(this.plugin).build(), new VelocityExecutor<T>(this.commandManager));
        }
    }

    @Override
    public void removeCommand(String label, boolean subcommand) {
        if (subcommand && this.server.getCommandManager().getCommandMeta(label) != null) {
            this.server.getCommandManager().unregister(this.server.getCommandManager().getCommandMeta(label));
        } else {
            this.server.getCommandManager().unregister(label);
        }
    }

    private Component parse(String message) {
        TextComponent legacy = SERIALIZER.deserialize(message);
        String asMini = (String)MINI_MESSAGE.serialize((Component)legacy);
        return MINI_MESSAGE.deserialize((Object)asMini);
    }
}

