/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux;

import io.github.Jadiefication.redstoneflux.api.EnergyAPI;
import io.github.Jadiefication.redstoneflux.api.EnergyManager;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import io.github.Jadiefication.redstoneflux.api.mechanics.InteractableMechanic;
import io.github.Jadiefication.redstoneflux.lib.folialib.impl.PlatformScheduler;
import io.github.Jadiefication.redstoneflux.lib.folialib.wrapper.task.WrappedTask;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/Jadiefication/redstoneflux/EnergyListener;", "Lorg/bukkit/event/Listener;", "api", "Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "<init>", "(Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;)V", "energyManager", "Lio/github/Jadiefication/redstoneflux/api/EnergyManager;", "onChunkLoad", "", "event", "Lorg/bukkit/event/world/ChunkLoadEvent;", "onEnergyComponentPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onEnergyComponentBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "onInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "RedstoneFlux"})
public final class EnergyListener
implements Listener {
    @NotNull
    private final EnergyAPI api;
    @NotNull
    private final EnergyManager energyManager;

    public EnergyListener(@NotNull EnergyAPI api) {
        Intrinsics.checkNotNullParameter(api, "api");
        this.api = api;
        EnergyManager energyManager = this.api.getManager();
        Intrinsics.checkNotNull(energyManager);
        this.energyManager = energyManager;
    }

    @EventHandler
    public final void onChunkLoad(@NotNull ChunkLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.energyManager.loadNetworks(event.getChunk());
    }

    @EventHandler
    public final void onEnergyComponentPlace(@NotNull BlockPlaceEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter(event, "event");
            ItemStack itemStack = event.getItemInHand();
            Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInHand(...)");
            ItemStack item = itemStack;
            if (!this.energyManager.isComponent(item)) {
                return;
            }
            Location location = event.getBlockPlaced().getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Location location2 = location;
            PlatformScheduler platformScheduler = this.api.getScheduler();
            if (platformScheduler == null) break block1;
            platformScheduler.runAtLocation(location2, arg_0 -> EnergyListener.onEnergyComponentPlace$lambda$0(this, item, location2, arg_0));
        }
    }

    @EventHandler
    public final void onEnergyComponentBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        if (!this.energyManager.isBlockComponent(location2)) {
            return;
        }
        event.setCancelled(true);
        BuildersKt.launch$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, location2, null){
            int label;
            final /* synthetic */ EnergyListener this$0;
            final /* synthetic */ BlockBreakEvent $event;
            final /* synthetic */ Location $location;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$location = $location;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = EnergyListener.access$getEnergyManager$p(this.this$0).breakComponent(this.$event.getPlayer(), this.$location, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @EventHandler
    public final void onInteract(@NotNull PlayerInteractEvent event) {
        Optional<EnergyComponent<?>> optComponent;
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Optional<EnergyComponent<?>> optional = optComponent = this.energyManager.getComponentFromBlock(location2);
        Intrinsics.checkNotNull(optional);
        if (optional.isEmpty()) {
            return;
        }
        EnergyComponent<?> energyComponent = optComponent.get();
        Intrinsics.checkNotNullExpressionValue(energyComponent, "get(...)");
        EnergyComponent<?> component = energyComponent;
        if (!(component.getMechanic() instanceof InteractableMechanic)) {
            return;
        }
        Object obj = component.getMechanic();
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.InteractableMechanic");
        InteractableMechanic interactableMechanic = (InteractableMechanic)obj;
        switch (WhenMappings.$EnumSwitchMapping$0[event.getAction().ordinal()]) {
            case 1: {
                interactableMechanic.onRightClick(event);
                break;
            }
            case 2: {
                interactableMechanic.onLeftClick(event);
                break;
            }
            case 3: {
                interactableMechanic.onPhysicalInteraction(event);
            }
        }
    }

    private static final void onEnergyComponentPlace$lambda$0(EnergyListener this$0, ItemStack $item, Location $location, WrappedTask t) {
        EnergyComponent<?> component = this$0.energyManager.createComponent($item);
        try {
            this$0.energyManager.placeComponent(component, $location);
        }
        catch (SameEnergyTypeException sameEnergyTypeException) {
            // empty catch block
        }
    }

    public static final /* synthetic */ EnergyManager access$getEnergyManager$p(EnergyListener $this) {
        return $this.energyManager;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Action.values().length];
            try {
                nArray[Action.RIGHT_CLICK_BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.LEFT_CLICK_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.PHYSICAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

