/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.Jadiefication.redstoneflux.EnergyManagerImpl;
import io.github.Jadiefication.redstoneflux.RedstoneFlux;
import io.github.Jadiefication.redstoneflux.UpdaterNetworksTask;
import io.github.Jadiefication.redstoneflux.api.EnergyAPI;
import io.github.Jadiefication.redstoneflux.api.EnergyManager;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.components.EnergyNetwork;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import io.github.Jadiefication.redstoneflux.api.items.ItemsFactory;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyMechanic;
import io.github.Jadiefication.redstoneflux.api.persistents.EnergyTypePersistentDataType;
import io.github.Jadiefication.redstoneflux.api.persistents.adapters.EnergyComponentAdapter;
import io.github.Jadiefication.redstoneflux.api.persistents.adapters.EnergyNetworkAdapter;
import io.github.Jadiefication.redstoneflux.api.persistents.adapters.EnergyTypeAdapter;
import io.github.Jadiefication.redstoneflux.api.types.EnergyType;
import io.github.Jadiefication.redstoneflux.api.types.MechanicType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.NonCancellable;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 K2\u00020\u0001:\u0001KB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010!\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001c\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010%\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001e\u0010&\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010'\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010(\u001a\u00020)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010+\u001a\u00020)2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J,\u0010,\u001a\u0004\u0018\u00010#2\b\u0010-\u001a\u0004\u0018\u00010!2\b\u0010.\u001a\u0004\u0018\u00010/2\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018H\u0016J\b\u00101\u001a\u00020\u0016H\u0016J\b\u00102\u001a\u00020\u0016H\u0016J\u0012\u00103\u001a\u00020\u00162\b\u00104\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u00105\u001a\u00020\u0016H\u0016J\u0012\u00106\u001a\u00020\u00162\b\u00107\u001a\u0004\u0018\u000108H\u0016J \u00109\u001a\u0010\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0018\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0016\u0010:\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u0010;J2\u0010<\u001a\u00020\u00162\u000e\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u001a2\u000e\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100?H\u0002J<\u0010@\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00180A0\u000f2\b\u0010B\u001a\u0004\u0018\u00010\u001a2\u000e\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u000fH\u0002JH\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HD0 \"\b\b\u0000\u0010E*\u00020F\"\b\b\u0001\u0010D*\u00020F2\u0006\u0010\"\u001a\u00020#2\u0006\u0010G\u001a\u00020H2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u0002HE\u0012\u0004\u0012\u0002HD0IH\u0002J\b\u0010J\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lio/github/Jadiefication/redstoneflux/EnergyManagerImpl;", "Lio/github/Jadiefication/redstoneflux/api/EnergyManager;", "energyLib", "Lio/github/Jadiefication/redstoneflux/RedstoneFlux;", "<init>", "(Lio/github/Jadiefication/redstoneflux/RedstoneFlux;)V", "getEnergyLib", "()Lio/github/Jadiefication/redstoneflux/RedstoneFlux;", "api", "Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "networks", "", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork;", "getNetworks", "()Ljava/util/Set;", "updaterTask", "Lkotlinx/coroutines/Job;", "placeComponent", "", "component", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;", "location", "Lorg/bukkit/Location;", "breakComponent", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;Lorg/bukkit/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEnergyType", "Ljava/util/Optional;", "Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;", "item", "Lorg/bukkit/inventory/ItemStack;", "getMechanicClass", "", "getMechanic", "Lio/github/Jadiefication/redstoneflux/api/mechanics/EnergyMechanic;", "isBlockComponent", "", "createComponent", "isComponent", "createItemComponent", "type", "mechanicType", "Lio/github/Jadiefication/redstoneflux/api/types/MechanicType;", "mechanic", "startNetworkUpdater", "stopNetworkUpdater", "deleteNetwork", "network", "saveNetworks", "loadNetworks", "chunk", "Lorg/bukkit/Chunk;", "getComponentFromBlock", "splitNetworkIfNecessary", "(Lio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "asyncNetworkSplit", "visited", "newNetworks", "", "discoverSubNetwork", "", "startBlock", "getPersistentData", "C", "P", "", "key", "Lorg/bukkit/NamespacedKey;", "Lorg/bukkit/persistence/PersistentDataType;", "createGson", "Companion", "RedstoneFlux"})
@SourceDebugExtension(value={"SMAP\nEnergyManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyManagerImpl.kt\nio/github/Jadiefication/redstoneflux/EnergyManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,467:1\n1#2:468\n1869#3,2:469\n1869#3,2:471\n*S KotlinDebug\n*F\n+ 1 EnergyManagerImpl.kt\nio/github/Jadiefication/redstoneflux/EnergyManagerImpl\n*L\n338#1:469,2\n345#1:471,2\n*E\n"})
public final class EnergyManagerImpl
implements EnergyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RedstoneFlux energyLib;
    @NotNull
    private final EnergyAPI api;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Set<EnergyNetwork> networks;
    @Nullable
    private Job updaterTask;
    @NotNull
    private static final List<BlockFace> NEIBHORS;

    public EnergyManagerImpl(@NotNull RedstoneFlux energyLib) {
        Intrinsics.checkNotNullParameter(energyLib, "energyLib");
        this.energyLib = energyLib;
        this.api = this.energyLib;
        this.gson = this.createGson();
        ItemsFactory.INSTANCE.setGson(this.getGson());
        this.networks = new HashSet();
    }

    @NotNull
    public final RedstoneFlux getEnergyLib() {
        return this.energyLib;
    }

    @Override
    @NotNull
    public Gson getGson() {
        return this.gson;
    }

    @Override
    @NotNull
    public Set<EnergyNetwork> getNetworks() {
        return this.networks;
    }

    @Override
    public void placeComponent(@Nullable EnergyComponent<?> component, @Nullable Location location) throws SameEnergyTypeException {
        List energyNetworks = new ArrayList();
        for (BlockFace neibhorFace : NEIBHORS) {
            Location location2 = location;
            Block neighbor = location2 != null && (location2 = location2.getBlock()) != null ? location2.getRelative(neibhorFace) : null;
            Optional<Object> optional = this.getNetworks().stream().filter(arg_0 -> EnergyManagerImpl.placeComponent$lambda$1(arg_0 -> EnergyManagerImpl.placeComponent$lambda$0(neighbor, arg_0), arg_0)).findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, "findFirst(...)");
            Optional<Object> networkNeighbor = optional;
            if (!networkNeighbor.isPresent() || energyNetworks.contains(networkNeighbor.get())) continue;
            Object object = networkNeighbor.get();
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            energyNetworks.add(object);
        }
        List list = energyNetworks.stream().filter(arg_0 -> EnergyManagerImpl.placeComponent$lambda$3(arg_0 -> EnergyManagerImpl.placeComponent$lambda$2(component, arg_0), arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, "collect(...)");
        energyNetworks = list;
        if (energyNetworks.isEmpty()) {
            Location location3 = location;
            Intrinsics.checkNotNull(location3);
            EnergyNetwork network = new EnergyNetwork(this.api, component, location3);
            this.getNetworks().add(network);
        } else if (energyNetworks.size() == 1) {
            EnergyNetwork energyNetwork = (EnergyNetwork)CollectionsKt.first(energyNetworks);
            EnergyComponent<?> energyComponent = component;
            Intrinsics.checkNotNull(energyComponent);
            Location location4 = location;
            Intrinsics.checkNotNull(location4);
            energyNetwork.addComponent(energyComponent, location4);
        } else {
            EnergyNetwork firstNetwork = (EnergyNetwork)CollectionsKt.first(energyNetworks);
            EnergyComponent<?> energyComponent = component;
            Intrinsics.checkNotNull(energyComponent);
            Location location5 = location;
            Intrinsics.checkNotNull(location5);
            firstNetwork.addComponent(energyComponent, location5);
            int n = energyNetworks.size();
            for (int i = 1; i < n; ++i) {
                EnergyNetwork network = (EnergyNetwork)energyNetworks.get(i);
                firstNetwork.mergeWith(network);
                this.deleteNetwork(network);
            }
        }
    }

    @Override
    @Nullable
    public Object breakComponent(@Nullable Player player, @Nullable Location location, @NotNull Continuation<? super Unit> $completion) {
        EnergyComponent<?> component;
        EnergyNetwork network = this.getNetworks().stream().filter(arg_0 -> EnergyManagerImpl.breakComponent$lambda$5(arg_0 -> EnergyManagerImpl.breakComponent$lambda$4(location, arg_0), arg_0)).findFirst().orElse(null);
        if (network == null) {
            return Unit.INSTANCE;
        }
        EnergyComponent<?> energyComponent = component = network.getComponents().get(location);
        EnergyType energyType = energyComponent != null ? energyComponent.getEnergyType() : null;
        EnergyComponent<?> energyComponent2 = component;
        Intrinsics.checkNotNull(energyComponent2);
        MechanicType mechanicType = MechanicType.Companion.fromComponent(energyComponent2);
        Location location2 = location;
        if (location2 != null && (location2 = location2.getBlock()) != null) {
            location2.setType(Material.AIR);
        }
        Player player2 = player;
        if ((player2 != null ? player2.getGameMode() : null) != GameMode.CREATIVE) {
            ItemStack result2 = this.createItemComponent(energyType, mechanicType, component);
            Player player3 = player;
            if (player3 != null && (player3 = player3.getWorld()) != null) {
                Location location3 = location;
                Intrinsics.checkNotNull(location3);
                ItemStack itemStack = result2;
                Intrinsics.checkNotNull(itemStack);
                player3.dropItemNaturally(location3, itemStack);
            }
        }
        Location location4 = location;
        Intrinsics.checkNotNull(location4);
        network.removeComponent(location4);
        if (network.isEmpty()) {
            this.deleteNetwork(network);
            return Unit.INSTANCE;
        }
        Object object = this.splitNetworkIfNecessary(network, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Optional<EnergyType> getEnergyType(@Nullable ItemStack item) {
        Optional<EnergyType> optional;
        ItemStack itemStack = item;
        Intrinsics.checkNotNull(itemStack);
        Optional<EnergyType> pdcOptional = this.getPersistentData(itemStack, this.energyLib.getEnergyTypeKey(), EnergyTypePersistentDataType.Companion.getINSTANCE());
        if (pdcOptional.isEmpty()) {
            EnergyComponent<?> energyComponent = OptionalsKt.getOrNull(ItemsFactory.INSTANCE.getComponent(item));
            Optional<EnergyType> optional2 = Optional.ofNullable(energyComponent != null ? energyComponent.getEnergyType() : null);
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            optional = pdcOptional;
        }
        return optional;
    }

    @Override
    @Nullable
    public Optional<String> getMechanicClass(@Nullable ItemStack item) {
        Optional<String> optional;
        ItemStack itemStack = item;
        Intrinsics.checkNotNull(itemStack);
        NamespacedKey namespacedKey = this.energyLib.getMechanicClassKey();
        PersistentDataType persistentDataType = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
        Optional<String> pdcOptional = this.getPersistentData(itemStack, namespacedKey, persistentDataType);
        if (pdcOptional.isEmpty()) {
            EnergyComponent<?> energyComponent = OptionalsKt.getOrNull(ItemsFactory.INSTANCE.getComponent(item));
            Optional<Object> optional2 = Optional.ofNullable(energyComponent != null && (energyComponent = energyComponent.getMechanic()) != null && (energyComponent = energyComponent.getClass()) != null ? ((Class)((Object)energyComponent)).getName() : null);
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            optional = pdcOptional;
        }
        return optional;
    }

    @Override
    @Nullable
    public Optional<? extends EnergyMechanic> getMechanic(@Nullable ItemStack item) {
        Optional<String> optional = this.getMechanicClass(item);
        String mechanicClass = optional != null ? optional.orElseThrow() : null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(mechanicClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Class " + mechanicClass + " not found!");
        }
        if (!EnergyMechanic.class.isAssignableFrom(clazz)) {
            boolean $i$a$-require-EnergyManagerImpl$getMechanic$32 = false;
            String $i$a$-require-EnergyManagerImpl$getMechanic$32 = "Class " + mechanicClass + " is not an EnergyMechanic!";
            throw new IllegalArgumentException($i$a$-require-EnergyManagerImpl$getMechanic$32.toString());
        }
        Class<EnergyMechanic> clazz2 = clazz.asSubclass(EnergyMechanic.class);
        Intrinsics.checkNotNullExpressionValue(clazz2, "asSubclass(...)");
        Class<EnergyMechanic> mechanicClazz = clazz2;
        ItemStack itemStack = item;
        Intrinsics.checkNotNull(itemStack);
        NamespacedKey namespacedKey = this.energyLib.getMechanicKey();
        PersistentDataType persistentDataType = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
        Optional opt = this.getPersistentData(itemStack, namespacedKey, persistentDataType);
        if (opt.isEmpty()) {
            return Optional.empty();
        }
        Object c = opt.get();
        Intrinsics.checkNotNullExpressionValue(c, "get(...)");
        String mechanicData = (String)c;
        return Optional.of(this.getGson().fromJson(mechanicData, mechanicClazz));
    }

    @Override
    public boolean isBlockComponent(@Nullable Location location) {
        return this.getNetworks().stream().anyMatch(arg_0 -> EnergyManagerImpl.isBlockComponent$lambda$8(arg_0 -> EnergyManagerImpl.isBlockComponent$lambda$7(location, arg_0), arg_0));
    }

    @Override
    @Nullable
    public EnergyComponent<?> createComponent(@Nullable ItemStack item) {
        ItemStack itemStack = item;
        Intrinsics.checkNotNull(itemStack);
        Optional<EnergyComponent<?>> component = ItemsFactory.INSTANCE.getComponent(itemStack);
        if (component.isEmpty()) {
            Optional<EnergyType> optional = this.getEnergyType(item);
            Intrinsics.checkNotNull(optional);
            EnergyType energyType = optional.orElseThrow();
            Intrinsics.checkNotNull(energyType);
            EnergyType energyType2 = energyType;
            Optional<? extends EnergyMechanic> optional2 = this.getMechanic(item);
            Intrinsics.checkNotNull(optional2);
            EnergyMechanic mechanic = optional2.orElseThrow();
            return new EnergyComponent<EnergyMechanic>(energyType2, mechanic);
        }
        return component.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isComponent(@Nullable ItemStack item) {
        System.out.println((Object)("EnergyType: " + this.getEnergyType(item)));
        System.out.println((Object)("MechanicClass: " + this.getMechanicClass(item)));
        System.out.println((Object)("Mechanic: " + this.getMechanic(item)));
        Optional<EnergyType> optional = this.getEnergyType(item);
        if (optional == null) return false;
        if (!optional.isPresent()) return false;
        boolean bl = true;
        if (!bl) return false;
        Optional<String> optional2 = this.getMechanicClass(item);
        if (optional2 == null) return false;
        if (!optional2.isPresent()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Optional<? extends EnergyMechanic> optional3 = this.getMechanic(item);
        Intrinsics.checkNotNull(optional3);
        if (!optional3.isPresent()) return false;
        return true;
    }

    @Override
    @Nullable
    public ItemStack createItemComponent(@Nullable EnergyType type, @Nullable MechanicType mechanicType, @Nullable EnergyComponent<?> mechanic) {
        boolean bl;
        EnergyComponent<?> energyComponent = mechanic;
        if (energyComponent != null && (energyComponent = energyComponent.getClass()) != null) {
            MechanicType mechanicType2 = mechanicType;
            bl = ((Class)((Object)energyComponent)).isAssignableFrom(mechanicType2 != null ? mechanicType2.getClazz() : null);
        } else {
            bl = false;
        }
        if (!bl) {
            EnergyComponent<?> energyComponent2;
            boolean $i$a$-require-EnergyManagerImpl$createItemComponent$22 = false;
            MechanicType mechanicType3 = mechanicType;
            String $i$a$-require-EnergyManagerImpl$createItemComponent$22 = "Mechanic type " + (mechanicType3 != null ? mechanicType3.getClazz() : null) + " is not compatible with mechanic " + ((energyComponent2 = mechanic) != null && (energyComponent2 = energyComponent2.getMechanic()) != null ? energyComponent2.getClass() : null);
            throw new IllegalArgumentException($i$a$-require-EnergyManagerImpl$createItemComponent$22.toString());
        }
        ItemStack itemStack = ItemsFactory.INSTANCE.getItem(mechanic).orElseThrow(() -> EnergyManagerImpl.createItemComponent$lambda$10(mechanic));
        Intrinsics.checkNotNullExpressionValue(itemStack, "orElseThrow(...)");
        ItemStack item = itemStack;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            boolean $i$a$-requireNotNull-EnergyManagerImpl$createItemComponent$32 = false;
            String $i$a$-requireNotNull-EnergyManagerImpl$createItemComponent$32 = "ItemMeta is null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-EnergyManagerImpl$createItemComponent$32.toString());
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        NamespacedKey namespacedKey = this.energyLib.getEnergyTypeKey();
        PersistentDataType persistentDataType = EnergyTypePersistentDataType.Companion.getINSTANCE();
        EnergyType energyType = type;
        Intrinsics.checkNotNull(energyType);
        persistentDataContainer2.set(namespacedKey, persistentDataType, (Object)energyType);
        persistentDataContainer2.set(this.energyLib.getMechanicClassKey(), PersistentDataType.STRING, (Object)mechanic.getClass().getName());
        persistentDataContainer2.set(this.energyLib.getMechanicKey(), PersistentDataType.STRING, (Object)this.getGson().toJson(mechanic, (Type)mechanic.getClass()));
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void startNetworkUpdater() {
        this.updaterTask = BuildersKt.launch$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EnergyManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext(NonCancellable.INSTANCE, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ EnergyManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        this.label = 1;
                                        v0 = new UpdaterNetworksTask(this.this$0).run(this);
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure($result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = DelayKt.delay(1000L, this);
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure($result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @Override
    public void stopNetworkUpdater() {
        if (this.updaterTask == null) {
            boolean bl = false;
            String string = "Updater task is not running!";
            throw new IllegalStateException(string.toString());
        }
        Job job = this.updaterTask;
        Intrinsics.checkNotNull(job);
        Job.DefaultImpls.cancel$default(job, null, 1, null);
    }

    @Override
    public void deleteNetwork(@Nullable EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        if (energyNetwork != null) {
            energyNetwork.delete();
        }
        this.getNetworks().remove(network);
    }

    @Override
    public void saveNetworks() {
        this.getNetworks().forEach(EnergyManagerImpl::saveNetworks$lambda$13);
    }

    @Override
    public void loadNetworks(@Nullable Chunk chunk) {
        PersistentDataContainer chunkData;
        Chunk chunk2 = chunk;
        PersistentDataContainer persistentDataContainer = chunkData = chunk2 != null ? chunk2.getPersistentDataContainer() : null;
        boolean bl = persistentDataContainer != null ? persistentDataContainer.has(this.energyLib.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING)) : false;
        if (bl) {
            Object object = chunkData.getOrDefault(this.energyLib.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), new ArrayList());
            Intrinsics.checkNotNullExpressionValue(object, "getOrDefault(...)");
            List networkDatas = (List)object;
            for (String networkData : networkDatas) {
                Object object2 = this.getGson().fromJson(networkData, EnergyNetwork.class);
                Intrinsics.checkNotNullExpressionValue(object2, "fromJson(...)");
                EnergyNetwork network = (EnergyNetwork)object2;
                if (!this.getNetworks().stream().noneMatch(arg_0 -> EnergyManagerImpl.loadNetworks$lambda$15(arg_0 -> EnergyManagerImpl.loadNetworks$lambda$14(network, arg_0), arg_0))) continue;
                this.getNetworks().add(network);
            }
        }
    }

    @Override
    @Nullable
    public Optional<EnergyComponent<?>> getComponentFromBlock(@Nullable Location location) {
        Optional<Object> optional = this.getNetworks().stream().filter(arg_0 -> EnergyManagerImpl.getComponentFromBlock$lambda$17(arg_0 -> EnergyManagerImpl.getComponentFromBlock$lambda$16(location, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, "findFirst(...)");
        Optional<Object> optionalEnergyNetwork = optional;
        return optionalEnergyNetwork.map(arg_0 -> EnergyManagerImpl.getComponentFromBlock$lambda$18(location, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final Object splitNetworkIfNecessary(EnergyNetwork network, Continuation<? super Unit> $completion) {
        if (!($completion instanceof splitNetworkIfNecessary.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ EnergyManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EnergyManagerImpl.access$splitNetworkIfNecessary(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                visited = new HashSet<E>();
                newNetworks = new ArrayList<E>();
                defers = new ArrayList<E>();
                $this$forEach$iv = network.getComponents().keySet();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    component = (Location)element$iv;
                    $i$a$-forEach-EnergyManagerImpl$splitNetworkIfNecessary$2 = false;
                    defer = BuildersKt.async$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Set<Location>)visited, component, (List<EnergyNetwork>)newNetworks, null){
                        int label;
                        final /* synthetic */ EnergyManagerImpl this$0;
                        final /* synthetic */ Set<Location> $visited;
                        final /* synthetic */ Location $component;
                        final /* synthetic */ List<EnergyNetwork> $newNetworks;
                        {
                            this.this$0 = $receiver;
                            this.$visited = $visited;
                            this.$component = $component;
                            this.$newNetworks = $newNetworks;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure($result);
                                    EnergyManagerImpl.access$asyncNetworkSplit(this.this$0, this.$visited, this.$component, this.$newNetworks);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 3, null);
                    defers.add(defer);
                }
                $continuation.L$0 = network;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(visited);
                $continuation.L$2 = newNetworks;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable(defers);
                $continuation.label = 1;
                v0 = AwaitKt.awaitAll(defers, $continuation);
                if (v0 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl41
            }
            case 1: {
                defers = (List)$continuation.L$3;
                newNetworks = (List)$continuation.L$2;
                visited = (Set)$continuation.L$1;
                network = (EnergyNetwork)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl41:
                // 2 sources

                $this$forEach$iv = (Iterable)v0;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    (Unit)element$iv;
                    $i$a$-forEach-EnergyManagerImpl$splitNetworkIfNecessary$3 = false;
                    this.deleteNetwork(network);
                    this.getNetworks().addAll(newNetworks);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void asyncNetworkSplit(Set<Location> visited, Location component, List<EnergyNetwork> newNetworks) {
        Set<Map.Entry<Location, EnergyComponent<?>>> subNetworkComponents;
        if (!visited.contains(component) && !(subNetworkComponents = this.discoverSubNetwork(component, visited)).isEmpty()) {
            EnergyNetwork newNetwork = new EnergyNetwork(this.api, UUID.randomUUID());
            for (Map.Entry<Location, EnergyComponent<?>> subComponent : subNetworkComponents) {
                try {
                    EnergyComponent<?> energyComponent = subComponent.getValue();
                    Intrinsics.checkNotNull(energyComponent);
                    Location location = subComponent.getKey();
                    Intrinsics.checkNotNull(location);
                    newNetwork.addComponent(energyComponent, location);
                }
                catch (SameEnergyTypeException e) {
                    throw new RuntimeException(e);
                }
            }
            newNetworks.add(newNetwork);
        }
    }

    private final Set<Map.Entry<Location, EnergyComponent<?>>> discoverSubNetwork(Location startBlock, Set<Location> visited) {
        Set subNetwork = new HashSet();
        Queue queue = new LinkedList();
        queue.add(startBlock);
        while (!queue.isEmpty()) {
            Location current = (Location)queue.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            subNetwork.add(new AbstractMap.SimpleEntry<Location, Object>(current, this.getNetworks().stream().filter(arg_0 -> EnergyManagerImpl.discoverSubNetwork$lambda$22(arg_0 -> EnergyManagerImpl.discoverSubNetwork$lambda$21(current, arg_0), arg_0)).findFirst().map(arg_0 -> EnergyManagerImpl.discoverSubNetwork$lambda$24(arg_0 -> EnergyManagerImpl.discoverSubNetwork$lambda$23(current, arg_0), arg_0)).orElse(null)));
            for (BlockFace face : NEIBHORS) {
                Location neighbor;
                Intrinsics.checkNotNullExpressionValue(current.getBlock().getRelative(face).getLocation(), "getLocation(...)");
                if (!this.isBlockComponent(neighbor) || visited.contains(neighbor)) continue;
                queue.add(neighbor);
            }
        }
        return subNetwork;
    }

    private final <P, C> Optional<C> getPersistentData(ItemStack item, NamespacedKey key, PersistentDataType<P, C> type) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            Optional optional = Optional.empty();
            Intrinsics.checkNotNull(optional, "null cannot be cast to non-null type java.util.Optional<C of io.github.Jadiefication.redstoneflux.EnergyManagerImpl.getPersistentData?>");
            return optional;
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        Optional<Object> optional = Optional.ofNullable(persistentDataContainer2.get(key, type));
        Intrinsics.checkNotNull(optional, "null cannot be cast to non-null type java.util.Optional<C of io.github.Jadiefication.redstoneflux.EnergyManagerImpl.getPersistentData?>");
        return optional;
    }

    private final Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)EnergyType.class), (Object)new EnergyTypeAdapter());
        Intrinsics.checkNotNullExpressionValue(gsonBuilder, "registerTypeAdapter(...)");
        GsonBuilder builder = gsonBuilder;
        Gson gson = builder.create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        Gson temp = gson;
        builder.registerTypeAdapter((Type)((Object)EnergyComponent.class), (Object)new EnergyComponentAdapter(temp));
        Gson gson2 = builder.create();
        Intrinsics.checkNotNullExpressionValue(gson2, "create(...)");
        Gson temp2 = gson2;
        builder.registerTypeAdapter((Type)((Object)EnergyNetwork.class), (Object)new EnergyNetworkAdapter(this.api, temp2));
        Gson gson3 = builder.create();
        Intrinsics.checkNotNullExpressionValue(gson3, "create(...)");
        return gson3;
    }

    private static final boolean placeComponent$lambda$0(Block $neighbor, EnergyNetwork network) {
        boolean bl;
        EnergyNetwork energyNetwork = network;
        if (energyNetwork != null) {
            Block block = $neighbor;
            bl = energyNetwork.contains((Location)(block != null ? block.getLocation() : null));
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean placeComponent$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean placeComponent$lambda$2(EnergyComponent $component, EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        EnergyComponent energyComponent = $component;
        return (energyNetwork != null ? energyNetwork.getEnergyType() : null) == (energyComponent != null ? energyComponent.getEnergyType() : null);
    }

    private static final boolean placeComponent$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean breakComponent$lambda$4(Location $location, EnergyNetwork n) {
        EnergyNetwork energyNetwork = n;
        return energyNetwork != null ? energyNetwork.contains($location) : false;
    }

    private static final boolean breakComponent$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isBlockComponent$lambda$7(Location $location, EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        return energyNetwork != null ? energyNetwork.contains($location) : false;
    }

    private static final boolean isBlockComponent$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final IllegalArgumentException createItemComponent$lambda$10(EnergyComponent $mechanic) {
        return new IllegalArgumentException("Item not found for mechanic " + $mechanic.getClass());
    }

    private static final void saveNetworks$lambda$13(EnergyNetwork obj) {
        block0: {
            EnergyNetwork energyNetwork = obj;
            if (energyNetwork == null) break block0;
            energyNetwork.save();
        }
    }

    private static final boolean loadNetworks$lambda$14(EnergyNetwork $network, EnergyNetwork n) {
        EnergyNetwork energyNetwork = n;
        return Intrinsics.areEqual(energyNetwork != null ? energyNetwork.getId() : null, $network.getId());
    }

    private static final boolean loadNetworks$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getComponentFromBlock$lambda$16(Location $location, EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        return energyNetwork != null ? energyNetwork.contains($location) : false;
    }

    private static final boolean getComponentFromBlock$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final EnergyComponent getComponentFromBlock$lambda$18(Location $location, EnergyNetwork energyNetwork) {
        Object object = energyNetwork;
        return object != null && (object = ((EnergyNetwork)object).getComponents()) != null ? (EnergyComponent)object.get($location) : null;
    }

    private static final boolean discoverSubNetwork$lambda$21(Location $current, EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        return energyNetwork != null ? energyNetwork.contains($current) : false;
    }

    private static final boolean discoverSubNetwork$lambda$22(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final EnergyComponent discoverSubNetwork$lambda$23(Location $current, EnergyNetwork network) {
        Object object = network;
        return object != null && (object = ((EnergyNetwork)object).getComponents()) != null ? (EnergyComponent)object.get($current) : null;
    }

    private static final EnergyComponent discoverSubNetwork$lambda$24(Function1 $tmp0, Object p0) {
        return (EnergyComponent)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$splitNetworkIfNecessary(EnergyManagerImpl $this, EnergyNetwork network, Continuation $completion) {
        return $this.splitNetworkIfNecessary(network, $completion);
    }

    public static final /* synthetic */ void access$asyncNetworkSplit(EnergyManagerImpl $this, Set visited, Location component, List newNetworks) {
        $this.asyncNetworkSplit(visited, component, newNetworks);
    }

    static {
        List<BlockFace> list = List.of(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
        Intrinsics.checkNotNullExpressionValue(list, "of(...)");
        NEIBHORS = list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/Jadiefication/redstoneflux/EnergyManagerImpl$Companion;", "", "<init>", "()V", "NEIBHORS", "", "Lorg/bukkit/block/BlockFace;", "RedstoneFlux"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

