/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux.api.persistents.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyMechanic;
import io.github.Jadiefication.redstoneflux.api.types.EnergyType;
import java.io.IOException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002H\u0016J\u0014\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/Jadiefication/redstoneflux/api/persistents/adapters/EnergyComponentAdapter;", "Lcom/google/gson/TypeAdapter;", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;", "gson", "Lcom/google/gson/Gson;", "<init>", "(Lcom/google/gson/Gson;)V", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "read", "in", "Lcom/google/gson/stream/JsonReader;", "FluxAPI"})
@SourceDebugExtension(value={"SMAP\nEnergyComponentAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyComponentAdapter.kt\nio/github/Jadiefication/redstoneflux/api/persistents/adapters/EnergyComponentAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class EnergyComponentAdapter
extends TypeAdapter<EnergyComponent<?>> {
    @NotNull
    private final Gson gson;

    public EnergyComponentAdapter(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter(gson, "gson");
        this.gson = gson;
    }

    public void write(@NotNull JsonWriter out, @Nullable EnergyComponent<?> value) {
        EnergyComponent<?> energyComponent;
        Intrinsics.checkNotNullParameter(out, "out");
        out.beginObject();
        out.name("energyType");
        EnergyComponent<?> energyComponent2 = value;
        this.gson.toJson((Object)(energyComponent2 != null ? energyComponent2.getEnergyType() : null), (Type)((Object)EnergyType.class), out);
        out.name("mechanic-class");
        EnergyComponent<?> energyComponent3 = value;
        out.value(energyComponent3 != null && (energyComponent3 = energyComponent3.getMechanic()) != null && (energyComponent3 = energyComponent3.getClass()) != null ? ((Class)((Object)energyComponent3)).getName() : null);
        out.name("mechanic");
        EnergyComponent<?> energyComponent4 = value;
        String data = this.gson.toJson(energyComponent4 != null ? energyComponent4.getMechanic() : null, (Type)((energyComponent = value) != null && (energyComponent = energyComponent.getMechanic()) != null ? energyComponent.getClass() : null));
        out.value(data);
        out.endObject();
    }

    @NotNull
    public EnergyComponent<?> read(@NotNull JsonReader in) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        EnergyType energyType = null;
        Class<EnergyMechanic> mechanic = null;
        String energyMechanicData = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            String string = name;
            if (string == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case 1465037282: {
                    if (string.equals("energyType")) {
                        n = 1;
                    }
                    break;
                }
                case 1674287599: {
                    if (string.equals("mechanic-class")) {
                        n = 2;
                    }
                    break;
                }
                case -930312316: {
                    if (string.equals("mechanic")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    energyType = (EnergyType)this.gson.fromJson(in, (Type)((Object)EnergyType.class));
                    break;
                }
                case 2: {
                    String mechanicClass = in.nextString();
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(mechanicClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Class " + mechanicClass + " not found!");
                    }
                    if (!EnergyMechanic.class.isAssignableFrom(clazz)) {
                        boolean bl = false;
                        String string2 = "Class " + mechanicClass + " is not an EnergyMechanic!";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    mechanic = clazz.asSubclass(EnergyMechanic.class);
                    break;
                }
                case 3: {
                    energyMechanicData = in.nextString();
                }
            }
        }
        in.endObject();
        return new EnergyComponent<EnergyMechanic>(energyType, (EnergyMechanic)this.gson.fromJson(energyMechanicData, mechanic));
    }
}

