/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.api.models;

import fr.traqueur.commands.api.CommandManager;
import fr.traqueur.commands.api.arguments.Arguments;
import fr.traqueur.commands.api.arguments.TabCompleter;
import fr.traqueur.commands.api.exceptions.ArgumentIncorrectException;
import fr.traqueur.commands.api.exceptions.TypeArgumentNotExistException;
import fr.traqueur.commands.api.models.Command;
import fr.traqueur.commands.api.models.collections.CommandTree;
import fr.traqueur.commands.api.requirements.Requirement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommandInvoker<T, S> {
    private final CommandManager<T, S> manager;

    public CommandInvoker(CommandManager<T, S> manager) {
        this.manager = manager;
    }

    public boolean invoke(S source, String base, String[] rawArgs) {
        int max;
        Optional<CommandTree.MatchResult<T, S>> found = this.manager.getCommands().findNode(base, rawArgs);
        if (!found.isPresent()) {
            return false;
        }
        CommandTree.MatchResult<T, S> result2 = found.get();
        CommandTree.CommandNode node = result2.node;
        Optional cmdOpt = node.getCommand();
        if (!cmdOpt.isPresent()) {
            return false;
        }
        Command<T, S> command2 = cmdOpt.get();
        String label = node.getFullLabel() != null ? node.getFullLabel() : base;
        String[] args = result2.args;
        if (command2.inGameOnly() && !this.manager.getPlatform().isPlayer(source)) {
            this.manager.getPlatform().sendMessage(source, this.manager.getMessageHandler().getOnlyInGameMessage());
            return true;
        }
        String perm = command2.getPermission();
        if (!perm.isEmpty() && !this.manager.getPlatform().hasPermission(source, perm)) {
            this.manager.getPlatform().sendMessage(source, this.manager.getMessageHandler().getNoPermissionMessage());
            return true;
        }
        for (Requirement<S> req : command2.getRequirements()) {
            if (req.check(source)) continue;
            String msg = req.errorMessage().isEmpty() ? this.manager.getMessageHandler().getRequirementMessage().replace("%requirement%", req.getClass().getSimpleName()) : req.errorMessage();
            this.manager.getPlatform().sendMessage(source, msg);
            return true;
        }
        int min = command2.getArgs().size();
        int n = max = command2.isInfiniteArgs() ? Integer.MAX_VALUE : min + command2.getOptinalArgs().size();
        if (args.length < min || args.length > max) {
            String usage = command2.getUsage().isEmpty() ? command2.generateDefaultUsage(this.manager.getPlatform(), source, label) : command2.getUsage();
            this.manager.getPlatform().sendMessage(source, usage);
            return true;
        }
        try {
            Arguments parsed = this.manager.parse(command2, args);
            command2.execute(source, parsed);
        }
        catch (TypeArgumentNotExistException e) {
            this.manager.getPlatform().sendMessage(source, "&cInternal error: invalid argument type");
            return false;
        }
        catch (ArgumentIncorrectException e) {
            String msg = this.manager.getMessageHandler().getArgNotRecognized().replace("%arg%", e.getInput());
            this.manager.getPlatform().sendMessage(source, msg);
            return true;
        }
        return true;
    }

    public List<String> suggest(S source, String base, String[] args) {
        CommandTree.CommandNode<T, S> current;
        String lastArg;
        Optional<CommandTree.MatchResult<T, S>> found = this.manager.getCommands().findNode(base, args);
        String string = lastArg = args.length > 0 ? args[args.length - 1] : "";
        if (found.isPresent()) {
            TabCompleter<S> completer;
            CommandTree.MatchResult<T, S> result2 = found.get();
            CommandTree.CommandNode node = result2.node;
            String[] rawArgs = result2.args;
            String label = Optional.ofNullable(node.getFullLabel()).orElse(base);
            Map<Integer, TabCompleter<S>> map2 = this.manager.getCompleters().get(label);
            if (map2 != null && (completer = map2.get(args.length)) != null) {
                return completer.onCompletion(source, Arrays.asList(rawArgs)).stream().filter(opt -> this.allowedSuggestion(source, label, (String)opt)).filter(opt -> this.matchesPrefix((String)opt, lastArg)).collect(Collectors.toList());
            }
        }
        if ((current = this.manager.getCommands().getRoot().getChildren().get(base.toLowerCase())) == null) {
            return Collections.emptyList();
        }
        current = this.traverseNode(current, args);
        String parentLabel = current.getFullLabel();
        Stream<Object> children2 = current.getChildren().keySet().stream();
        if (args.length > 0 && current.getChildren().containsKey(lastArg.toLowerCase())) {
            children2 = children2.filter(opt -> this.matchesPrefix((String)opt, lastArg));
        }
        return children2.filter(opt -> this.allowedSuggestion(source, parentLabel, (String)opt)).collect(Collectors.toList());
    }

    private CommandTree.CommandNode<T, S> traverseNode(CommandTree.CommandNode<T, S> node, String[] args) {
        for (int index = 0; index < args.length - 1; ++index) {
            String arg = args[index].toLowerCase();
            CommandTree.CommandNode<T, S> child = node.getChildren().get(arg);
            if (child == null) break;
            node = child;
        }
        return node;
    }

    private boolean matchesPrefix(String candidate, String current) {
        String lower = current.toLowerCase();
        return candidate.equalsIgnoreCase(current) || candidate.toLowerCase().startsWith(lower);
    }

    private boolean allowedSuggestion(S src, String label, String opt) {
        String full = label + "." + opt.toLowerCase();
        Optional copt = this.manager.getCommands().findNode(full.split("\\.")).flatMap(r -> r.node.getCommand());
        if (!copt.isPresent()) {
            return true;
        }
        Command c = (Command)copt.get();
        return c.getRequirements().stream().allMatch(r -> r.check(src)) && (c.getPermission().isEmpty() || this.manager.getPlatform().hasPermission(src, c.getPermission()));
    }
}

