/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux;

import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/github/Jadiefication/redstoneflux/Updater;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "checkUpdates", "", "version", "getVersion", "()Ljava/lang/String;", "isUpToDate", "", "()Z", "fetchLatestVersion", "getString", "url", "Ljava/net/URL;", "Companion", "RedstoneFlux"})
public final class Updater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final String API_URL = "https://api.github.com/repos/Jadiefication/{name}/releases/latest";

    private Updater(String name) {
        this.name = name;
    }

    private final void checkUpdates() {
        if (!this.isUpToDate()) {
            Logger.getLogger(this.name).warning("The framework is not up to date, the latest version is " + this.fetchLatestVersion());
        }
    }

    private final String getVersion() {
        Properties prop = new Properties();
        try {
            prop.load(Updater.class.getClassLoader().getResourceAsStream("version.properties"));
            return "v" + prop.getProperty("version");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final boolean isUpToDate() {
        try {
            String latestVersion = this.fetchLatestVersion();
            return Intrinsics.areEqual(this.getVersion(), latestVersion);
        }
        catch (Exception e) {
            return false;
        }
    }

    private final String fetchLatestVersion() {
        try {
            URL url = URI.create(StringsKt.replace$default(API_URL, "{name}", this.name, false, 4, null)).toURL();
            Intrinsics.checkNotNull(url);
            String responseString = this.getString(url);
            int tagNameIndex = StringsKt.indexOf$default((CharSequence)responseString, "\"tag_name\"", 0, false, 6, null);
            int start = StringsKt.indexOf$default((CharSequence)responseString, '\"', tagNameIndex + 10, false, 4, null) + 1;
            int end = StringsKt.indexOf$default((CharSequence)responseString, '\"', start, false, 4, null);
            String string = responseString.substring(start, end);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getString(URL url) throws IOException {
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try {
            Closeable closeable = new Scanner(connection.getInputStream());
            Throwable throwable = null;
            try {
                Scanner scanner = (Scanner)closeable;
                boolean bl = false;
                while (scanner.hasNext()) {
                    response.append(scanner.nextLine());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        finally {
            connection.disconnect();
        }
        String string = response.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public /* synthetic */ Updater(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/github/Jadiefication/redstoneflux/Updater$Companion;", "", "<init>", "()V", "update", "", "name", "", "API_URL", "RedstoneFlux"})
    public static final class Companion {
        private Companion() {
        }

        public final void update(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            new Updater(name, null).checkUpdates();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

