/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux.api.persistents.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.Jadiefication.redstoneflux.api.EnergyAPI;
import io.github.Jadiefication.redstoneflux.api.components.BaseComponent;
import io.github.Jadiefication.redstoneflux.api.components.BaseNetwork;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.components.EnergyNetwork;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/Jadiefication/redstoneflux/api/persistents/adapters/EnergyNetworkAdapter;", "Lcom/google/gson/TypeAdapter;", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork;", "api", "Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "gson", "Lcom/google/gson/Gson;", "<init>", "(Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;Lcom/google/gson/Gson;)V", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "read", "in", "Lcom/google/gson/stream/JsonReader;", "toLocation", "Lorg/bukkit/Location;", "string", "", "fromLocation", "location", "FluxAPI"})
@SourceDebugExtension(value={"SMAP\nEnergyNetworkAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyNetworkAdapter.kt\nio/github/Jadiefication/redstoneflux/api/persistents/adapters/EnergyNetworkAdapter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n216#2,2:133\n739#3,9:135\n37#4:144\n36#4,3:145\n*S KotlinDebug\n*F\n+ 1 EnergyNetworkAdapter.kt\nio/github/Jadiefication/redstoneflux/api/persistents/adapters/EnergyNetworkAdapter\n*L\n94#1:133,2\n112#1:135,9\n112#1:144\n112#1:145,3\n*E\n"})
public final class EnergyNetworkAdapter
extends TypeAdapter<EnergyNetwork> {
    @Nullable
    private final EnergyAPI api;
    @NotNull
    private final Gson gson;

    public EnergyNetworkAdapter(@Nullable EnergyAPI api, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter(gson, "gson");
        this.api = api;
        this.gson = gson;
    }

    public void write(@NotNull JsonWriter out, @Nullable EnergyNetwork value) {
        Intrinsics.checkNotNullParameter(out, "out");
        out.beginObject();
        out.name("components");
        out.beginObject();
        Object object = value;
        Set set = object != null && (object = ((BaseNetwork)object).getComponents()) != null ? object.entrySet() : null;
        Intrinsics.checkNotNull(set);
        for (Map.Entry entry : set) {
            out.name(this.fromLocation((Location)entry.getKey()));
            this.gson.toJson(entry.getValue(), (Type)((Object)EnergyComponent.class), out);
        }
        out.endObject();
        out.name("id");
        out.value(String.valueOf(value.getId()));
        out.endObject();
    }

    @NotNull
    public EnergyNetwork read(@NotNull JsonReader in) throws IOException {
        Intrinsics.checkNotNullParameter(in, "in");
        Map components = new ConcurrentHashMap();
        String id = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (Intrinsics.areEqual(name, "components")) {
                in.beginObject();
                while (in.hasNext()) {
                    String string = in.nextName();
                    Intrinsics.checkNotNullExpressionValue(string, "nextName(...)");
                    Location location = this.toLocation(string);
                    EnergyComponent component = (EnergyComponent)this.gson.fromJson(in, (Type)((Object)EnergyComponent.class));
                    components.put(location, component);
                }
                in.endObject();
                continue;
            }
            if (StringsKt.equals(name, "id", true)) {
                id = in.nextString();
                continue;
            }
            throw new JsonSyntaxException("Unknown field in EnergyNetwork: " + name);
        }
        in.endObject();
        EnergyAPI energyAPI = this.api;
        Intrinsics.checkNotNull(energyAPI);
        EnergyNetwork network2 = new EnergyNetwork(energyAPI, UUID.fromString(id));
        Map $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            Location location = (Location)entry.getKey();
            EnergyComponent component = (EnergyComponent)entry.getValue();
            try {
                EnergyComponent energyComponent = component;
                Intrinsics.checkNotNull(energyComponent);
                BaseComponent baseComponent = energyComponent;
                Location location2 = location;
                Intrinsics.checkNotNull(location2);
                network2.addComponent(baseComponent, location2);
            }
            catch (SameEnergyTypeException e) {
                throw new RuntimeException(e);
            }
        }
        return network2;
    }

    private final Location toLocation(String string) {
        List list;
        CharSequence charSequence = string;
        Regex regex = new Regex(",");
        int n = 0;
        List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        World world = Intrinsics.areEqual(parts[0], "null") ? null : Bukkit.getServer().getWorld(UUID.fromString(parts[0]));
        String string2 = parts[1];
        Intrinsics.checkNotNull(string2);
        double d = Double.parseDouble(string2);
        String string3 = parts[2];
        Intrinsics.checkNotNull(string3);
        double d2 = Double.parseDouble(string3);
        String string4 = parts[3];
        Intrinsics.checkNotNull(string4);
        return new Location(world, d, d2, Double.parseDouble(string4));
    }

    private final String fromLocation(Location location) {
        String string;
        if (location.getWorld() == null) {
            string = "null";
        } else {
            World world = location.getWorld();
            Intrinsics.checkNotNull(world);
            string = world.getUID().toString();
        }
        String world = string;
        return world + "," + location.getX() + "," + location.getY() + "," + location.getZ();
    }
}

