/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.api.models;

import fr.traqueur.commands.api.CommandManager;
import fr.traqueur.commands.api.arguments.Argument;
import fr.traqueur.commands.api.arguments.Arguments;
import fr.traqueur.commands.api.arguments.TabCompleter;
import fr.traqueur.commands.api.exceptions.ArgsWithInfiniteArgumentException;
import fr.traqueur.commands.api.models.CommandPlatform;
import fr.traqueur.commands.api.requirements.Requirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Command<T, S> {
    private CommandManager<T, S> manager;
    private final T plugin;
    private final String name;
    private final List<String> aliases;
    private final List<Command<T, S>> subcommands;
    private final List<Argument<S>> args;
    private final List<Argument<S>> optionalArgs;
    private final List<Requirement<S>> requirements;
    private String description;
    private String usage;
    private String permission;
    private boolean gameOnly;
    private boolean infiniteArgs;
    private boolean subcommand;

    public Command(T plugin, String name) {
        this.plugin = plugin;
        this.name = name;
        this.permission = "";
        this.usage = "";
        this.description = "";
        this.gameOnly = false;
        this.aliases = new ArrayList<String>();
        this.subcommands = new ArrayList<Command<T, S>>();
        this.args = new ArrayList<Argument<S>>();
        this.optionalArgs = new ArrayList<Argument<S>>();
        this.requirements = new ArrayList<Requirement<S>>();
        this.subcommand = false;
    }

    public void setManager(CommandManager<T, S> manager) {
        this.manager = manager;
    }

    public abstract void execute(S var1, Arguments var2);

    public void unregister() {
        this.unregister(true);
    }

    public void unregister(boolean subcommands) {
        if (this.manager == null) {
            throw new IllegalArgumentException("The command is not registered.");
        }
        this.manager.unregisterCommand(this, subcommands);
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getPermission() {
        return this.permission;
    }

    public final String getUsage() {
        return this.usage;
    }

    public final List<String> getAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(this.name);
        if (!this.aliases.isEmpty()) {
            aliases.addAll(this.aliases);
        }
        return aliases;
    }

    public final List<Command<T, S>> getSubcommands() {
        return this.subcommands;
    }

    public final List<Argument<S>> getArgs() {
        return this.args;
    }

    public final List<Argument<S>> getOptinalArgs() {
        return this.optionalArgs;
    }

    public final boolean inGameOnly() {
        return this.gameOnly;
    }

    public final List<Requirement<S>> getRequirements() {
        return this.requirements;
    }

    public final boolean isInfiniteArgs() {
        return this.infiniteArgs;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final void setGameOnly(boolean gameOnly) {
        this.gameOnly = gameOnly;
    }

    public final void setPermission(String permission) {
        this.permission = permission;
    }

    public final void setUsage(String usage) {
        this.usage = usage;
    }

    public final void addAlias(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
    }

    public final void addAlias(String alias) {
        this.aliases.add(alias);
    }

    @SafeVarargs
    public final void addSubCommand(Command<T, S> ... commands) {
        List<Command<Command, S>> commandsList = Arrays.asList(commands);
        commandsList.forEach(Command::setSubcommand);
        this.subcommands.addAll(commandsList);
    }

    public final void addArgs(Object ... args) {
        if (Arrays.stream(args).allMatch(arg -> arg instanceof String)) {
            for (Object arg2 : args) {
                String argStr = (String)arg2;
                this.addArgs(argStr);
            }
            return;
        }
        if (args.length % 2 != 0 && !(args[1] instanceof String)) {
            throw new IllegalArgumentException("You must provide a type for the argument.");
        }
        for (int i = 0; i < args.length; i += 2) {
            if (!(args[i] instanceof String) || !(args[i + 1] instanceof Class)) {
                throw new IllegalArgumentException("You must provide a type for the argument.");
            }
            this.addArgs((String)args[i], (Class)args[i + 1]);
        }
    }

    public final void addArgs(String arg) {
        if (!arg.contains(":")) {
            this.addArgs(arg, String.class, null);
        } else {
            this.addArgs(arg, null, null);
        }
    }

    public final void addArgs(String arg, Class<?> type) {
        this.addArgs(arg, type, null);
    }

    public final void addArgs(String arg, TabCompleter<S> converter) {
        if (!arg.contains(":")) {
            this.addArgs(arg, String.class, converter);
        } else {
            this.addArgs(arg, null, converter);
        }
    }

    public final void addArgs(String arg, Class<?> type, TabCompleter<S> converter) {
        if (arg.contains(":") && type != null) {
            throw new IllegalArgumentException("You can't use the type parser in the command arguments.");
        }
        if (type == null && !arg.contains(":")) {
            throw new IllegalArgumentException("You must provide a type for the argument.");
        }
        if (type != null) {
            arg = arg + ":" + type.getSimpleName().toLowerCase();
        }
        this.add(arg, converter, false);
    }

    public final void addOptionalArgs(Object ... args) {
        if (Arrays.stream(args).allMatch(arg -> arg instanceof String)) {
            for (Object arg2 : args) {
                String argStr = (String)arg2;
                this.addOptionalArgs(argStr);
            }
            return;
        }
        if (args.length % 2 != 0 && !(args[1] instanceof String)) {
            throw new IllegalArgumentException("You must provide a type for the argument.");
        }
        for (int i = 0; i < args.length; i += 2) {
            if (!(args[i] instanceof String) || !(args[i + 1] instanceof Class)) {
                throw new IllegalArgumentException("You must provide a type for the argument.");
            }
            this.addOptionalArgs((String)args[i], (Class)args[i + 1]);
        }
    }

    public final void addOptionalArgs(String arg) {
        if (!arg.contains(":")) {
            this.addOptionalArgs(arg, String.class, null);
            return;
        }
        this.addOptionalArgs(arg, null, null);
    }

    public final void addOptionalArgs(String arg, Class<?> type) {
        this.addOptionalArgs(arg, type, null);
    }

    public final void addOptionalArgs(String arg, TabCompleter<S> converter) {
        if (!arg.contains(":")) {
            this.addOptionalArgs(arg, String.class, converter);
            return;
        }
        this.addOptionalArgs(arg, null, converter);
    }

    public final void addOptionalArgs(String arg, Class<?> type, TabCompleter<S> converter) {
        if (arg.contains(":") && type != null) {
            throw new IllegalArgumentException("You can't use the type parser in the command arguments.");
        }
        if (type != null) {
            arg = arg + ":" + type.getSimpleName().toLowerCase();
        }
        this.add(arg, converter, true);
    }

    private void add(String arg, TabCompleter<S> converter, boolean opt) {
        try {
            if (this.infiniteArgs) {
                throw new ArgsWithInfiniteArgumentException(false);
            }
            if (arg.contains(":infinite")) {
                this.infiniteArgs = true;
            }
            if (opt) {
                this.optionalArgs.add(new Argument<S>(arg, converter));
            } else {
                this.args.add(new Argument<S>(arg, converter));
            }
        }
        catch (ArgsWithInfiniteArgumentException e) {
            this.manager.getLogger().error(e.getMessage());
        }
    }

    public final void addRequirements(Requirement<S> ... requirement) {
        this.requirements.addAll(Arrays.asList(requirement));
    }

    public final boolean isSubCommand() {
        return this.subcommand;
    }

    public final T getPlugin() {
        return this.plugin;
    }

    public String generateDefaultUsage(CommandPlatform<T, S> platform, S sender, String label) {
        StringBuilder usage = new StringBuilder("/");
        CharSequence[] parts = label.split("\\.");
        usage.append(String.join((CharSequence)" ", parts));
        List directSubs = this.getSubcommands().stream().filter(sub -> {
            String perm = sub.getPermission();
            return perm.isEmpty() || platform.hasPermission(sender, perm);
        }).collect(Collectors.toList());
        if (!directSubs.isEmpty()) {
            usage.append(" <");
            String subs = directSubs.stream().map(Command::getName).map(str -> str.split("\\.")[0]).collect(Collectors.joining("|"));
            usage.append(subs).append(">");
        }
        if (!this.getArgs().isEmpty() || !this.getOptinalArgs().isEmpty()) {
            usage.append(!directSubs.isEmpty() ? "|" : " ");
            String req = this.getArgs().stream().map(arg -> "<" + arg.arg() + ">").collect(Collectors.joining(" "));
            usage.append(req);
            if (!this.getOptinalArgs().isEmpty()) {
                if (!req.isEmpty()) {
                    usage.append(" ");
                }
                String opt = this.getOptinalArgs().stream().map(arg -> "[" + arg.arg() + "]").collect(Collectors.joining(" "));
                usage.append(opt);
            }
        }
        return usage.toString();
    }

    private void setSubcommand() {
        this.subcommand = true;
    }
}

