/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.api.updater;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;

public class Updater {
    private static final String VERSION_PROPERTY_FILE = "commands.properties";
    private static URL URL_LATEST_RELEASE;
    private static Logger LOGGER;

    public static void setUrlLatestRelease(URL URL_LATEST_RELEASE) {
        Updater.URL_LATEST_RELEASE = URL_LATEST_RELEASE;
    }

    public static void setLogger(Logger LOGGER) {
        Updater.LOGGER = LOGGER;
    }

    private Updater() {
    }

    public static void checkUpdates() {
        if (!Updater.isUpToDate()) {
            LOGGER.warning("The framework is not up to date, the latest version is " + Updater.fetchLatestVersion());
        }
    }

    public static String getVersion() {
        Properties prop = new Properties();
        try {
            prop.load(Updater.class.getClassLoader().getResourceAsStream(VERSION_PROPERTY_FILE));
            return prop.getProperty("version");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isUpToDate() {
        try {
            String latestVersion = Updater.fetchLatestVersion();
            return Updater.getVersion().equals(latestVersion);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String fetchLatestVersion() {
        try {
            String responseString = Updater.getString();
            int tagNameIndex = responseString.indexOf("\"tag_name\"");
            int start = responseString.indexOf(34, tagNameIndex + 10) + 1;
            int end = responseString.indexOf(34, start);
            return responseString.substring(start, end);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getString() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)URL_LATEST_RELEASE.openConnection();
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try (Scanner scanner = new Scanner(connection.getInputStream());){
            while (scanner.hasNext()) {
                response.append(scanner.nextLine());
            }
        }
        finally {
            connection.disconnect();
        }
        return response.toString();
    }

    static {
        LOGGER = Logger.getLogger("CommandsAPI");
        try {
            URL_LATEST_RELEASE = URI.create("https://api.github.com/repos/Traqueur-dev/CommandsAPI/releases/latest").toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

