/*
 * Decompiled with CFR 0.152.
 */
package fr.traqueur.commands.spigot.requirements;

import fr.traqueur.commands.api.requirements.Requirement;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ZoneRequirement
implements Requirement<CommandSender> {
    private final Location locationUp;
    private final Location locationDown;

    public static Requirement<CommandSender> of(Location locationUp, Location locationDown) {
        return new ZoneRequirement(locationUp, locationDown);
    }

    public static Requirement<CommandSender> of(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        return new ZoneRequirement(new Location(world, (double)x1, (double)y1, (double)z1), new Location(world, (double)x2, (double)y2, (double)z2));
    }

    public static Requirement<CommandSender> of(World world, int x1, int z1, int x2, int z2) {
        return new ZoneRequirement(new Location(world, (double)x1, (double)world.getMaxHeight(), (double)z1), new Location(world, (double)x2, (double)world.getMinHeight(), (double)z2));
    }

    public ZoneRequirement(Location locationUp, Location locationDown) {
        if (locationUp.getWorld() == null || locationDown.getWorld() == null) {
            throw new IllegalArgumentException("The locations must not be null.");
        }
        if (!locationUp.getWorld().getName().equals(locationDown.getWorld().getName())) {
            throw new IllegalArgumentException("The locations must be in the same world.");
        }
        this.locationUp = new Location(locationUp.getWorld(), (double)Math.max(locationUp.getBlockX(), locationDown.getBlockX()), (double)Math.max(locationUp.getBlockY(), locationDown.getBlockY()), (double)Math.max(locationUp.getBlockZ(), locationDown.getBlockZ()));
        this.locationDown = new Location(locationDown.getWorld(), (double)Math.min(locationUp.getBlockX(), locationDown.getBlockX()), (double)Math.min(locationUp.getBlockY(), locationDown.getBlockY()), (double)Math.min(locationUp.getBlockZ(), locationDown.getBlockZ()));
    }

    private boolean isInside(Player player) {
        return player.getLocation().getBlockX() >= this.locationDown.getBlockX() && player.getLocation().getBlockX() <= this.locationUp.getBlockX() && player.getLocation().getBlockY() >= this.locationDown.getBlockY() && player.getLocation().getBlockY() <= this.locationUp.getBlockY() && player.getLocation().getBlockZ() >= this.locationDown.getBlockZ() && player.getLocation().getBlockZ() <= this.locationUp.getBlockZ();
    }

    private String getCoords(Location location) {
        return (location.getWorld() != null ? location.getWorld().getName() + ", " : "") + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ();
    }

    @Override
    public boolean check(CommandSender sender) {
        return sender instanceof Player && this.isInside((Player)sender);
    }

    @Override
    public String errorMessage() {
        return "&cSender must be in the zone between " + this.getCoords(this.locationDown) + " and " + this.getCoords(this.locationUp) + ".";
    }
}

