/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.Jadiefication.redstoneflux.EnergyManagerImpl;
import io.github.Jadiefication.redstoneflux.RedstoneFlux;
import io.github.Jadiefication.redstoneflux.UpdaterNetworksTask;
import io.github.Jadiefication.redstoneflux.api.EnergyAPI;
import io.github.Jadiefication.redstoneflux.api.EnergyManager;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.components.EnergyNetwork;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import io.github.Jadiefication.redstoneflux.api.items.ItemsFactory;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyMechanic;
import io.github.Jadiefication.redstoneflux.api.persistents.EnergyTypePersistentDataType;
import io.github.Jadiefication.redstoneflux.api.persistents.adapters.EnergyComponentAdapter;
import io.github.Jadiefication.redstoneflux.api.persistents.adapters.EnergyNetworkAdapter;
import io.github.Jadiefication.redstoneflux.api.persistents.adapters.EnergyTypeAdapter;
import io.github.Jadiefication.redstoneflux.api.types.EnergyType;
import io.github.Jadiefication.redstoneflux.api.types.MechanicType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.NonCancellable;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 M2\u00020\u0001:\u0001MB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010%\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010&0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010!\u001a\u00020\"H\u0016J$\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\b\u00100\u001a\u00020\u0016H\u0016J\b\u00101\u001a\u00020\u0016H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0010H\u0016J\b\u00104\u001a\u00020\u0016H\u0016J\u0010\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u000207H\u0016J\u001a\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u00109\u001a\u00020\u0016H\u0016J.\u0010:\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00102\u0016\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180<H\u0082@\u00a2\u0006\u0002\u0010=JD\u0010>\u001a\u00020\u00162\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0006\u0010\u0017\u001a\u00020\u001a2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00100A2\u0016\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180<H\u0002JL\u0010B\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180C0\u000f2\u0006\u0010D\u001a\u00020\u001a2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u0016\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180<H\u0002JH\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HF0\u001f\"\b\b\u0000\u0010G*\u00020H\"\b\b\u0001\u0010F*\u00020H2\u0006\u0010!\u001a\u00020\"2\u0006\u0010I\u001a\u00020J2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002HG\u0012\u0004\u0012\u0002HF0KH\u0002J\b\u0010L\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lio/github/Jadiefication/redstoneflux/EnergyManagerImpl;", "Lio/github/Jadiefication/redstoneflux/api/EnergyManager;", "energyLib", "Lio/github/Jadiefication/redstoneflux/RedstoneFlux;", "<init>", "(Lio/github/Jadiefication/redstoneflux/RedstoneFlux;)V", "getEnergyLib", "()Lio/github/Jadiefication/redstoneflux/RedstoneFlux;", "api", "Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "networks", "", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork;", "getNetworks", "()Ljava/util/Set;", "updaterTask", "Lkotlinx/coroutines/Job;", "placeComponent", "", "component", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;", "location", "Lorg/bukkit/Location;", "breakComponent", "player", "Lorg/bukkit/entity/Player;", "getEnergyType", "Ljava/util/Optional;", "Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;", "item", "Lorg/bukkit/inventory/ItemStack;", "getMechanicClass", "", "getMechanic", "Lio/github/Jadiefication/redstoneflux/api/mechanics/EnergyMechanic;", "isBlockComponent", "", "createComponent", "isComponent", "createItemComponent", "type", "mechanicType", "Lio/github/Jadiefication/redstoneflux/api/types/MechanicType;", "mechanic", "startNetworkUpdater", "stopNetworkUpdater", "deleteNetwork", "network", "saveNetworks", "loadNetworks", "chunk", "Lorg/bukkit/Chunk;", "getComponentFromBlock", "cleanUpNetworks", "splitNetworkIfNecessary", "originalComponents", "", "(Lio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "asyncNetworkSplit", "visited", "newNetworks", "", "discoverSubNetwork", "", "startBlock", "getPersistentData", "C", "P", "", "key", "Lorg/bukkit/NamespacedKey;", "Lorg/bukkit/persistence/PersistentDataType;", "createGson", "Companion", "RedstoneFlux"})
@SourceDebugExtension(value={"SMAP\nEnergyManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyManagerImpl.kt\nio/github/Jadiefication/redstoneflux/EnergyManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,489:1\n1#2:490\n1869#3,2:491\n1869#3,2:493\n*S KotlinDebug\n*F\n+ 1 EnergyManagerImpl.kt\nio/github/Jadiefication/redstoneflux/EnergyManagerImpl\n*L\n359#1:491,2\n366#1:493,2\n*E\n"})
public final class EnergyManagerImpl
implements EnergyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RedstoneFlux energyLib;
    @NotNull
    private final EnergyAPI api;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Set<EnergyNetwork> networks;
    @Nullable
    private Job updaterTask;
    @NotNull
    private static final List<BlockFace> NEIGHBORS;

    public EnergyManagerImpl(@NotNull RedstoneFlux energyLib) {
        Intrinsics.checkNotNullParameter(energyLib, "energyLib");
        this.energyLib = energyLib;
        this.api = this.energyLib;
        this.gson = this.createGson();
        ItemsFactory.INSTANCE.setGson(this.getGson());
        this.networks = new HashSet();
    }

    @NotNull
    public final RedstoneFlux getEnergyLib() {
        return this.energyLib;
    }

    @Override
    @NotNull
    public Gson getGson() {
        return this.gson;
    }

    @Override
    @NotNull
    public Set<EnergyNetwork> getNetworks() {
        return this.networks;
    }

    @Override
    public void placeComponent(@NotNull EnergyComponent<?> component, @NotNull Location location) throws SameEnergyTypeException {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(location, "location");
        List energyNetworks = new ArrayList();
        for (BlockFace neibhorFace : NEIGHBORS) {
            Block neighbor;
            Intrinsics.checkNotNullExpressionValue(location.getBlock().getRelative(neibhorFace), "getRelative(...)");
            Optional<Object> optional = this.getNetworks().stream().filter(arg_0 -> EnergyManagerImpl.placeComponent$lambda$1(arg_0 -> EnergyManagerImpl.placeComponent$lambda$0(neighbor, arg_0), arg_0)).findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, "findFirst(...)");
            Optional<Object> networkNeighbor = optional;
            if (!networkNeighbor.isPresent() || energyNetworks.contains(networkNeighbor.get())) continue;
            Object object = networkNeighbor.get();
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            energyNetworks.add(object);
        }
        List list = energyNetworks.stream().filter(arg_0 -> EnergyManagerImpl.placeComponent$lambda$3(arg_0 -> EnergyManagerImpl.placeComponent$lambda$2(component, arg_0), arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, "collect(...)");
        energyNetworks = list;
        if (energyNetworks.isEmpty()) {
            EnergyNetwork network = new EnergyNetwork(this.api, component, location);
            this.getNetworks().add(network);
        } else if (energyNetworks.size() == 1) {
            ((EnergyNetwork)CollectionsKt.first(energyNetworks)).addComponent(component, location);
        } else {
            EnergyNetwork firstNetwork = (EnergyNetwork)CollectionsKt.first(energyNetworks);
            firstNetwork.addComponent(component, location);
            int n = energyNetworks.size();
            for (int i = 1; i < n; ++i) {
                EnergyNetwork network = (EnergyNetwork)energyNetworks.get(i);
                firstNetwork.mergeWith(network);
                this.deleteNetwork(network);
            }
        }
    }

    @Override
    public void breakComponent(@NotNull Player player, @NotNull Location location) {
        EnergyComponent<?> component;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        EnergyNetwork network = this.getNetworks().stream().filter(arg_0 -> EnergyManagerImpl.breakComponent$lambda$5(arg_0 -> EnergyManagerImpl.breakComponent$lambda$4(location, arg_0), arg_0)).findFirst().orElse(null);
        if (network == null) {
            return;
        }
        EnergyComponent<?> energyComponent = component = network.getComponents().get(location);
        EnergyType energyType = energyComponent != null ? energyComponent.getEnergyType() : null;
        EnergyComponent<?> energyComponent2 = component;
        Intrinsics.checkNotNull(energyComponent2);
        MechanicType mechanicType = MechanicType.Companion.fromComponent(energyComponent2);
        location.getBlock().setType(Material.AIR);
        if (player.getGameMode() != GameMode.CREATIVE) {
            EnergyType energyType2 = energyType;
            Intrinsics.checkNotNull(energyType2);
            ItemStack result2 = this.createItemComponent(energyType2, mechanicType, component);
            player.getWorld().dropItemNaturally(location, result2);
        }
        Map<Location, EnergyComponent<?>> originalComponents = MapsKt.toMap(network.getComponents());
        network.removeComponent(location);
        if (network.isEmpty()) {
            this.deleteNetwork(network);
            return;
        }
        BuildersKt.launch$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, network, originalComponents, null){
            int label;
            final /* synthetic */ EnergyManagerImpl this$0;
            final /* synthetic */ EnergyNetwork $network;
            final /* synthetic */ Map<Location, EnergyComponent<?>> $originalComponents;
            {
                this.this$0 = $receiver;
                this.$network = $network;
                this.$originalComponents = $originalComponents;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = EnergyManagerImpl.access$splitNetworkIfNecessary(this.this$0, this.$network, this.$originalComponents, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public Optional<EnergyType> getEnergyType(@NotNull ItemStack item) {
        Optional<EnergyType> optional;
        Intrinsics.checkNotNullParameter(item, "item");
        Optional<EnergyType> pdcOptional = this.getPersistentData(item, this.energyLib.getEnergyTypeKey(), EnergyTypePersistentDataType.Companion.getINSTANCE());
        if (pdcOptional.isEmpty()) {
            EnergyComponent<?> energyComponent = OptionalsKt.getOrNull(ItemsFactory.INSTANCE.getComponent(item));
            Optional<EnergyType> optional2 = Optional.ofNullable(energyComponent != null ? energyComponent.getEnergyType() : null);
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            optional = pdcOptional;
        }
        Intrinsics.checkNotNull(optional, "null cannot be cast to non-null type java.util.Optional<io.github.Jadiefication.redstoneflux.api.types.EnergyType?>");
        return optional;
    }

    @Override
    @NotNull
    public Optional<String> getMechanicClass(@NotNull ItemStack item) {
        Optional<String> optional;
        Intrinsics.checkNotNullParameter(item, "item");
        NamespacedKey namespacedKey = this.energyLib.getMechanicClassKey();
        PersistentDataType persistentDataType = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
        Optional<String> pdcOptional = this.getPersistentData(item, namespacedKey, persistentDataType);
        if (pdcOptional.isEmpty()) {
            EnergyComponent<?> energyComponent = OptionalsKt.getOrNull(ItemsFactory.INSTANCE.getComponent(item));
            Optional<Object> optional2 = Optional.ofNullable(energyComponent != null && (energyComponent = energyComponent.getMechanic()) != null && (energyComponent = energyComponent.getClass()) != null ? ((Class)((Object)energyComponent)).getName() : null);
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            optional = pdcOptional;
        }
        Intrinsics.checkNotNull(optional, "null cannot be cast to non-null type java.util.Optional<kotlin.String?>");
        return optional;
    }

    @Override
    @NotNull
    public Optional<? extends EnergyMechanic> getMechanic(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        String mechanicClass = this.getMechanicClass(item).orElseThrow();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(mechanicClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Class " + mechanicClass + " not found!");
        }
        if (!EnergyMechanic.class.isAssignableFrom(clazz)) {
            boolean $i$a$-require-EnergyManagerImpl$getMechanic$32 = false;
            String $i$a$-require-EnergyManagerImpl$getMechanic$32 = "Class " + mechanicClass + " is not an EnergyMechanic!";
            throw new IllegalArgumentException($i$a$-require-EnergyManagerImpl$getMechanic$32.toString());
        }
        Class<EnergyMechanic> clazz2 = clazz.asSubclass(EnergyMechanic.class);
        Intrinsics.checkNotNullExpressionValue(clazz2, "asSubclass(...)");
        Class<EnergyMechanic> mechanicClazz = clazz2;
        NamespacedKey namespacedKey = this.energyLib.getMechanicKey();
        PersistentDataType persistentDataType = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
        Optional opt = this.getPersistentData(item, namespacedKey, persistentDataType);
        if (opt.isEmpty()) {
            Optional optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, "empty(...)");
            return optional;
        }
        Object c = opt.get();
        Intrinsics.checkNotNullExpressionValue(c, "get(...)");
        String mechanicData = (String)c;
        Optional<Object> optional = Optional.of(this.getGson().fromJson(mechanicData, mechanicClazz));
        Intrinsics.checkNotNullExpressionValue(optional, "of(...)");
        return optional;
    }

    @Override
    public boolean isBlockComponent(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.getNetworks().stream().anyMatch(arg_0 -> EnergyManagerImpl.isBlockComponent$lambda$8(arg_0 -> EnergyManagerImpl.isBlockComponent$lambda$7(location, arg_0), arg_0));
    }

    @Override
    @NotNull
    public EnergyComponent<?> createComponent(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        Optional<EnergyComponent<?>> component = ItemsFactory.INSTANCE.getComponent(item);
        if (component.isEmpty()) {
            EnergyType energyType = this.getEnergyType(item).orElseThrow();
            Intrinsics.checkNotNull(energyType);
            EnergyType energyType2 = energyType;
            EnergyMechanic mechanic = this.getMechanic(item).orElseThrow();
            return new EnergyComponent<EnergyMechanic>(energyType2, mechanic);
        }
        EnergyComponent<?> energyComponent = component.get();
        Intrinsics.checkNotNull(energyComponent);
        return energyComponent;
    }

    @Override
    public boolean isComponent(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        if (this.api.isDebug()) {
            System.out.println((Object)("EnergyType: " + this.getEnergyType(item)));
            System.out.println((Object)("MechanicClass: " + this.getMechanicClass(item)));
            System.out.println((Object)("Mechanic: " + this.getMechanic(item)));
        }
        return this.getEnergyType(item).isPresent() && this.getMechanicClass(item).isPresent() && this.getMechanic(item).isPresent();
    }

    @Override
    @NotNull
    public ItemStack createItemComponent(@NotNull EnergyType type, @NotNull MechanicType mechanicType, @NotNull EnergyComponent<?> mechanic) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter((Object)mechanicType, "mechanicType");
        Intrinsics.checkNotNullParameter(mechanic, "mechanic");
        if (!mechanic.getClass().isAssignableFrom(mechanicType.getClazz())) {
            boolean $i$a$-require-EnergyManagerImpl$createItemComponent$22 = false;
            Object obj = mechanic.getMechanic();
            String $i$a$-require-EnergyManagerImpl$createItemComponent$22 = "Mechanic type " + mechanicType.getClazz() + " is not compatible with mechanic " + (obj != null ? obj.getClass() : null);
            throw new IllegalArgumentException($i$a$-require-EnergyManagerImpl$createItemComponent$22.toString());
        }
        ItemStack itemStack = ItemsFactory.INSTANCE.getItem(mechanic).orElseThrow(() -> EnergyManagerImpl.createItemComponent$lambda$10(mechanic));
        Intrinsics.checkNotNullExpressionValue(itemStack, "orElseThrow(...)");
        ItemStack item = itemStack;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            boolean $i$a$-requireNotNull-EnergyManagerImpl$createItemComponent$32 = false;
            String $i$a$-requireNotNull-EnergyManagerImpl$createItemComponent$32 = "ItemMeta is null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-EnergyManagerImpl$createItemComponent$32.toString());
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        persistentDataContainer2.set(this.energyLib.getEnergyTypeKey(), (PersistentDataType)EnergyTypePersistentDataType.Companion.getINSTANCE(), (Object)type);
        persistentDataContainer2.set(this.energyLib.getMechanicClassKey(), PersistentDataType.STRING, (Object)mechanic.getClass().getName());
        persistentDataContainer2.set(this.energyLib.getMechanicKey(), PersistentDataType.STRING, (Object)this.getGson().toJson(mechanic, (Type)mechanic.getClass()));
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void startNetworkUpdater() {
        this.updaterTask = BuildersKt.launch$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EnergyManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext(NonCancellable.INSTANCE, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ EnergyManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        this.label = 1;
                                        v0 = new UpdaterNetworksTask(this.this$0).run(this);
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure($result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = DelayKt.delay(1000L, this);
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure($result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @Override
    public void stopNetworkUpdater() {
        if (this.updaterTask == null) {
            boolean bl = false;
            String string = "Updater task is not running!";
            throw new IllegalStateException(string.toString());
        }
        Job job = this.updaterTask;
        Intrinsics.checkNotNull(job);
        Job.DefaultImpls.cancel$default(job, null, 1, null);
    }

    @Override
    public void deleteNetwork(@NotNull EnergyNetwork network) {
        Intrinsics.checkNotNullParameter(network, "network");
        network.delete();
        this.getNetworks().remove(network);
    }

    @Override
    public void saveNetworks() {
        this.getNetworks().forEach(EnergyManagerImpl::saveNetworks$lambda$13);
    }

    @Override
    public void loadNetworks(@NotNull Chunk chunk) {
        PersistentDataContainer chunkData;
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        PersistentDataContainer persistentDataContainer = chunkData = chunk.getPersistentDataContainer();
        boolean bl = persistentDataContainer != null ? persistentDataContainer.has(this.energyLib.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING)) : false;
        if (bl) {
            Object object = chunkData.getOrDefault(this.energyLib.getNetworkKey(), (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), new ArrayList());
            Intrinsics.checkNotNullExpressionValue(object, "getOrDefault(...)");
            List networkDatas = (List)object;
            for (String networkData : networkDatas) {
                Object object2 = this.getGson().fromJson(networkData, EnergyNetwork.class);
                Intrinsics.checkNotNullExpressionValue(object2, "fromJson(...)");
                EnergyNetwork network = (EnergyNetwork)object2;
                if (!this.getNetworks().stream().noneMatch(arg_0 -> EnergyManagerImpl.loadNetworks$lambda$15(arg_0 -> EnergyManagerImpl.loadNetworks$lambda$14(network, arg_0), arg_0))) continue;
                this.getNetworks().add(network);
            }
        }
    }

    @Override
    @NotNull
    public Optional<EnergyComponent<?>> getComponentFromBlock(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        Optional<Object> optional = this.getNetworks().stream().filter(arg_0 -> EnergyManagerImpl.getComponentFromBlock$lambda$17(arg_0 -> EnergyManagerImpl.getComponentFromBlock$lambda$16(location, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, "findFirst(...)");
        Optional<Object> optionalEnergyNetwork = optional;
        Optional<EnergyComponent<?>> optional2 = optionalEnergyNetwork.map(arg_0 -> EnergyManagerImpl.getComponentFromBlock$lambda$18(location, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional2, "map(...)");
        return optional2;
    }

    @Override
    public void cleanUpNetworks() {
        this.getNetworks().removeIf(arg_0 -> EnergyManagerImpl.cleanUpNetworks$lambda$20(EnergyManagerImpl::cleanUpNetworks$lambda$19, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final Object splitNetworkIfNecessary(EnergyNetwork network, Map<Location, ? extends EnergyComponent<?>> originalComponents, Continuation<? super Unit> $completion) {
        if (!($completion instanceof splitNetworkIfNecessary.1)) ** GOTO lbl-1000
        var15_4 = $completion;
        if ((var15_4.label & -2147483648) != 0) {
            var15_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ EnergyManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EnergyManagerImpl.access$splitNetworkIfNecessary(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var16_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                visited = new HashSet<E>();
                newNetworks = new ArrayList<E>();
                defers = new ArrayList<E>();
                $this$forEach$iv = network.getComponents().keySet();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    component = (Location)element$iv;
                    $i$a$-forEach-EnergyManagerImpl$splitNetworkIfNecessary$2 = false;
                    defer = BuildersKt.async$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Set<Location>)visited, component, (List<EnergyNetwork>)newNetworks, originalComponents, null){
                        int label;
                        final /* synthetic */ EnergyManagerImpl this$0;
                        final /* synthetic */ Set<Location> $visited;
                        final /* synthetic */ Location $component;
                        final /* synthetic */ List<EnergyNetwork> $newNetworks;
                        final /* synthetic */ Map<Location, EnergyComponent<?>> $originalComponents;
                        {
                            this.this$0 = $receiver;
                            this.$visited = $visited;
                            this.$component = $component;
                            this.$newNetworks = $newNetworks;
                            this.$originalComponents = $originalComponents;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure($result);
                                    EnergyManagerImpl.access$asyncNetworkSplit(this.this$0, this.$visited, this.$component, this.$newNetworks, this.$originalComponents);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 3, null);
                    defers.add(defer);
                }
                $continuation.L$0 = network;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(originalComponents);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(visited);
                $continuation.L$3 = newNetworks;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(defers);
                $continuation.label = 1;
                v0 = AwaitKt.awaitAll(defers, $continuation);
                if (v0 == var16_6) {
                    return var16_6;
                }
                ** GOTO lbl43
            }
            case 1: {
                defers = (List)$continuation.L$4;
                newNetworks = (List)$continuation.L$3;
                visited = (Set)$continuation.L$2;
                originalComponents = (Map)$continuation.L$1;
                network = (EnergyNetwork)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl43:
                // 2 sources

                $this$forEach$iv = (Iterable)v0;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    (Unit)element$iv;
                    $i$a$-forEach-EnergyManagerImpl$splitNetworkIfNecessary$3 = false;
                    this.deleteNetwork(network);
                    this.getNetworks().addAll(newNetworks);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void asyncNetworkSplit(Set<Location> visited, Location component, List<EnergyNetwork> newNetworks, Map<Location, ? extends EnergyComponent<?>> originalComponents) {
        Set<Map.Entry<Location, EnergyComponent<?>>> subNetworkComponents;
        if (!visited.contains(component) && !(subNetworkComponents = this.discoverSubNetwork(component, visited, originalComponents)).isEmpty()) {
            EnergyNetwork newNetwork = new EnergyNetwork(this.api, UUID.randomUUID());
            for (Map.Entry<Location, EnergyComponent<?>> subComponent : subNetworkComponents) {
                try {
                    newNetwork.addComponent(subComponent.getValue(), subComponent.getKey());
                }
                catch (SameEnergyTypeException e) {
                    throw new RuntimeException(e);
                }
            }
            newNetworks.add(newNetwork);
        }
    }

    private final Set<Map.Entry<Location, EnergyComponent<?>>> discoverSubNetwork(Location startBlock, Set<Location> visited, Map<Location, ? extends EnergyComponent<?>> originalComponents) {
        Set subNetwork = new HashSet();
        Queue queue = new LinkedList();
        queue.add(startBlock);
        while (!queue.isEmpty()) {
            Location current = (Location)queue.poll();
            if (visited.contains(current)) continue;
            Intrinsics.checkNotNull(current);
            visited.add(current);
            EnergyComponent<?> component = originalComponents.get(current);
            if (component != null) {
                subNetwork.add(new AbstractMap.SimpleEntry(current, component));
            }
            for (BlockFace face : NEIGHBORS) {
                Location neighbor;
                Intrinsics.checkNotNullExpressionValue(current.getBlock().getRelative(face).getLocation(), "getLocation(...)");
                if (!this.isBlockComponent(neighbor) || visited.contains(neighbor)) continue;
                queue.add(neighbor);
            }
        }
        return subNetwork;
    }

    private final <P, C> Optional<C> getPersistentData(ItemStack item, NamespacedKey key, PersistentDataType<P, C> type) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            Optional optional = Optional.empty();
            Intrinsics.checkNotNull(optional, "null cannot be cast to non-null type java.util.Optional<C of io.github.Jadiefication.redstoneflux.EnergyManagerImpl.getPersistentData?>");
            return optional;
        }
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        Optional<Object> optional = Optional.ofNullable(persistentDataContainer2.get(key, type));
        Intrinsics.checkNotNull(optional, "null cannot be cast to non-null type java.util.Optional<C of io.github.Jadiefication.redstoneflux.EnergyManagerImpl.getPersistentData?>");
        return optional;
    }

    private final Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)EnergyType.class), (Object)new EnergyTypeAdapter());
        Intrinsics.checkNotNullExpressionValue(gsonBuilder, "registerTypeAdapter(...)");
        GsonBuilder builder = gsonBuilder;
        Gson gson = builder.create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        Gson temp = gson;
        builder.registerTypeAdapter((Type)((Object)EnergyComponent.class), (Object)new EnergyComponentAdapter(temp));
        Gson gson2 = builder.create();
        Intrinsics.checkNotNullExpressionValue(gson2, "create(...)");
        Gson temp2 = gson2;
        builder.registerTypeAdapter((Type)((Object)EnergyNetwork.class), (Object)new EnergyNetworkAdapter(this.api, temp2));
        Gson gson3 = builder.create();
        Intrinsics.checkNotNullExpressionValue(gson3, "create(...)");
        return gson3;
    }

    private static final boolean placeComponent$lambda$0(Block $neighbor, EnergyNetwork network) {
        boolean bl;
        EnergyNetwork energyNetwork = network;
        if (energyNetwork != null) {
            Location location = $neighbor.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            bl = energyNetwork.contains(location);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean placeComponent$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean placeComponent$lambda$2(EnergyComponent $component, EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        return (energyNetwork != null ? energyNetwork.getEnergyType() : null) == $component.getEnergyType();
    }

    private static final boolean placeComponent$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean breakComponent$lambda$4(Location $location, EnergyNetwork n) {
        return n.contains($location);
    }

    private static final boolean breakComponent$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isBlockComponent$lambda$7(Location $location, EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        return energyNetwork != null ? energyNetwork.contains($location) : false;
    }

    private static final boolean isBlockComponent$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final IllegalArgumentException createItemComponent$lambda$10(EnergyComponent $mechanic) {
        return new IllegalArgumentException("Item not found for mechanic " + $mechanic.getClass());
    }

    private static final void saveNetworks$lambda$13(EnergyNetwork obj) {
        block0: {
            EnergyNetwork energyNetwork = obj;
            if (energyNetwork == null) break block0;
            energyNetwork.save();
        }
    }

    private static final boolean loadNetworks$lambda$14(EnergyNetwork $network, EnergyNetwork n) {
        EnergyNetwork energyNetwork = n;
        return Intrinsics.areEqual(energyNetwork != null ? energyNetwork.getId() : null, $network.getId());
    }

    private static final boolean loadNetworks$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getComponentFromBlock$lambda$16(Location $location, EnergyNetwork network) {
        EnergyNetwork energyNetwork = network;
        return energyNetwork != null ? energyNetwork.contains($location) : false;
    }

    private static final boolean getComponentFromBlock$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final EnergyComponent getComponentFromBlock$lambda$18(Location $location, EnergyNetwork energyNetwork) {
        Object object = energyNetwork;
        return object != null && (object = ((EnergyNetwork)object).getComponents()) != null ? (EnergyComponent)object.get($location) : null;
    }

    private static final boolean cleanUpNetworks$lambda$19(EnergyNetwork it) {
        boolean bl;
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getComponents().isEmpty()) {
            it.delete();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean cleanUpNetworks$lambda$20(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$splitNetworkIfNecessary(EnergyManagerImpl $this, EnergyNetwork network, Map originalComponents, Continuation $completion) {
        return $this.splitNetworkIfNecessary(network, originalComponents, $completion);
    }

    public static final /* synthetic */ void access$asyncNetworkSplit(EnergyManagerImpl $this, Set visited, Location component, List newNetworks, Map originalComponents) {
        $this.asyncNetworkSplit(visited, component, newNetworks, originalComponents);
    }

    static {
        BlockFace[] blockFaceArray = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
        NEIGHBORS = CollectionsKt.listOf(blockFaceArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/Jadiefication/redstoneflux/EnergyManagerImpl$Companion;", "", "<init>", "()V", "NEIGHBORS", "", "Lorg/bukkit/block/BlockFace;", "RedstoneFlux"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

