/*
 * Decompiled with CFR 0.152.
 */
package io.github.Jadiefication.redstoneflux.api.components;

import com.google.gson.Gson;
import io.github.Jadiefication.redstoneflux.api.EnergyAPI;
import io.github.Jadiefication.redstoneflux.api.EnergyManager;
import io.github.Jadiefication.redstoneflux.api.components.EnergyComponent;
import io.github.Jadiefication.redstoneflux.api.components.EnergyNetwork;
import io.github.Jadiefication.redstoneflux.api.event.EnergyConsumeEvent;
import io.github.Jadiefication.redstoneflux.api.event.EnergyProduceEvent;
import io.github.Jadiefication.redstoneflux.api.event.NotEnoughEnergyEvent;
import io.github.Jadiefication.redstoneflux.api.event.StoreEnergyEvent;
import io.github.Jadiefication.redstoneflux.api.exceptions.SameEnergyTypeException;
import io.github.Jadiefication.redstoneflux.api.items.ItemsFactory;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyConsumer;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyMechanic;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyProducer;
import io.github.Jadiefication.redstoneflux.api.mechanics.EnergyStorage;
import io.github.Jadiefication.redstoneflux.api.types.EnergyType;
import io.github.Jadiefication.redstoneflux.api.types.MechanicType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u001a\u0010\u001f\u001a\u00020 2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010!\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)H\u0082@\u00a2\u0006\u0002\u0010'J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020 0)H\u0082@\u00a2\u0006\u0002\u0010'J\u0014\u0010+\u001a\u00020 2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\tH\u0003J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020 0)H\u0082@\u00a2\u0006\u0002\u0010'J\u0014\u0010.\u001a\u00020 2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\tH\u0003J\u000e\u00102\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u00103\u001a\u00020 J\u0006\u00104\u001a\u00020 J\u0018\u00109\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u0010H\u0002J&\u0010>\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0?2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010@\u001a\u00020AH\u0002JB\u0010B\u001a\u00020 2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0012\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0D2\u0010\u0010E\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0?2\u0006\u0010@\u001a\u00020AH\u0002J \u0010F\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00162\u0006\u0010@\u001a\u00020AH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u00100\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0013\u00105\u001a\u0004\u0018\u0001068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001a\u0010;\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006G"}, d2={"Lio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork;", "", "api", "Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;", "id", "Ljava/util/UUID;", "<init>", "(Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;Ljava/util/UUID;)V", "component", "Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;", "location", "Lorg/bukkit/Location;", "(Lio/github/Jadiefication/redstoneflux/api/EnergyAPI;Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;Lorg/bukkit/Location;)V", "getId", "()Ljava/util/UUID;", "chunk", "Lorg/bukkit/Chunk;", "getChunk", "()Lorg/bukkit/Chunk;", "setChunk", "(Lorg/bukkit/Chunk;)V", "components", "", "getComponents", "()Ljava/util/Map;", "networkKey", "Lorg/bukkit/NamespacedKey;", "getNetworkKey", "()Lorg/bukkit/NamespacedKey;", "setNetworkKey", "(Lorg/bukkit/NamespacedKey;)V", "addComponent", "", "removeComponent", "contains", "", "mergeWith", "network", "update", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleProduction", "", "handleExcess", "asyncExcessEnergy", "producerC", "handleConsumers", "asyncConsumerUpdate", "consumerComponent", "isEmpty", "()Z", "isInChunk", "save", "delete", "energyType", "Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;", "getEnergyType", "()Lio/github/Jadiefication/redstoneflux/api/types/EnergyType;", "isSameChunk", "chunk1", "root", "getRoot", "()Lio/github/Jadiefication/redstoneflux/api/components/EnergyComponent;", "getConnectedComponents", "", "type", "Lio/github/Jadiefication/redstoneflux/api/types/MechanicType;", "dfsConnectedComponents", "visited", "", "connectedComponents", "getComponentByType", "FluxAPI"})
@SourceDebugExtension(value={"SMAP\nEnergyNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyNetwork.kt\nio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,468:1\n216#2,2:469\n216#2,2:471\n216#2,2:473\n*S KotlinDebug\n*F\n+ 1 EnergyNetwork.kt\nio/github/Jadiefication/redstoneflux/api/components/EnergyNetwork\n*L\n149#1:469,2\n168#1:471,2\n216#1:473,2\n*E\n"})
public final class EnergyNetwork {
    @NotNull
    private final EnergyAPI api;
    @Nullable
    private final UUID id;
    public Chunk chunk;
    @NotNull
    private final Map<Location, EnergyComponent<?>> components;
    @NotNull
    private NamespacedKey networkKey;

    public EnergyNetwork(@NotNull EnergyAPI api, @Nullable UUID id) {
        Intrinsics.checkNotNullParameter(api, "api");
        this.api = api;
        this.id = id;
        this.components = new ConcurrentHashMap();
        this.networkKey = ItemsFactory.INSTANCE.getNetworkKey();
    }

    @Nullable
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final Chunk getChunk() {
        Chunk chunk = this.chunk;
        if (chunk != null) {
            return chunk;
        }
        Intrinsics.throwUninitializedPropertyAccessException("chunk");
        return null;
    }

    public final void setChunk(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "<set-?>");
        this.chunk = chunk;
    }

    @NotNull
    public final Map<Location, EnergyComponent<?>> getComponents() {
        return this.components;
    }

    @NotNull
    public final NamespacedKey getNetworkKey() {
        return this.networkKey;
    }

    public final void setNetworkKey(@NotNull NamespacedKey namespacedKey) {
        Intrinsics.checkNotNullParameter(namespacedKey, "<set-?>");
        this.networkKey = namespacedKey;
    }

    public EnergyNetwork(@NotNull EnergyAPI api, @NotNull EnergyComponent<?> component, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(api, "api");
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(location, "location");
        this(api, UUID.randomUUID());
        this.components.put(location, component);
        Chunk chunk = location.getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        this.setChunk(chunk);
    }

    public final void addComponent(@NotNull EnergyComponent<?> component, @NotNull Location location) throws SameEnergyTypeException {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(location, "location");
        for (Map.Entry entry : this.components.entrySet().stream().filter(arg_0 -> EnergyNetwork.addComponent$lambda$1(arg_0 -> EnergyNetwork.addComponent$lambda$0(location, arg_0), arg_0)).toList()) {
            ((EnergyComponent)entry.getValue()).connect$FluxAPI(component);
        }
        if (this.chunk == null) {
            Chunk chunk = location.getChunk();
            Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
            this.setChunk(chunk);
        }
        this.components.put(location, component);
    }

    public final void removeComponent(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.components.entrySet().stream().filter(arg_0 -> EnergyNetwork.removeComponent$lambda$3(arg_0 -> EnergyNetwork.removeComponent$lambda$2(location, arg_0), arg_0)).forEach(arg_0 -> EnergyNetwork.removeComponent$lambda$5(arg_0 -> EnergyNetwork.removeComponent$lambda$4(this, location, arg_0), arg_0));
        this.components.remove(location);
    }

    public final boolean contains(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.components.containsKey(location);
    }

    public final void mergeWith(@NotNull EnergyNetwork network) {
        Intrinsics.checkNotNullParameter(network, "network");
        this.components.putAll(network.components);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object update(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof update.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ EnergyNetwork this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.update(this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.label = 1;
                v0 = this.handleProduction($continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl20:
                // 2 sources

                $continuation.label = 2;
                v1 = this.handleConsumers($continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl28
            }
            case 2: {
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl28:
                // 2 sources

                $continuation.label = 3;
                v2 = this.handleExcess($continuation);
                if (v2 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl36
            }
            case 3: {
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl36:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object handleProduction(Continuation<? super List<Unit>> $completion) {
        Map<Location, EnergyComponent<?>> producers = this.getComponentByType(MechanicType.PRODUCER);
        List defers = new ArrayList();
        Map<Location, EnergyComponent<?>> $this$forEach$iv = producers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Location, EnergyComponent<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Location, EnergyComponent<?>> element$iv;
            Map.Entry<Location, EnergyComponent<?>> entry = element$iv = iterator2.next();
            boolean bl = false;
            Location location = entry.getKey();
            EnergyComponent<?> producer = entry.getValue();
            Deferred defer2 = BuildersKt.async$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(producer, location, null){
                int label;
                final /* synthetic */ EnergyComponent<?> $producer;
                final /* synthetic */ Location $location;
                {
                    this.$producer = $producer;
                    this.$location = $location;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            ? obj = this.$producer.getMechanic();
                            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.EnergyProducer");
                            double d = ((EnergyProducer)obj).produce(this.$location);
                            EnergyComponent<EnergyProducer> energyComponent = this.$producer;
                            Intrinsics.checkNotNull(energyComponent, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.components.EnergyComponent<io.github.Jadiefication.redstoneflux.api.mechanics.EnergyProducer>");
                            EnergyProduceEvent produceEvent = new EnergyProduceEvent(d, energyComponent);
                            Bukkit.getServer().getPluginManager().callEvent((Event)produceEvent);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            defers.add(defer2);
        }
        return AwaitKt.awaitAll(defers, $completion);
    }

    private final Object handleExcess(Continuation<? super List<Unit>> $completion) {
        Map<Location, EnergyComponent<?>> producers = this.getComponentByType(MechanicType.PRODUCER);
        List defers = new ArrayList();
        Map<Location, EnergyComponent<?>> $this$forEach$iv = producers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Location, EnergyComponent<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Location, EnergyComponent<?>> element$iv;
            Map.Entry<Location, EnergyComponent<?>> entry = element$iv = iterator2.next();
            boolean bl = false;
            Location location = entry.getKey();
            EnergyComponent<?> producer = entry.getValue();
            Deferred defer2 = BuildersKt.async$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, producer, null){
                int label;
                final /* synthetic */ EnergyNetwork this$0;
                final /* synthetic */ EnergyComponent<?> $producer;
                {
                    this.this$0 = $receiver;
                    this.$producer = $producer;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            EnergyNetwork.access$asyncExcessEnergy(this.this$0, this.$producer);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            defers.add(defer2);
        }
        return AwaitKt.awaitAll(defers, $completion);
    }

    @ApiStatus.Internal
    private final void asyncExcessEnergy(EnergyComponent<?> producerC) {
        EnergyProducer energyProducer = producerC.getMechanic();
        Intrinsics.checkNotNull(energyProducer, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.EnergyProducer");
        EnergyProducer producer = energyProducer;
        double excessEnergy = producer.getExcessEnergy();
        if (excessEnergy > 0.0) {
            List<EnergyComponent<?>> connectedStorages = this.getConnectedComponents(producerC, MechanicType.STORAGE);
            for (EnergyComponent<EnergyStorage> energyComponent : connectedStorages) {
                Object obj = energyComponent.getMechanic();
                Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.EnergyStorage");
                EnergyStorage storage = (EnergyStorage)obj;
                double energyStored = storage.storeEnergy(excessEnergy);
                Intrinsics.checkNotNull(energyComponent, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.components.EnergyComponent<io.github.Jadiefication.redstoneflux.api.mechanics.EnergyStorage>");
                Intrinsics.checkNotNull(producerC, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.components.EnergyComponent<io.github.Jadiefication.redstoneflux.api.mechanics.EnergyProducer>");
                StoreEnergyEvent storeEvent = new StoreEnergyEvent(energyStored, energyComponent, producerC);
                Bukkit.getServer().getPluginManager().callEvent((Event)storeEvent);
                if (!((excessEnergy -= energyStored) <= 0.0)) continue;
            }
        }
        if (excessEnergy > 0.0 && this.api.isDebug()) {
            System.out.println((Object)("The excess energy from the producer " + producerC + " is lost."));
        }
    }

    private final Object handleConsumers(Continuation<? super List<Unit>> $completion) {
        Map<Location, EnergyComponent<?>> consumers = this.getComponentByType(MechanicType.CONSUMER);
        List defers = new ArrayList();
        Map<Location, EnergyComponent<?>> $this$forEach$iv = consumers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Location, EnergyComponent<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Location, EnergyComponent<?>> element$iv;
            Map.Entry<Location, EnergyComponent<?>> entry = element$iv = iterator2.next();
            boolean bl = false;
            Location location = entry.getKey();
            EnergyComponent<?> consumerComponent = entry.getValue();
            Deferred future2 = BuildersKt.async$default(this.api.getScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, consumerComponent, null){
                int label;
                final /* synthetic */ EnergyNetwork this$0;
                final /* synthetic */ EnergyComponent<?> $consumerComponent;
                {
                    this.this$0 = $receiver;
                    this.$consumerComponent = $consumerComponent;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            EnergyNetwork.access$asyncConsumerUpdate(this.this$0, this.$consumerComponent);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            defers.add(future2);
        }
        return AwaitKt.awaitAll(defers, $completion);
    }

    @ApiStatus.Internal
    private final void asyncConsumerUpdate(EnergyComponent<?> consumerComponent) {
        Object obj = consumerComponent.getMechanic();
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.EnergyConsumer");
        EnergyConsumer consumer = (EnergyConsumer)obj;
        double requiredEnergy = consumer.getEnergyDemand();
        double providedEnergy = 0.0;
        List<EnergyComponent<?>> connectedProducers = this.getConnectedComponents(consumerComponent, MechanicType.PRODUCER);
        for (EnergyComponent<?> producerComponent : connectedProducers) {
            Object obj2 = producerComponent.getMechanic();
            Intrinsics.checkNotNull(obj2, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.EnergyProducer");
            EnergyProducer producer = (EnergyProducer)obj2;
            double energyAvailable = producer.extractEnergy(requiredEnergy);
            Intrinsics.checkNotNull(consumerComponent, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.components.EnergyComponent<io.github.Jadiefication.redstoneflux.api.mechanics.EnergyConsumer>");
            EnergyConsumeEvent produceEvent = new EnergyConsumeEvent(energyAvailable, producerComponent, consumerComponent);
            Bukkit.getServer().getPluginManager().callEvent((Event)produceEvent);
            requiredEnergy -= energyAvailable;
            providedEnergy += energyAvailable;
            if (!(requiredEnergy <= 0.0)) continue;
        }
        if (requiredEnergy > 0.0) {
            List<EnergyComponent<?>> connectedStorages = this.getConnectedComponents(consumerComponent, MechanicType.STORAGE);
            for (EnergyComponent<?> storageComponent : connectedStorages) {
                Object obj3 = storageComponent.getMechanic();
                Intrinsics.checkNotNull(obj3, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.mechanics.EnergyStorage");
                EnergyStorage storage = (EnergyStorage)obj3;
                double energyFromStorage = storage.consumeEnergy(requiredEnergy);
                Intrinsics.checkNotNull(consumerComponent, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.components.EnergyComponent<io.github.Jadiefication.redstoneflux.api.mechanics.EnergyConsumer>");
                EnergyConsumeEvent produceEvent = new EnergyConsumeEvent(energyFromStorage, storageComponent, consumerComponent);
                Bukkit.getServer().getPluginManager().callEvent((Event)produceEvent);
                requiredEnergy -= energyFromStorage;
                providedEnergy += energyFromStorage;
                if (!(requiredEnergy <= 0.0)) continue;
            }
        }
        consumer.receiveEnergy(providedEnergy);
        if (requiredEnergy > 0.0) {
            Intrinsics.checkNotNull(consumerComponent, "null cannot be cast to non-null type io.github.Jadiefication.redstoneflux.api.components.EnergyComponent<io.github.Jadiefication.redstoneflux.api.mechanics.EnergyConsumer>");
            NotEnoughEnergyEvent notEnoughEnergyEvent = new NotEnoughEnergyEvent(requiredEnergy, providedEnergy, consumerComponent);
            Bukkit.getServer().getPluginManager().callEvent((Event)notEnoughEnergyEvent);
            if (this.api.isDebug()) {
                System.out.println((Object)("The consumer " + consumerComponent + " did not receive enough energy."));
            }
            consumer.setEnable(false);
        } else {
            consumer.setEnable(true);
        }
    }

    public final boolean isEmpty() {
        return this.components.isEmpty();
    }

    public final boolean isInChunk(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        return this.components.keySet().stream().anyMatch(arg_0 -> EnergyNetwork.isInChunk$lambda$10(arg_0 -> EnergyNetwork.isInChunk$lambda$9(this, chunk, arg_0), arg_0));
    }

    public final void save() {
        EnergyManager energyManager = this.api.getManager();
        Intrinsics.checkNotNull(energyManager);
        EnergyManager manager = energyManager;
        PersistentDataContainer container = null;
        try {
            PersistentDataContainer persistentDataContainer = this.getChunk().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            container = persistentDataContainer;
        }
        catch (Exception exception) {
            this.delete();
            return;
        }
        Gson gson = manager.getGson();
        String json = gson.toJson((Object)this, (Type)((Object)EnergyNetwork.class));
        List networks = (List)container.getOrDefault(this.networkKey, (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), new ArrayList());
        networks = new ArrayList(networks);
        ((ArrayList)networks).removeIf(arg_0 -> EnergyNetwork.save$lambda$12(arg_0 -> EnergyNetwork.save$lambda$11(gson, this, arg_0), arg_0));
        ((ArrayList)networks).add(json);
        container.set(this.networkKey, (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)networks);
    }

    public final void delete() {
        PersistentDataContainer container = null;
        try {
            PersistentDataContainer persistentDataContainer = this.getChunk().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            container = persistentDataContainer;
        }
        catch (Exception exception) {
            Object object = this.api.getManager();
            if (object != null && (object = object.getNetworks()) != null) {
                object.remove(this);
            }
            return;
        }
        Object object = container.getOrDefault(this.networkKey, (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)new ArrayList());
        Intrinsics.checkNotNullExpressionValue(object, "getOrDefault(...)");
        List networks = (List)object;
        networks = new ArrayList(networks);
        ((ArrayList)networks).removeIf(arg_0 -> EnergyNetwork.delete$lambda$14(arg_0 -> EnergyNetwork.delete$lambda$13(this, arg_0), arg_0));
        container.set(this.networkKey, (PersistentDataType)PersistentDataType.LIST.listTypeFrom(PersistentDataType.STRING), (Object)networks);
    }

    @Nullable
    public final EnergyType getEnergyType() {
        EnergyComponent<?> energyComponent = this.getRoot();
        Intrinsics.checkNotNull(energyComponent);
        return energyComponent.getEnergyType();
    }

    private final boolean isSameChunk(Chunk chunk, Chunk chunk1) {
        return chunk.getX() == chunk1.getX() && chunk.getZ() == chunk1.getZ() && Intrinsics.areEqual(chunk.getWorld().getName(), chunk1.getWorld().getName());
    }

    private final EnergyComponent<?> getRoot() {
        return (EnergyComponent)CollectionsKt.firstOrNull((Iterable)this.components.values());
    }

    private final List<EnergyComponent<?>> getConnectedComponents(EnergyComponent<?> component, MechanicType type) {
        Set visited = new HashSet();
        List connectedComponents = new ArrayList();
        this.dfsConnectedComponents(component, visited, connectedComponents, type);
        return connectedComponents;
    }

    private final void dfsConnectedComponents(EnergyComponent<?> component, Set<EnergyComponent<?>> visited, List<EnergyComponent<?>> connectedComponents, MechanicType type) {
        if (visited.contains(component)) {
            return;
        }
        visited.add(component);
        if (type.isInstance(component)) {
            connectedComponents.add(component);
        }
        for (EnergyComponent<?> neighbor : component.getConnectedComponents$FluxAPI()) {
            if (visited.contains(neighbor)) continue;
            EnergyComponent<?> energyComponent = neighbor;
            Intrinsics.checkNotNull(energyComponent);
            if (!MechanicType.TRANSPORTER.isInstance(energyComponent) && !type.isInstance(neighbor)) continue;
            this.dfsConnectedComponents(neighbor, visited, connectedComponents, type);
        }
    }

    private final Map<Location, EnergyComponent<?>> getComponentByType(MechanicType type) {
        Map<Location, EnergyComponent<?>> map2 = this.components.entrySet().stream().filter(arg_0 -> EnergyNetwork.getComponentByType$lambda$16(arg_0 -> EnergyNetwork.getComponentByType$lambda$15(type, arg_0), arg_0)).collect(Collectors.toMap(arg_0 -> EnergyNetwork.getComponentByType$lambda$18(EnergyNetwork::getComponentByType$lambda$17, arg_0), arg_0 -> EnergyNetwork.getComponentByType$lambda$20(EnergyNetwork::getComponentByType$lambda$19, arg_0)));
        Intrinsics.checkNotNullExpressionValue(map2, "collect(...)");
        return map2;
    }

    private static final boolean addComponent$lambda$0(Location $location, Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        return ((Location)entry.getKey()).distance($location) == 1.0;
    }

    private static final boolean addComponent$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeComponent$lambda$2(Location $location, Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        return ((Location)entry.getKey()).distance($location) == 1.0;
    }

    private static final boolean removeComponent$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit removeComponent$lambda$4(EnergyNetwork this$0, Location $location, Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        EnergyComponent energyComponent = (EnergyComponent)entry.getValue();
        EnergyComponent<?> energyComponent2 = this$0.components.get($location);
        Intrinsics.checkNotNull(energyComponent2);
        energyComponent.disconnect$FluxAPI(energyComponent2);
        return Unit.INSTANCE;
    }

    private static final void removeComponent$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean isInChunk$lambda$9(EnergyNetwork this$0, Chunk $chunk, Location location) {
        Location location2 = location;
        Intrinsics.checkNotNull(location2);
        Chunk chunk = location2.getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        return this$0.isSameChunk($chunk, chunk);
    }

    private static final boolean isInChunk$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean save$lambda$11(Gson $gson, EnergyNetwork this$0, String network) {
        EnergyNetwork energyNetwork;
        EnergyNetwork energyNetwork2 = energyNetwork = (EnergyNetwork)$gson.fromJson(network, EnergyNetwork.class);
        return Intrinsics.areEqual(energyNetwork2 != null ? energyNetwork2.id : null, this$0.id);
    }

    private static final boolean save$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean delete$lambda$13(EnergyNetwork this$0, String json) {
        EnergyNetwork network;
        EnergyManager energyManager = this$0.api.getManager();
        Intrinsics.checkNotNull(energyManager);
        EnergyNetwork energyNetwork = network = (EnergyNetwork)energyManager.getGson().fromJson(json, EnergyNetwork.class);
        return Intrinsics.areEqual(energyNetwork != null ? energyNetwork.id : null, this$0.id);
    }

    private static final boolean delete$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getComponentByType$lambda$15(MechanicType $type, Map.Entry entry) {
        Class<? extends EnergyMechanic> clazz = $type.getClazz();
        Map.Entry entry2 = entry;
        Intrinsics.checkNotNull(entry2);
        Object t = ((EnergyComponent)entry2.getValue()).getMechanic();
        Intrinsics.checkNotNull(t);
        return clazz.isAssignableFrom(t.getClass());
    }

    private static final boolean getComponentByType$lambda$16(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Location getComponentByType$lambda$17(Map.Entry it) {
        return (Location)it.getKey();
    }

    private static final Location getComponentByType$lambda$18(Function1 $tmp0, Object p0) {
        return (Location)$tmp0.invoke(p0);
    }

    private static final EnergyComponent getComponentByType$lambda$19(Map.Entry it) {
        return (EnergyComponent)it.getValue();
    }

    private static final EnergyComponent getComponentByType$lambda$20(Function1 $tmp0, Object p0) {
        return (EnergyComponent)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$handleProduction(EnergyNetwork $this, Continuation $completion) {
        return $this.handleProduction($completion);
    }

    public static final /* synthetic */ Object access$handleExcess(EnergyNetwork $this, Continuation $completion) {
        return $this.handleExcess($completion);
    }

    public static final /* synthetic */ Object access$handleConsumers(EnergyNetwork $this, Continuation $completion) {
        return $this.handleConsumers($completion);
    }

    public static final /* synthetic */ void access$asyncExcessEnergy(EnergyNetwork $this, EnergyComponent producerC) {
        $this.asyncExcessEnergy(producerC);
    }

    public static final /* synthetic */ void access$asyncConsumerUpdate(EnergyNetwork $this, EnergyComponent consumerComponent) {
        $this.asyncConsumerUpdate(consumerComponent);
    }
}

