/*
 * Decompiled with CFR 0.152.
 */
package com.luis.flightwings.items.custom;

import com.luis.flightwings.config.ServerConfig;
import com.luis.flightwings.items.ModItems;
import com.luis.flightwings.util.Flight;
import com.luis.flightwings.util.InventoryUtil;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlightWingGold
extends Item {
    public FlightWingGold(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponent, @NotNull TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponent.add((Component)new TranslatableComponent("tooltip.flight_wings_gold.shift.down.1"));
            pTooltipComponent.add((Component)new TranslatableComponent("tooltip.flight_wings_gold.shift.down.2"));
            if (((Boolean)ServerConfig.WINGS_EFFECT.get()).booleanValue()) {
                if (((Boolean)ServerConfig.WINGS_EFFECT_CONSUME_XP.get()).booleanValue()) {
                    pTooltipComponent.add((Component)new TranslatableComponent("tooltip.flight_wings_gold.shift.down.special", new Object[]{ServerConfig.WINGS_EFFECT_USE_XP.get()}));
                } else {
                    pTooltipComponent.add((Component)new TranslatableComponent("tooltip.flight_wings_gold.shift.down.special.no_cost"));
                }
            }
        } else {
            pTooltipComponent.add((Component)new TranslatableComponent("tooltip.flight_wings_gold.shift"));
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Flight.StopFlight(player);
        }
        if (stack.m_41782_()) {
            CompoundTag data = new CompoundTag();
            data.m_128379_("flightwings.isActive", false);
            stack.m_41751_(data);
        }
        return super.onEntitySwing(this.m_7968_(), entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (player.m_6047_()) {
            if (!level.m_5776_() && interactionHand == InteractionHand.MAIN_HAND && ((Boolean)ServerConfig.WINGS_EFFECT.get()).booleanValue()) {
                if (((Boolean)ServerConfig.WINGS_EFFECT_CONSUME_XP.get()).booleanValue()) {
                    if (player.f_36078_ >= (Integer)ServerConfig.WINGS_EFFECT_USE_XP.get()) {
                        player.m_6749_(-((Integer)ServerConfig.WINGS_EFFECT_USE_XP.get()).intValue());
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, (Integer)ServerConfig.WINGS_EFFECT_DURATION.get() * 20, (Integer)ServerConfig.WINGS_EFFECT_AMPLIFIER.get() - 1));
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, (Integer)ServerConfig.WINGS_EFFECT_DURATION.get() * 20, (Integer)ServerConfig.WINGS_EFFECT_AMPLIFIER.get() - 1));
                    } else {
                        ((ServerPlayer)player).m_9146_((Component)new TranslatableComponent("message.flight_wing_gold.not_enough_xp"), ChatType.GAME_INFO, player.m_142081_());
                    }
                } else {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, (Integer)ServerConfig.WINGS_EFFECT_DURATION.get() * 20, (Integer)ServerConfig.WINGS_EFFECT_AMPLIFIER.get() - 1));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, (Integer)ServerConfig.WINGS_EFFECT_DURATION.get() * 20, (Integer)ServerConfig.WINGS_EFFECT_AMPLIFIER.get() - 1));
                }
            }
        } else if (!level.m_5776_() && interactionHand == InteractionHand.MAIN_HAND) {
            int itemAmount = InventoryUtil.itemAmount(player, (Item)ModItems.FLIGHT_WING_GOLD.get());
            boolean hasItem = itemAmount > 0;
            ItemStack stack = hasItem ? player.m_150109_().m_8020_(InventoryUtil.getFirstInventoryIndex(player, (Item)ModItems.FLIGHT_WING_GOLD.get())) : player.m_21120_(interactionHand);
            boolean isActive = stack.m_41782_() ? !stack.m_41783_().m_128471_("flightwings.isActive") : true;
            CompoundTag data = new CompoundTag();
            data.m_128379_("flightwings.isActive", isActive);
            stack.m_41751_(data);
            if (isActive) {
                Flight.StartFlight(player);
            } else {
                Flight.StopFlight(player);
            }
            player.m_36335_().m_41524_((Item)this, 10);
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public boolean m_5812_(ItemStack stack) {
        boolean isActive = stack.m_41782_() ? stack.m_41783_().m_128471_("flightwings.isActive") : false;
        return isActive;
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        CompoundTag data = new CompoundTag();
        data.m_128379_("flightwings.isActive", false);
        stack.m_41751_(data);
        Flight.StopFlight(player);
        return super.onDroppedByPlayer(stack, player);
    }
}

