/*
 * Decompiled with CFR 0.152.
 */
package me.noramibu.config;

import com.moandjiezana.toml.Toml;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import me.noramibu.BetterDoors;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static Toml toml = new Toml();
    public static boolean knockingRequiresEmptyHand;
    public static boolean knockingRequiresShift;
    public static boolean requirePermissionToKnock;
    public static boolean allowKnockingWoodenDoors;
    public static boolean allowKnockingIronDoors;
    public static boolean allowKnockingCopperDoors;
    public static boolean allowKnockingWoodenTrapdoors;
    public static boolean allowKnockingIronTrapdoors;
    public static boolean allowKnockingCopperTrapdoors;
    public static String soundKnockIron;
    public static String soundKnockWood;
    public static String soundKnockCopper;
    public static double soundKnockVolume;
    public static double soundKnockPitch;
    public static boolean allowDoubleWoodenDoors;
    public static boolean allowDoubleIronDoors;
    public static boolean allowDoubleCopperDoors;
    public static boolean checkForRedstone;
    public static boolean requirePermissionForDoubleDoors;

    public static void load() {
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("better-doors.toml");
            if (!Files.exists(configPath, new LinkOption[0])) {
                FabricLoader.getInstance().getModContainer("better-doors").flatMap(container -> container.findPath("better-doors.toml")).ifPresent(path -> {
                    try {
                        Files.copy(path, configPath, new CopyOption[0]);
                    }
                    catch (IOException e) {
                        BetterDoors.LOGGER.error("Failed to copy default config", (Throwable)e);
                    }
                });
            }
            toml = new Toml().read(configPath.toFile());
        }
        catch (Exception e) {
            BetterDoors.LOGGER.error("Failed to load config", (Throwable)e);
            toml = new Toml();
        }
        knockingRequiresEmptyHand = toml.getBoolean("knocking-requires-empty-hand", Boolean.valueOf(true));
        knockingRequiresShift = toml.getBoolean("knocking-requires-shift", Boolean.valueOf(false));
        requirePermissionToKnock = toml.getBoolean("require-permission-to-knock", Boolean.valueOf(false));
        allowKnockingWoodenDoors = toml.getBoolean("allow-knocking-wooden-doors", Boolean.valueOf(true));
        allowKnockingIronDoors = toml.getBoolean("allow-knocking-iron-doors", Boolean.valueOf(true));
        allowKnockingCopperDoors = toml.getBoolean("allow-knocking-copper-doors", Boolean.valueOf(true));
        allowKnockingWoodenTrapdoors = toml.getBoolean("allow-knocking-wooden-trapdoors", Boolean.valueOf(true));
        allowKnockingIronTrapdoors = toml.getBoolean("allow-knocking-iron-trapdoors", Boolean.valueOf(true));
        allowKnockingCopperTrapdoors = toml.getBoolean("allow-knocking-copper-trapdoors", Boolean.valueOf(true));
        soundKnockIron = toml.getString("sound-knock-iron", "minecraft:entity.zombie.attack_iron_door");
        soundKnockWood = toml.getString("sound-knock-wood", "minecraft:item.shield.block");
        soundKnockCopper = toml.getString("sound-knock-copper", "minecraft:block.copper.step");
        soundKnockVolume = toml.getDouble("sound-knock-volume", Double.valueOf(1.0));
        soundKnockPitch = toml.getDouble("sound-knock-pitch", Double.valueOf(1.0));
        allowDoubleWoodenDoors = toml.getBoolean("allow-double-wooden-doors", Boolean.valueOf(true));
        allowDoubleIronDoors = toml.getBoolean("allow-double-iron-doors", Boolean.valueOf(false));
        allowDoubleCopperDoors = toml.getBoolean("allow-double-copper-doors", Boolean.valueOf(true));
        checkForRedstone = toml.getBoolean("check-for-redstone", Boolean.valueOf(true));
        requirePermissionForDoubleDoors = toml.getBoolean("require-permission-for-double-doors", Boolean.valueOf(false));
    }
}

