/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin;

import name.modid.CombatCooldownManager;
import name.modid.CombatTag;
import name.modid.Config;
import name.modid.access.ServerPlayerEntityAccess;
import name.modid.events.PlayerAttackCallback;
import name.modid.events.PlayerDamageCallback;
import name.modid.events.PlayerDeathCallback;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
implements ServerPlayerEntityAccess {
    @Unique
    private static final String COMBAT_TAG_KEY = "CombatTag";
    @Unique
    private static final String COMBAT_TAG_TICKS_KEY = "CombatTagTicks";
    @Unique
    private boolean combat = false;
    @Unique
    private int ticksSinceCombat = 0;

    @Override
    @Unique
    public boolean combat_tag$inCombat() {
        return this.combat;
    }

    @Override
    @Unique
    public void combat_tag$setCombat(boolean combat) {
        this.combat = combat;
        this.ticksSinceCombat = 0;
    }

    @Override
    @Unique
    public float combat_tag$getProgress() {
        return ((float)Config.COMBAT_DURATION - (float)this.ticksSinceCombat) / (float)Config.COMBAT_DURATION;
    }

    @Inject(method={"method_14231()V"}, at={@At(value="HEAD")})
    public void onDisconnect(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        MinecraftServer server = player.method_51469().method_8503();
        if (this.combat && server != null && !server.method_16043() && !server.method_39219() && !server.method_54809()) {
            CombatTag.logoutPunish(player);
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        if (this.combat) {
            ++this.ticksSinceCombat;
            if (this.ticksSinceCombat >= Config.COMBAT_DURATION) {
                CombatTag.removeCombatTag((class_3222)this);
            }
        }
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="RETURN")})
    private void onDamage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = (class_3222)this;
        ((PlayerDamageCallback)PlayerDamageCallback.EVENT.invoker()).onPlayerDamaged(player, source);
    }

    @Inject(method={"method_6078(Lnet/minecraft/class_1282;)V"}, at={@At(value="RETURN")})
    private void onDeath(class_1282 source, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        ((PlayerDeathCallback)PlayerDeathCallback.EVENT.invoker()).onPlayerDeath(player, source);
    }

    @Inject(method={"method_7324(Lnet/minecraft/class_1297;)V"}, at={@At(value="RETURN")})
    private void attack(class_1297 target, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        ((PlayerAttackCallback)PlayerAttackCallback.EVENT.invoker()).onPlayerAttack(player, target);
    }

    @Inject(method={"method_6040()V"}, at={@At(value="RETURN")})
    private void consumeItem(CallbackInfo ci) {
        if (this.combat) {
            class_3222 player = (class_3222)this;
            CombatCooldownManager.consumeCooldowns(player);
        }
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="RETURN")})
    private void writeCustomData(class_11372 view, CallbackInfo ci) {
        view.method_71472(COMBAT_TAG_KEY, this.combat);
        view.method_71465(COMBAT_TAG_TICKS_KEY, this.ticksSinceCombat);
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="RETURN")})
    private void readCustomData(class_11368 view, CallbackInfo ci) {
        this.combat = view.method_71433(COMBAT_TAG_KEY, false);
        this.ticksSinceCombat = view.method_71424(COMBAT_TAG_TICKS_KEY, 0);
    }
}

